/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/
#include "NewMenu.h" // class's header file

NewMenu::NewMenu()
{
    init();
}

NewMenu::~NewMenu()
{
    outtext(LOGFILE,"Deleting Menu\n");
    for(int n=0 ; n<pages.size() ; n++)
    {
        for(int i=0 ; i<pages[n].nWidgets ; i++)
        {
            delete pages[n].widgets[i];
        }  
        delete[] pages[n].widgets;  
        delete[] pages[n].widgetTransitions; 
    }  
    outtext(LOGFILE,"Done Deleting Menu\n");  
}

void NewMenu::init(void)
{
    curPage=0;
    prevPage=0;
    quitMenu=false;
    quitGame=false;
}    

void NewMenu::create(void)
{
}

void NewMenu::addPage(TMenuPage newPage)
{
    pages.push_back(newPage);
}    

void NewMenu::reset(void)
{
    curPage=0;
    prevPage=0;
    quitMenu=false;
    quitGame=false;
}   


void NewMenu::setupPage(void)
{
    outtext(LOGFILE,"\nSetting up menu page\n");

    if(curPage>=0 && curPage<pages.size())
    {
        for(int n=0 ; n<pages[curPage].nWidgets ; n++)  //go through all of the widgets in the page definition
        {
            //widgets.push_back( /*new Widget(*(pages[curPage].widgets[n]))*/pages[curPage].widgets[n] );  //create a new widget copying the one from the definition    
            pages[curPage].widgets[n]->notMouseOver();
        }           
    }
    outtext(LOGFILE,"Done setting up menu page\n");    
}    
 

bool NewMenu::retQuitGame(void)
{
    /*if(key[KEY_ESC])
        return true;
    else*/
        return quitGame;
}        

//draws the menu
void NewMenu::draw(void)
{
    drawBackground();
    drawPage();
    drawMouse();
}
        
//updates the menu logic
//returns true when the menu is done
//returns false otherwise
bool NewMenu::update(void)
{
    mouse.x = (float)mouse_x/19 - 21,
    mouse.y = (float)(600-mouse_y)/19 - 16;
    mouse.b = mouse_b;
    
    for(int n=0 ; n<pages[curPage].nWidgets ; n++)
    {
        pages[curPage].widgets[n]->update(mouse);   
    }   
    
    TWidgetStatus s;
    for(int n=0 ; n<pages[curPage].nWidgets ; n++)
    {
        s = pages[curPage].widgets[n]->checkStatus(); 
        if(s.notify==true)
        {
            doTransition(s);
        }      
    }
 
    return quitMenu;
}   

void NewMenu::doTransition(TWidgetStatus s)
{
    int dest = pages[curPage].widgetTransitions[s.id];    
    
    if(dest==QUIT_MENU)
    {
        quitMenu=true;
        setResults();
    }    
    else if(dest==QUIT_GAME)
        quitGame=true;
    else if(dest==NO_TRANSITION)
    {
        //do nothing
        curPage = curPage;
    }      
    else
    {
        prevPage = curPage;
        curPage=dest;
        setupPage();
    }    
}    

void NewMenu::setResults(void)
{
    pageResults.clear();
    for(int n=0 ; n<pages[curPage].nWidgets ; n++)
    {
        pageResults.push_back ( pages[curPage].widgets[n]->checkStatus() );
    }
    gameModeResult = pages[curPage].gameModeResult;        
}    

void NewMenu::drawBackground()
{
    
}  
  
void NewMenu::drawPage()
{
    for(int n=0 ; n<pages[curPage].nWidgets; n++)
    {
        pages[curPage].widgets[n]->draw();
    }    
} 
   
void NewMenu::drawMouse(void)
{
    glDisable(GL_TEXTURE_2D);
    glBegin(GL_TRIANGLES);
        float blue[4]={0,0,1,1};
        glMaterialfv( GL_FRONT, GL_DIFFUSE, blue );
        //glColor3f(0,0,1);
        glNormal3f(0,0,1);
    
        glVertex3f(mouse.x,mouse.y,0);
        glVertex3f(mouse.x,mouse.y-1,0);
        glVertex3f(mouse.x+.5,mouse.y-.9,0);
    glEnd();
}

 

