/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/

#ifndef model_def
#define model_def

#include <cstdlib>
#include <cstdio>
#include <cmath>
#include <iostream>
#include <fstream>
#include <allegro.h>
#include <alleggl.h>
#include "Standards.h"

#include "CVector2.h"
#include "CVector3.h"
#include "Object.h"
#include "MS3d.h"       //the milkshape 3d structures

using namespace std;

typedef struct
{
    GLfloat *vArray;    //vertex  array
    GLfloat *nArray;    //normal array
    GLfloat *tcArray;   //tex coord array

}MeshArrays;

//a single triangle to make the model out of
typedef struct
{
    int iVertexIndex[3];    //indices to the three vertices that make of this face
    CVector3 v3Normal[3];   //the normals to each of the vertices
    float iSCoord[3], iTCoord[3]; //the s and t texture coordinates for each of the vertices 
}Face;

typedef struct
{
    int *iFaceIndex;    //an array of faces that the mesh is made up of
    int iNumFaces;      //the number of faces in this mesh
    int iMaterialIndex; //the index to the material the face is made from
}Mesh;

typedef struct
{
    //for the lighting
    float fAmbient[4], fDiffuse[4], fSpecular[4], fEmissive[4];
    float fShininess;
    
    int iTextureIndex;
    char *sTextureFilename;
}Material;


class Model : virtual public Object
{
private:
    CVector3 *vertices;     int iNumVertices;
    Face *faces;            int iNumFaces;
    Mesh *meshes;           int iNumMeshes;
    MeshArrays *meshArrays;
    
    Material *materials;    int iNumMaterials;


public:
    void draw(bool wireframe=false);
    void update(void) {}
    bool loadModel(char *filename);
    bool loadAllTextures(void);
    Model(void){}
    ~Model(void);


};

#endif
