/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/

#include "Model.h"

Model::~Model(void)
{
    /*if(vertices)
        delete(vertices);
    if(faces)
        delete(faces);
    if(meshes)
        delete(meshes);
    if(materials)
        delete(materials);*/
    for(int n=0 ; n<iNumMeshes ; n++)
    {
        delete [] meshArrays[n].vArray;  
        delete [] meshArrays[n].nArray;
        delete [] meshArrays[n].tcArray;
    }
    delete [] meshArrays;
}

bool Model::loadModel(char *filename)
{
    byte *bFile;
    char temp[20];
    
    char buf[100];
    sprintf(buf,"  load Model: %s\n",filename);
    outtext(LOGFILE,buf);
    
    //opens the file
    ifstream inputFile( filename, ios::in | ios::binary );
	if ( inputFile.fail())
		return false;	// "Couldn't Open The Model File."
    else
    {
        //seeks to the end, gets the file size, then seeks back to the start
	   inputFile.seekg( 0, ios::end );
	   long iFileSize = inputFile.tellg();
	   inputFile.seekg( 0, ios::beg );

	   bFile = new byte[iFileSize];     	//create an array of bytes to hold the file
	   inputFile.read( (char*)bFile, iFileSize );    //read the file into the array

	   inputFile.close(); //close the file
    }
    
    byte *pFilePos=bFile;    //current position in the model file
    
    
    ms3d_header_t *pHeader = ( ms3d_header_t* )pFilePos;    //head in the header
	pFilePos +=14;     //and advance the position in the file

    //checks the 'magic number' to make sure it is a valid milkshap3d file
    if ( strncmp( (char*)pHeader->id, "MS3D000000", 10 ) != 0 )
        return false;
        
    /*****************READ IN THE VERTICES*************************/
    iNumVertices = *(word*)pFilePos;   //read in the number of vertices
    pFilePos+=2/*sizeof(word)*/; //advance the file position
    
    //sprintf(temp,"iNumVertices: %d\n\n",iNumVertices);
    //outtext(LOGFILE,temp);


    vertices = new CVector3[iNumVertices];  //create the array of vertices
    
    for(int n=0 ; n<iNumVertices ; n++)
    {
        pFilePos++; //for the flags
        float x,y,z;
        x=*(float*)pFilePos;    pFilePos+=4;
        y=*(float*)pFilePos;    pFilePos+=4;
        z=*(float*)pFilePos;    pFilePos+=4;
        pFilePos++; //for the bone id
        pFilePos++; //for the refrence count
 
        vertices[n].setVector(x,y,z);

    }
    
    /***************READ IN THE FACES*******************************/
    iNumFaces = *(word*)pFilePos;
    pFilePos+=2/*sizeof(word)*/;
    
    faces = new Face[iNumFaces];
    
    //sprintf(temp,"iNumFaces: %d\n\n",iNumFaces);
    //outtext(LOGFILE,temp);
    
    
    for(int n=0 ; n<iNumFaces ; n++)
    {
/*        ms3d_triangle_t *triangle = (ms3d_triangle_t*)pFilePos;
        
        //copy the vertex indeces from the ms3d structure into the model
        //memcpy( faces[n].iVertexIndex, triangle->vertexIndices, sizeof( word )*3 );  
        for(int n2=0 ; n2<3 ; n2++)
            faces[n].iVertexIndex[n2] = triangle->vertexIndices[n2];


        //read in the t (x-axis) texture coordinates
        for(int n2=0 ; n2<3 ; n2++)
            faces[n].iTCoord[n2] = triangle->t[n2];
      
        //read in the s (y-axis) texture coordinates      
        for(int n2=0 ; n2<3 ; n2++)
            faces[n].iSCoord[n2] = 1.0 - triangle->s[n2];   //need to flip the y-axis because it differs in milkshape and opengl

        //load the vertex normals from the ms3d structure into the model's normals CVector3's
        for(int n2=0 ; n2<3 ; n2++)
            faces[n].v3Normal[n2].setVector(triangle->vertexNormals[n2][0],triangle->vertexNormals[n2][1],triangle->vertexNormals[n2][2]);
    
        pFilePos+=70;*/
        
        
        pFilePos+=2;     //for the flags
        
        for(int n2=0 ; n2<3 ; n2++)
        {
            faces[n].iVertexIndex[n2] = *(word*)pFilePos;    
            pFilePos+=2;
        }

        //load the vertex normals from the ms3d structure into the model's normals CVector3's
        for(int n2=0 ; n2<3 ; n2++)
        {
            float x,y,z;

            x = *(float*)pFilePos;  pFilePos+=4;
            y = *(float*)pFilePos;  pFilePos+=4;
            z = *(float*)pFilePos;  pFilePos+=4;
            
            faces[n].v3Normal[n2].setVector(x,y,z);
        }
        
        
        for(int n2=0 ; n2<3 ; n2++)
        {
            faces[n].iSCoord[n2] = (*(float*)pFilePos);   pFilePos+=4;
        }
        
        //read in the t (x-axis) texture coordinates
        for(int n2=0 ; n2<3 ; n2++)
        {
            faces[n].iTCoord[n2] = 1.0- (*(float*)pFilePos);   pFilePos+=4;
        }
        

        
        pFilePos++;
        pFilePos++;
    }
    
    
    /*************READ IN THE MESHES*********************************/
    iNumMeshes = *(word*)pFilePos;
    meshes = new Mesh[iNumMeshes];
    pFilePos += 2;
    
    for(int n=0 ; n<iNumMeshes ; n++)
    {
        pFilePos+=1;    //for the flags byte
        pFilePos+=32;   //for the name
        
        meshes[n].iNumFaces = *(word*)pFilePos; //read in the number of faces
        pFilePos+=2;
        
        //sprintf(temp,"iNumFaces2: %d\n\n",meshes[n].iNumFaces);
        //outtext(LOGFILE,temp);
        
        meshes[n].iFaceIndex = new int[meshes[n].iNumFaces];    //create the array to hold the face indices
        for(int n2=0 ; n2<meshes[n].iNumFaces ; n2++)
        {
            meshes[n].iFaceIndex[n2] = *(word*)pFilePos;    //read in an index
            pFilePos+=2;    //move the file pointer forward
        }
        
        meshes[n].iMaterialIndex=*(char*)pFilePos;
        pFilePos++;
    }
    
    //sprintf(temp,"iNumMeshes: %d\n\n",iNumMeshes);
    //outtext(LOGFILE,temp);
    
    
    /**************READ IN THE MATERIALS*********************************/
    iNumMaterials = *(word*)pFilePos;
    materials = new Material[iNumMaterials];
    pFilePos+=2;
    
    for(int n=0 ; n<iNumMaterials ; n++)
    {  
        pFilePos+=32;       //for the name
        memcpy( materials[n].fAmbient, pFilePos, 16 ); pFilePos+=16;
        memcpy( materials[n].fDiffuse, pFilePos, 16 ); pFilePos+=16;
        memcpy( materials[n].fSpecular, pFilePos, 16 ); pFilePos+=16;
        memcpy( materials[n].fEmissive, pFilePos, 16 ); pFilePos+=16;
        materials[n].fShininess = *(float*)pFilePos;     pFilePos+=4;
        pFilePos+=4;    //for the transparency
        pFilePos++;     //for the mode
        
        materials[n].sTextureFilename = new char[128];
        strcpy(materials[n].sTextureFilename,(char*)pFilePos);  pFilePos+=128;
        pFilePos+=128;  //for the alpha map
    }
    
    //sprintf(temp,"iNumMaterials: %d\n\n",iNumMaterials);
    //outtext(LOGFILE,temp);
    
    delete [] bFile;
    
    
    meshArrays = new MeshArrays[iNumMeshes];
    int c=0,c2;
    for(int n=0 ; n<iNumMeshes ; n++)
    {
        c=0;c2=0;
        //allocate space for all the vertices (each face has 3 vertices, and each vertex has 3 points
        meshArrays[n].vArray = new GLfloat[meshes[n].iNumFaces*3*3];    
        //allocate space for all the normals (each face has 3 normals, and each normal has 3 points
        meshArrays[n].nArray = new GLfloat[meshes[n].iNumFaces*3*3]; 
        //allocate space for all the texture coords (each face has 3 texture coords, and each texture coord has 2 points
        meshArrays[n].tcArray = new GLfloat[meshes[n].iNumFaces*3*2];
    
        for(int i=0 ; i<meshes[n].iNumFaces ; i++)  //go through all of the faces
        {
            int iFaceIndex = meshes[n].iFaceIndex[i];
            Face* pFace = &faces[iFaceIndex];

            for(int j=0 ; j<3 ; j++)    //go through all of the vertices in the face
            {
                meshArrays[n].nArray[c+0] = pFace->v3Normal[j].x;
                meshArrays[n].nArray[c+1] = pFace->v3Normal[j].y;
                meshArrays[n].nArray[c+2] = pFace->v3Normal[j].z;
                
                //meshArrays[n].tcArray[c+0] = pFace->iSCoord[j];
                //meshArrays[n].tcArray[c+1] = pFace->iTCoord[j];
                
                meshArrays[n].tcArray[c2 +0] = pFace->iSCoord[j];
                meshArrays[n].tcArray[c2 +1] = pFace->iTCoord[j];
                /*glNormal3f(pFace->v3Normal[j].x,pFace->v3Normal[j].y,pFace->v3Normal[j].z);
                glTexCoord2f(pFace->iSCoord[j],pFace->iTCoord[j]);
                */
                //if(pFace->iVertexIndex[j]<iNumVertices)
                {
                    CVector3 *vector = &vertices[pFace->iVertexIndex[j]];

                    //glVertex3f(vector->x,vector->y,vector->z);
                    meshArrays[n].vArray[c+0] = vector->x;
                    meshArrays[n].vArray[c+1] = vector->y;
                    meshArrays[n].vArray[c+2] = vector->z;
                }
                c+=3;
                c2+=2;
            }
        }
    }
    
    glEnableClientState(GL_VERTEX_ARRAY);
    glEnableClientState(GL_NORMAL_ARRAY);
    glEnableClientState(GL_TEXTURE_COORD_ARRAY);
    
    delete []faces;
    delete []vertices;
    for(int n=0 ; n<iNumMeshes ; n++)
        delete[] meshes[n].iFaceIndex;
    
    return true;
}

bool Model::loadAllTextures(void)
{
    outtext(LOGFILE,"  load model textures\n");
    for(int n=0 ; n<iNumMaterials ; n++)
    {
        if(strlen(materials[n].sTextureFilename)>0) //if there is a texture filename
        {
            materials[n].iTextureIndex = loadTexture(materials[n].sTextureFilename);
            
            outtext(LOGFILE,"  texture loaded: ");
            outtext(LOGFILE,materials[n].sTextureFilename);
            outtext(LOGFILE,"\n");
        }
        else
            materials[n].iTextureIndex=0;
    }
}

void Model::draw(bool wireframe)
{
    int iMaterialIndex=-1,oldMaterialIndex=-1;
    for(int n=0 ; n<iNumMeshes ; n++)
    {
    
        //set the material for the mesh
        oldMaterialIndex = iMaterialIndex;
        iMaterialIndex = meshes[n].iMaterialIndex;
        
        if(iMaterialIndex>=0 && iMaterialIndex!=oldMaterialIndex && wireframe==false)
        {
            glMaterialfv( GL_FRONT, GL_AMBIENT, materials[iMaterialIndex].fAmbient );
            glMaterialfv( GL_FRONT, GL_DIFFUSE, materials[iMaterialIndex].fDiffuse );
            glMaterialfv( GL_FRONT, GL_SPECULAR, materials[iMaterialIndex].fSpecular );
            glMaterialfv( GL_FRONT, GL_EMISSION, materials[iMaterialIndex].fEmissive );
            glMaterialf( GL_FRONT, GL_SHININESS, materials[iMaterialIndex].fShininess );

            if(materials[iMaterialIndex].iTextureIndex > 0) //there is a texture for this material
            {
                glBindTexture(GL_TEXTURE_2D,materials[iMaterialIndex].iTextureIndex);
                glEnable(GL_TEXTURE_2D);
            }
            else
                glDisable(GL_TEXTURE_2D);
        }
            
        

        //glEnableClientState(GL_TEXTURE_COORD_ARRAY);
        
        
        
        
        glVertexPointer(3,GL_FLOAT,0,meshArrays[n].vArray);
        glNormalPointer(GL_FLOAT,0,meshArrays[n].nArray);
        glTexCoordPointer(2,GL_FLOAT,0,meshArrays[n].tcArray);
        
       if(wireframe==true)
            glDrawArrays(GL_LINE_STRIP,0,meshes[n].iNumFaces*3);
       else
           glDrawArrays(GL_TRIANGLES,0,meshes[n].iNumFaces*3);
        
        /*glPushMatrix();
        glScalef(3,3,3);
        //glDrawArrays(GL_TRIANGLES,0,meshes[n].iNumFaces*3*3);
        glBegin(GL_TRIANGLES);
        for(int k=0 ; k<meshes[n].iNumFaces*3 ; k++)
        {
            
            glArrayElement(k);
            //glArrayElement(k);
            //glArrayElement(k);
        }
        glEnd();
        
        glPopMatrix();*/
        /*int c=0;
        glBegin(GL_TRIANGLES);
        for(int i=0 ; i<meshes[n].iNumFaces ; i++)  //go through all of the faces
        {
            for(int j=0 ; j<3 ; j++)
            {      
                glArrayElement(c+0);
                glArrayElement(c+1);
                glArrayElement(c+2);
                c+=3;
            }
        }  
        glEnd();*/
        

        //glDisableClientState(GL_TEXTURE_COORD_ARRAY);
        //glDisableClientState(GL_NORMAL_ARRAY);
/*        
        int c=0;
        if(wireframe==true)
            glBegin(GL_LINE_STRIP);
        else
            glBegin(GL_TRIANGLES);
            
            for(int i=0 ; i<meshes[n].iNumFaces ; i++)  //go through all of the faces
            {
                int iFaceIndex = meshes[n].iFaceIndex[i];
                Face* pFace = &faces[iFaceIndex];

                for(int j=0 ; j<3 ; j++)
                {
                    //glNormal3f(pFace->v3Normal[j].x,pFace->v3Normal[j].y,pFace->v3Normal[j].z);
                    //glTexCoord2f(pFace->iSCoord[j],pFace->iTCoord[j]);
                    
                    //if(pFace->iVertexIndex[j]<iNumVertices)
                    {
                        //CVector3 *vector = &vertices[pFace->iVertexIndex[j]];

                glArrayElement(c);
                //glArrayElement(i*9+j*3+1);
                //glArrayElement(i*9+j*3+2);
                        c++;
                        //glVertex3f(vector->x,vector->y,vector->z);
                    }
                }
            
            }
 
        
               
        
        glEnd();*/
        //glDisableClientState(GL_VERTEX_ARRAY);
        //glDisableClientState(GL_NORMAL_ARRAY);
    }
    glDisable(GL_TEXTURE_2D);
}
