/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/

#ifndef MISSILEAVOID2P_H
#define MISSILEAVOID2P_H

#include "GameMode.h" // inheriting class's header file

#include "CVector2.h"
#include "Arena.h"
#include "Game.h"

#include "NewMenu.h"
#include "Button.h"
#include "CheckBox.h"
#include "Player.h"
#include "Turret.h"

#include "MissileAvoid.h"

class MissileAvoid2p : public MissileAvoid
{
public:
    MissileAvoid2p(NewMenu *m);
    ~MissileAvoid2p();
    
    void setUpGame(Game *game);
    CVector2 getPlayerStartPos(int n);    //returns the start position for player's ship
    int getPlayerShipNum(int n);
    
    int getWeaponsSet(int n);
    
    void writeStats(Game *g);
    TMenuPage createMenuPage(FONT **allFonts,TButtonAtts bAtts, int prevPage,Model *allModels, ShipArray *sa, Game *g); //creates a menu page to set up this game mode

    void runInGame(Game *g);
};

#endif // MISSILEAVOID2P_H

