/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/

#include "MissileAvoid2p.h" // class's header file

extern FONT* allFonts[20];

MissileAvoid2p::MissileAvoid2p(NewMenu *m) : MissileAvoid(m)
{
}

// class destructor
MissileAvoid2p::~MissileAvoid2p()
{
}

void MissileAvoid2p::setUpGame(Game *game)
{
    MissileAvoid::setUpGame(game);
    
    TPlayerAtts p2a;
    strcpy(p2a.sName,"Player2");
    p2a.iColour=0;
    p2a.starting_lives=-1;
    p2a.startX=getPlayerStartPos(1).retX();
    p2a.startY=getPlayerStartPos(1).retY();
    
    game->setPlayerAtts(1,p2a,0);   //set up player2 to have the same team id as player 1 (so they can't hurt each other)
}
    
CVector2 MissileAvoid2p::getPlayerStartPos(int n)    //returns the start position for player's ship
{
    if(n==1)    //second player
        return makeVector2(-31,-20,true); 
    else
        return MissileAvoid::getPlayerStartPos(n);
}
    
int MissileAvoid2p::getPlayerShipNum(int n)
{
    if(n==1)    //second player
        return 2;
    else
        return MissileAvoid::getPlayerShipNum(n);
        
}    
    
int MissileAvoid2p::getWeaponsSet(int n)
{
    if(n==1)    //second player
        return 6;   //concussion balls
    else
        return MissileAvoid::getWeaponsSet(n);
}    
    
TMenuPage MissileAvoid2p::createMenuPage(FONT **allFonts,TButtonAtts bAtts, int prevPage,Model *allModels, ShipArray *sa, Game *g) //creates a menu page to set up this game mode
{
    TMenuPage page = MissileAvoid::createMenuPage(allFonts,bAtts,prevPage,allModels,sa,g);
    page.gameModeResult=GM_MISSILE_AVOID2;
    return page;
}    

void MissileAvoid2p::writeStats(Game *g)
{

    char buf[100];
    
    for(int n=0 ; n<2 ; n++)
    {
        int xx;
        if(n==0){
            xx=500;
            writeText_2D(xx,130,0,makecol(200,250,200),allFonts[4],"Player1");
        }    
        else{
            xx=70;
            writeText_2D(xx,130,0,makecol(200,250,200),allFonts[4],"Player2");
        }
            
        if(n==1)    //only player 2 can shoot
        {
            sprintf(buf,"Projectiles Fired: %d",g->retPlayer(n)->retShip()->stats.shotsFired);
            writeText_2D(xx,160,0,makecol(200,200,200),allFonts[4],buf);
            sprintf(buf,"Projectiles Hit: %d",g->retPlayer(n)->retShip()->stats.shotsHit);
            writeText_2D(xx,180,0,makecol(200,200,200),allFonts[4],buf);
            
            if(g->retPlayer(n)->retShip()->stats.shotsFired==0)
                sprintf(buf,"Accuracy: 100 percent");
            else
                sprintf(buf,"Accuracy: %d percent",(int)(((float)g->retPlayer(n)->retShip()->stats.shotsHit/(float)g->retPlayer(n)->retShip()->stats.shotsFired)*100));
            writeText_2D(xx,200,0,makecol(200,200,200),allFonts[4],buf);
        }

        
        sprintf(buf,"Longest No-Hit Streak: %d seconds",(int)((float)g->retPlayer(n)->retShip()->stats.longestStreak/32));
        writeText_2D(xx,230,0,makecol(200,200,200),allFonts[4],buf); 

        sprintf(buf,"Shield Lost To Walls: %d",g->retPlayer(n)->retShip()->stats.shieldLostToWalls);
        writeText_2D(xx,250,0,makecol(200,200,200),allFonts[4],buf);  
        
        if((*(menu->getResults()))[4].value==CB_SELECTED)  //check to see if asteroids are on
        {
            sprintf(buf,"Asteroids Killed: %d",g->retPlayer(n)->retShip()->stats.asteroidsKilled);
            writeText_2D(xx,280,0,makecol(200,200,200),allFonts[4],buf);      
            sprintf(buf,"Hit By Asteroids: %d",g->retPlayer(n)->retShip()->stats.hitByAsteroid);
            writeText_2D(xx,300,0,makecol(200,200,200),allFonts[4],buf);     
            sprintf(buf,"Killed By Asteroids: %d",g->retPlayer(n)->retShip()->stats.killedByAsteroid);
            writeText_2D(xx,320,0,makecol(200,200,200),allFonts[4],buf); 
        }    
    }        
    //writeText_3D(10,16,40,makecol(255,255,255),allFonts[1],"hello");  

}  

void MissileAvoid2p::runInGame(Game *g)
{
    MissileAvoid::runInGame(g);
}    

