/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/

#ifndef MISSILEAVOID_H
#define MISSILEAVOID_H

#include "GameMode.h" // inheriting class's header file

#include "CVector2.h"
#include "Arena.h"
#include "Game.h"

#include "NewMenu.h"
#include "Button.h"
#include "CheckBox.h"
#include "Player.h"
#include "Turret.h"

#define MAX_TURRETS 10

class MissileAvoid : public GameMode
{
private:
    int turret_id[MAX_TURRETS];
    int nTurrets;    
public:
    MissileAvoid(NewMenu *m);
    ~MissileAvoid();
    
    void setUpGame(Game *game);
    CVector2 getPlayerStartPos(int n);    //returns the start position for player's ship
    int getPlayerShipNum(int n);
    
    int getWeaponsSet(int n);
    void writeStats(Game *g);
    
    TMenuPage createMenuPage(FONT **allFonts,TButtonAtts bAtts, int prevPage,Model *allModels, ShipArray *sa, Game *game); //creates a menu page to set up this game mode

    void runInGame(Game *g);
};

#endif // MISSILEAVOID_H

