/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/

#include "MissileAvoid.h" // class's header file

extern FONT* allFonts[20];

MissileAvoid::MissileAvoid(NewMenu *m) : GameMode(m)
{
}

MissileAvoid::~MissileAvoid()
{
}

void MissileAvoid::setUpGame(Game *game)
{
    CVector2
        pos(0,0,true),
        vel(0,0,false);
        
    CVector2 arena_top(-49,-38), arena_bot(49,38),
             p1(-46,-26) , p2(-45,35) , p3(46,34) , p4(44,-26);;
    
    Arena arena;
    arena.setBRect(arena_top,arena_bot,pos,vel);
       
    
    arena.addWall(p1,p2);
    arena.addWall(p2,p3);
    arena.addWall(p3,p4);
    arena.addWall(p4,p1);   

    game->setArena(arena);
    
    strcpy(gameModeName,"Missile Avoid");
    (ScoreKeeper::instance())->reset(INCREASING_TIME);    
    (ScoreKeeper::instance())->setTimeLeft(0);
    
    if((*(menu->getResults()))[2].value==CB_SELECTED)  //check enable asteroids checkbox
        game->startAsteroidsGame();
        
    nTurrets=1;
    for(int n=0 ; n<nTurrets ; n++)
    {
        TPlayerAtts ta;
        turret_id[n] = game->addPlayer(new Turret());
        game->setPlayerAtts(turret_id[n],ta,1);
    } 
    TPlayerAtts p1a;   
    strcpy(p1a.sName,"Player1");
    p1a.iColour=0;
    p1a.starting_lives=3;
    p1a.startX=getPlayerStartPos(0).retX();
    p1a.startY=getPlayerStartPos(0).retY();
    
    game->setPlayerAtts(0,p1a,0);   //set up the player's atts (put it on team 0)
    
    
}
    
CVector2 MissileAvoid::getPlayerStartPos(int n)    //returns the start position for player's ship
{
    CVector2 pos(0,0,true);
    if(n==0)    //start pos for player 1
    {
        pos.setVector(31,-20,true);
        return pos;
    } 
       
    for(int i=0 ; i<nTurrets ; i++)
    {
        if(turret_id[i] == n)   //it is a turret
        {
            if(i==0)
                pos.setVector(0,0,true);
            else if(i==1)
                pos.setVector(-10,7,true);
            else if(i==2)
                pos.setVector(10,-7,true);
                
            return pos;
        }    
        
    }    
}
    
int MissileAvoid::getPlayerShipNum(int n)
{
    for(int i=0 ; i<nTurrets ; i++)
    {
        if(turret_id[i] == n)   //it is a turret
            return 8;           //return the missile launcher ship
    }    
        
    return 1;   //the crysblade for the player
}    

int MissileAvoid::getWeaponsSet(int n)
{
    
    for(int i=0 ; i<nTurrets ; i++)
    {
        if(turret_id[i] == n)   //it is a turret
            return 4;           //just homing missiles
    }    
    
    return 3;   //no weapons
}    

TMenuPage MissileAvoid::createMenuPage(FONT **allFonts,TButtonAtts bAtts, int prevPage,Model *allModels, ShipArray *sa, Game *game) //creates a menu page to set up this game mode
{
    TMenuPage page;
    
    page.nWidgets=4;
    page.widgets = new Widget* [4];
    page.widgetTransitions = new int[4];
    
    page.widgets[0] = new Button(0,makeVector2(0,1.5,true),4.5,2.45,allFonts[2],"Play",bAtts);
    page.widgetTransitions[0] = QUIT_MENU;

    page.widgets[1] = new Button(1,makeVector2(0,-6,true),5,2.45,allFonts[2],"Back",bAtts);
    page.widgetTransitions[1] = prevPage;
    
    page.widgets[2] = new CheckBox(2,makeVector2(-15,-10,true),1,1,allFonts[4],"Asteroids On",bAtts,false);
    page.widgetTransitions[2] = NO_TRANSITION;    
    
    page.widgets[3] = new CheckBox(3,makeVector2(0,-10,true),1,1,allFonts[4],"Maniac Mode",bAtts,false);
    page.widgetTransitions[3] = NO_TRANSITION;    
    
    page.gameModeResult=GM_MISSILE_AVOID;
    
    return page; 
}    

void MissileAvoid::writeStats(Game *g)
{
    char buf[100];
    
    int xx;
    xx=500;
    writeText_2D(xx,130,0,makecol(200,250,200),allFonts[4],"Player1");  
  
    sprintf(buf,"Longest No-Hit Streak: %d seconds",(int)((float)g->retPlayer(0)->retShip()->stats.longestStreak/32));
    writeText_2D(xx,230,0,makecol(200,200,200),allFonts[4],buf); 

    sprintf(buf,"Shield Lost To Walls: %d",g->retPlayer(0)->retShip()->stats.shieldLostToWalls);
    writeText_2D(xx,260,0,makecol(200,200,200),allFonts[4],buf);   

    if((*(menu->getResults()))[2].value==CB_SELECTED) //check to see if asteroids are on
    {   
        sprintf(buf,"Hit By Asteroids: %d",g->retPlayer(0)->retShip()->stats.hitByAsteroid);
        writeText_2D(xx,300,0,makecol(200,200,200),allFonts[4],buf);     
        sprintf(buf,"Killed By Asteroids: %d",g->retPlayer(0)->retShip()->stats.killedByAsteroid);
        writeText_2D(xx,320,0,makecol(200,200,200),allFonts[4],buf); 
    }        
}

void MissileAvoid::runInGame(Game *g)
{
    if(menu)
    {
        /*************RUNS MANIAC MODE******************/
        if((*menu->getResults())[3].value==CB_SELECTED)   //if the Maniac Mode is selected
        {
            for(int n=0 ; n<g->retNumPlayers() ; n++)
            {
                g->retShip(n)->thrust();
                g->retShip(n)->thrust();
            }    
        }
    } 
    
    if(g->retPlayer(0)->retLives()==0){
        g->endGame("Game Over");
    }  
}    
