#ifndef menu_def
#define menu_def

#include <cstdlib>
#include <cstdio>
#include <cmath>
#include <allegro.h>
#include <alleggl.h>
#include "Standards.h"

#include "BRect.h"
#include "Widget.h"
#include "Model.h"
#include "Weapon.h"
#include "Animation.h"
#include "SObject.h"
#include "Arena.h"
#include "PObject.h"
#include "Ship.h"
#include "ShipArray.h"
#include "Proj.h"
#include "Part.h"

#include "Client.h"
#include "Server.h"

#define MAX_BUTTONS 20

#define START_GAME  -1
#define SELECT_SHIP 0
#define MAIN_MENU   1
#define GAME_MENU   2
#define ONE_PLAYER_MENU 3
#define TWO_PLAYER_MENU 4
#define LOBBY_MENU  5
#define GET_IP_MENU  6


#define ONE_PLAYER      0
#define TWO_PLAYER      1
#define INTERNET_HOST   2
#define INTERNET_JOIN   3

class Menu
{
private:
    Widget button[MAX_BUTTONS];
    int iNumButtons;
    
    ShipArray *shipDefs;
    
    Ship demoShip;
    BRect pilotPic;
    int iDemoShipNum;
    Model *allModels;
    
    float mx,my;
    int wait;
    
    float barPercent[6];
    
    BRect panel1, panel2, panel3;
    BRect mainLeft, mainRight,mainBottom;
    BRect onePlayerLeft, onePlayerRight, onePlayerBottom;
    BRect lobbyLeft, lobbyRight, lobbyBottom;
    BRect ipMenu;
    
    float fSlide1, fSlide2, fSlide3,fSlideVel;
    bool bOpening,bDone;
    
    char name[40];
    
    int iMenuNum,iNextMenuNum;
    int iGameType;
    
    bool bQuitGame;
    
    int iP1Ship, iP2Ship;
    int iWhichPlayer;
    
    char sAddress[20];

    Server *server;
    Client *client;
public:
    void init(void);
    void create(int num);
    void reset(int num);
    void setServer(Server *_server) {server = _server;}
    void setClient(Client *_client) {client = _client;}
    void setModels(Model *_allModels) {allModels = _allModels;}
    
    void draw(void);
    bool update(void);
    
    void drawMouse(void);
    
    //for the main menu
    void drawMainLeft(void);
    void drawMainRight(void);
    void drawMainBottom(void);
    
    //for the select ship menu
    void drawShip(void);
    void drawPilot(void);
    void drawStartButton(void);
    
    //for the one player menu
    void drawOnePlayerLeft(void);
    void drawOnePlayerRight(void);
    void drawOnePlayerBottom(void);
    
    //for the one player menu
    void drawTwoPlayerLeft(void);
    void drawTwoPlayerRight(void);
    void drawTwoPlayerBottom(void);
    
    //for the lobby menu
    void drawLobbyLeft(void);
    void drawLobbyRight(void);
    void drawLobbyBottom(void);
    
    void drawGetIP(void);
    
    void updateDemoShip(void);
    void setDemoShip(int n);
    
    
    void addButton(float x, float y, float w, float h, char *filename, char *caption);
    
    void setShipDefs(ShipArray *_shipDefs);
    ShipArray* retShipDefs(void) {return shipDefs;}
    int retP1Ship(void) {return iP1Ship; }
    int retP2Ship(void) {return iP2Ship; }
    char* retName(void) {return name;}
    bool retQuitGame(void) {return bQuitGame;}
    int retNextMenu(void) {return iNextMenuNum;}
    int retGameType(void) {return iGameType;}
    char* retAddress(void) {return sAddress;}
    int retCurMenu(void) {return iMenuNum;}
    
    void endMenu(void);
    
    Menu(void) {init();}
    ~Menu(void) {}

};

#endif

