#include "Menu.h"

extern FONT* agl_font;
extern FONT* allFonts[20];

void Menu::addButton(float x, float y, float w, float h, char *filename, char *caption)
{
    if(iNumButtons<MAX_BUTTONS)
    {
        CVector2 pos(x,y,true);
        button[iNumButtons].setButton(filename,pos,w,h);
        button[iNumButtons].setCaption(caption);
       // button[iNumButtons].setFont(font);
        iNumButtons++;
    }
}

void Menu::create(int num)
{    
    strcpy(name,"");
    
    panel1.setPict(21,33,"images/panel.bmp");
    panel2.setPict(20,33,"images/panel2.bmp");
    panel3.setPict(15,7,"images/panel3.bmp");
    
    mainLeft.setPict(22.1,33.5,"images/main_panel_left.bmp");
    mainRight.setPict(22.1,33.5,"images/main_panel_right.bmp");
    mainBottom.setPict(18,18,"images/title.bmp");
    
    onePlayerLeft.setPict(21,33,"images/one_player_panel_left.bmp");
    onePlayerRight.setPict(20,33,"images/one_player_panel_right.bmp");
    onePlayerBottom.setPict(15,7,"images/one_player_panel_bottom.bmp");
    
    lobbyLeft.setPict(21,33,"images/one_player_panel_left.bmp");
    lobbyRight.setPict(20,33,"images/one_player_panel_right.bmp");
    lobbyBottom.setPict(15,7,"images/one_player_panel_bottom.bmp");
    
    ipMenu.setPict(15,7.5,"images/ip_menu.bmp");
    
    iMenuNum=num;

}

void Menu::init(void)
{
    iNumButtons=0;
    for(int n=0 ; n<MAX_BUTTONS ; n++)
        button[n].init();
    mx=0; my=0;
    iDemoShipNum=0;
    wait=0;
    
    for(int n=0 ; n<6 ; n++)
        barPercent[n]=.5;
        
    bOpening=false; bDone=false;
    /*fSlide1=-21;
    fSlide2=21;
    fSlide3=-10;*/
    
    fSlide1=0;
    fSlide2=0;
    fSlide3=0;
    
    fSlideVel=.5;
    
    iMenuNum=0; iNextMenuNum=0;
    bQuitGame=false;
    iGameType=0;
    
    iP1Ship=0;
    iP2Ship=0;
    iWhichPlayer=0;
    
    strcpy(sAddress,"192.168.2.100");
}

void Menu::reset(int num)
{
    bOpening=false; bDone=false;
    fSlide1=0;
    fSlide2=0;
    fSlide3=0;
    
    wait=0;
    
    for(int n=0 ; n<4 ; n++)
        barPercent[n]=.5;
        
    strcpy(name,"");
    
    iMenuNum = num; iNextMenuNum = num;
    
    iNumButtons=0;
    
    if(iMenuNum==SELECT_SHIP)
    {
        addButton(-7  , 3.5 , 2 ,2  ,"images/button_right.bmp","Next");
        addButton(-16 , 3.5 , 2 ,2  ,"images/button_left.bmp","Prev");
        addButton(-1   , -14 , 13.3   ,2.7,"images/button_continue.bmp","ShipContinue");
    }
    else if(iMenuNum==MAIN_MENU)
    {

        addButton(0   , -1 , 13.3   ,2.5,"images/button_start1.bmp","Start1");
        addButton(0  ,  -3.5 , 13.3   ,2.5,"images/button_start2.bmp","Start2");
        addButton(0  ,  -6 , 13.3   ,2.5,"images/button_start3.bmp","Start3");
        addButton(0  ,  -8.5 , 13.3   ,2.5,"images/button_start4.bmp","Start4");
        addButton(0   ,  -11 , 13.3   ,2.5,"images/button_options.bmp","Options");
        addButton(0   ,  -13.5 , 13.3   ,2.5,"images/button_exit.bmp","Exit");
        
        addButton(0   , 2 , 13.3   ,2.7,"images/button_continue.bmp","IPContinue");
    }
    else if(iMenuNum==ONE_PLAYER_MENU)
    {
        addButton(-1   , -14 , 13.3   ,2.7,"images/button_continue.bmp","1PContinue");
    }
    else if(iMenuNum==TWO_PLAYER_MENU)
    {
        addButton(-1   , -14 , 13.3   ,2.7,"images/button_continue.bmp","1PContinue");
        addButton(-10   , 3 , 13.3   ,2.7,"images/button_ship1.bmp","1PShip");
        addButton(-10   , 0 , 13.3   ,2.7,"images/button_ship2.bmp","2PShip");   
    }
    else if(iMenuNum==LOBBY_MENU)
    {
        addButton(-1   , -14 , 13.3   ,2.7,"images/button_continue.bmp","1PContinue");
    }
}

void Menu::setShipDefs(ShipArray *_shipDefs)
{ 
    shipDefs = _shipDefs;
    setDemoShip(iDemoShipNum);
}

void Menu::setDemoShip(int n)
{
    CVector2 pos(0,0),vel(0,0);
    TShipDef def = shipDefs->retShipDef(n);
    
    demoShip.setBCirc(def.fCircRadius,pos,vel);
    //demoShip.setModel(def.sModelFilename);
    demoShip.setModel(&allModels[def.iModelNum]);
    demoShip.setAtts(def.atts);
    
    pilotPic.setPict(7,10.5,def.sPilotFilename);
    
    
    if(iWhichPlayer==0)
        iP1Ship = n;
    else if(iWhichPlayer==1)
        iP2Ship = n;
}

void Menu::drawMouse(void)
{
    glDisable(GL_TEXTURE_2D);
    glBegin(GL_TRIANGLES);
        float blue[4]={0,0,1,1};
        glMaterialfv( GL_FRONT, GL_DIFFUSE, blue );
        //glColor3f(0,0,1);
        glNormal3f(0,0,1);
    
        glVertex3f(mx,my,0);
        glVertex3f(mx,my-1,0);
        glVertex3f(mx+.5,my-.9,0);
    glEnd();
}

void Menu::drawShip(void)
{
    static float num=0;
    num+=.25;
    
    
    glEnable(GL_BLEND);
        glBlendFunc(GL_SRC_COLOR, GL_ONE);
        //panel1.drawPict(makeVector2(-11,0,true));
    glDisable(GL_BLEND);
    
    
    glPushMatrix();
        glTranslatef(-7.5,7,11);
        glRotatef(num,1,1,1);
        demoShip.draw();
    glPopMatrix();
    
    
    glPushMatrix();
        glTranslatef(-3,8,15);
        glScalef(.4,.4,.4);
        demoShip.draw(true);
    glPopMatrix();
    
    
    TShipAtts atts = shipDefs->retShipAtts(iDemoShipNum);    
    RGB c1={80,0,0} , c2={50,50,50};
    
    writeText(-19.8,2,0,makeacol32(0,100,200,255),allFonts[0],shipDefs->retShipName(iDemoShipNum));

    
    writeText(-18,1   ,0,makeacol32(0,100,200,255),allFonts[1],"Acceleration");
    drawBar(-13,  0   ,0,8,.8,barPercent[0],c1,c2);
    
    writeText(-18,-0.5 ,0,makeacol32(0,100,200,255),allFonts[1],"Max Speed");
    drawBar(-13,  -1.5 ,0,8,.8,barPercent[1],c1,c2);
    
    writeText(-18,-2   ,0,makeacol32(0,100,200,255),allFonts[1],"Rot Thrust");
    drawBar(-13,  -3   ,0,8,.8,barPercent[2],c1,c2);
    
    writeText(-18,-3.5 ,0,makeacol32(0,100,200,255),allFonts[1],"Traction");
    drawBar(-13,  -4.5 ,0,8,.8,barPercent[3],c1,c2);
    
    writeText(-18,-5   ,0,makeacol32(0,100,200,255),allFonts[1],"Armor");
    drawBar(-13  ,-6 ,0,8,.8,barPercent[4],c1,c2);
    
    writeText(-18,-6.5 ,0,makeacol32(0,100,200,255),allFonts[1],"Shield");
    drawBar(-13  ,-7.5 ,0,8,.8,barPercent[5],c1,c2);
    
            
    
    button[0].draw();
    button[1].draw();
}

void Menu::drawPilot(void)
{
    glEnable(GL_BLEND);
        glBlendFunc(GL_SRC_COLOR, GL_ONE);
        //panel2.drawPict(makeVector2(10,0,true));
    glDisable(GL_BLEND);
    
    pilotPic.drawPict(makeVector2(4.9,8,true));
    
    char temp[56];
    
    sprintf(temp,"Allegiance: %s",shipDefs->retPilotNation(iDemoShipNum));
    writeText(8.8,12,0,makecol(0,100,200),allFonts[1],temp);
    
    sprintf(temp,"Title: %s",shipDefs->retPilotRank(iDemoShipNum));
    writeText(8.8,10,0,makecol(0,100,200),allFonts[1],temp);
    
    sprintf(temp,"Name: %s",shipDefs->retPilotName(iDemoShipNum));
    writeText(8.8,8,0,makecol(0,100,200),allFonts[1],temp);
}

void Menu::drawStartButton(void)
{
    glEnable(GL_BLEND);
        glBlendFunc(GL_SRC_COLOR, GL_ONE);
        //panel3.drawPict(makeVector2(-1,-13,true));
    glDisable(GL_BLEND);


    writeText(-4,-10,0,makecol(0,0,0),allFonts[1],"Enter Your Name");
    doText(name);
    writeText(-6,-11,0,makecol(0,0,0),allFonts[1],name);

    button[2].draw();
}


void Menu::updateDemoShip(void)
{
    TShipAtts atts = shipDefs->retShipAtts(iDemoShipNum);
    
    if(barPercent[0] < (atts.fAccel-.003)/.0074 - .02)
        barPercent[0]+=.02;
    else if(barPercent[0] > (atts.fAccel-.003)/.0074 + .02)
        barPercent[0]-=.02;
        
    if(barPercent[1] < (atts.fMaxVel-.3)/.4 - .02)
        barPercent[1]+=.02;
    else if(barPercent[1] > (atts.fMaxVel-.3)/.4 + .02)
        barPercent[1]-=.02;
        
    if(barPercent[2] < (atts.fAngAccel-.007)/.013 - .02)
        barPercent[2]+=.02;
    else if(barPercent[2] > (atts.fAngAccel-.007)/.013 + .02)
        barPercent[2]-=.02;

    /*if(barPercent[3] < (atts.fDampening - .96)/.038 - .02)
        barPercent[3]+=.02;
    else if(barPercent[3] > (atts.fDampening - .96)/.038 + .02)
        barPercent[3]-=.02;*/

    if(barPercent[3] < (1-atts.fDampening )/.05 - .02)
        barPercent[3]+=.02;
    else if(barPercent[3] > (1-atts.fDampening )/.05 + .02)
        barPercent[3]-=.02;

    if(barPercent[4]*100 < atts.armor -2)
        barPercent[4]+=.02;
    else if(barPercent[4]*100 > atts.armor +2)
        barPercent[4]-=.02;
        
    if(barPercent[5]*100 < atts.shield -2)
        barPercent[5]+=.02;
    else if(barPercent[5]*100 > atts.shield +2)
        barPercent[5]-=.02;


    if(bOpening==true)
    {
        fSlide1-=fSlideVel;
        fSlide2+=fSlideVel;
        fSlide3-=fSlideVel;
        
        if(fSlide1<-22)
            bDone=true;
        
        fSlideVel+=.1;
    }
}

void Menu::draw(void)
{
    if(iMenuNum==MAIN_MENU)
    {
        glPushMatrix();
            glTranslatef(fSlide1,0,0);
            drawMainLeft();
        glPopMatrix();
    
        glPushMatrix();    
            glTranslatef(fSlide2,0,0);
            drawMainRight();
        glPopMatrix();  
        
        glPushMatrix();    
            glTranslatef(0,fSlide3,0);
            drawMainBottom();
        glPopMatrix();  
    }
    else if(iMenuNum==ONE_PLAYER_MENU)
    {
        glPushMatrix();
            glTranslatef(fSlide1,0,0);
            drawOnePlayerLeft();
        glPopMatrix();
    
        glPushMatrix();    
            glTranslatef(fSlide2,0,0);
            drawOnePlayerRight();
        glPopMatrix();    
        
        glPushMatrix();        
            glTranslatef(0,fSlide3,0);
            drawOnePlayerBottom();
        glPopMatrix();
    }
    else if(iMenuNum==TWO_PLAYER_MENU)
    {
        glPushMatrix();
            glTranslatef(fSlide1,0,0);
            drawTwoPlayerLeft();
        glPopMatrix();
    
        glPushMatrix();    
            glTranslatef(fSlide2,0,0);
            drawTwoPlayerRight();
        glPopMatrix();    
        
        glPushMatrix();        
            glTranslatef(0,fSlide3,0);
            drawTwoPlayerBottom();
        glPopMatrix();
    }
    else if(iMenuNum==SELECT_SHIP)
    {
        glPushMatrix();
            glTranslatef(fSlide1,0,0);
            drawShip();
        glPopMatrix();
    
        glPushMatrix();    
            glTranslatef(fSlide2,0,0);
            drawPilot();
        glPopMatrix();    
        
        glPushMatrix();        
            glTranslatef(0,fSlide3,0);
            drawStartButton();
        glPopMatrix();
    }
    
    else if(iMenuNum==LOBBY_MENU)
    {
        glPushMatrix();
            glTranslatef(fSlide1,0,0);
            drawLobbyLeft();
        glPopMatrix();
    
        glPushMatrix();    
            glTranslatef(fSlide2,0,0);
            drawLobbyRight();
        glPopMatrix();    
        
        glPushMatrix();        
            glTranslatef(0,fSlide3,0);
            drawLobbyBottom();
        glPopMatrix();
    }
    else if(iMenuNum == GET_IP_MENU)
    {
        glPushMatrix();
            glTranslatef(fSlide1,0,0);
            drawMainLeft();
        glPopMatrix();
    
        glPushMatrix();    
            glTranslatef(fSlide2,0,0);
            drawMainRight();
        glPopMatrix();  
        
        glPushMatrix();    
            glTranslatef(0,fSlide3,0);
            drawMainBottom();
        glPopMatrix();  
        
        drawGetIP();
    }
    
    drawMouse();
}


bool Menu::update(void)
{
    TMouse mouse;
    mouse.x = (float)mouse_x/19 - 21,
    mouse.y = (float)(600-mouse_y)/19 - 16;
    mouse.b = mouse_b;
    //mx=4;
    //my=0;
    
    if(wait>0)
        wait--;
    
    updateDemoShip();
    
    bool ret=false;
    for(int n=0 ; n<iNumButtons ; n++)
    {
        ret=button[n].checkColWithPoint(makeVector2(mx,my,true));
        if(ret==true)   //collision
        {
            button[n].setMouseOver(true);
            if(mouse_b & 1 && wait==0)
            {
                if(strcmp(button[n].retCaption(),"Prev")==0)
                {
                    if(iDemoShipNum>0)
                        iDemoShipNum--;
                    setDemoShip(iDemoShipNum);
                } 
                else if(strcmp(button[n].retCaption(),"Next")==0)
                {
                    if(iDemoShipNum<shipDefs->retNumDefs()-1)
                        iDemoShipNum++;
                    setDemoShip(iDemoShipNum);
                } 
                else if(strcmp(button[n].retCaption(),"ShipContinue")==0)
                {
                    endMenu();
                    
                    if(iGameType == ONE_PLAYER)
                        iNextMenuNum = ONE_PLAYER_MENU;
                    else if(iGameType == TWO_PLAYER)
                        iNextMenuNum = TWO_PLAYER_MENU;
                    else if(iGameType == INTERNET_HOST)
                        iNextMenuNum = LOBBY_MENU;
                    else if(iGameType == INTERNET_JOIN)
                        iNextMenuNum = LOBBY_MENU;
                }
                else if(strcmp(button[n].retCaption(),"1PContinue")==0)
                {
                    endMenu();
                    
                    iNextMenuNum = /*MAIN_MENU*/START_GAME;
                }
                else if(strcmp(button[n].retCaption(),"1PShip")==0) //1st player set ship
                {   
                    iWhichPlayer=0;
                    iNextMenuNum = SELECT_SHIP;
                    endMenu();
                }
                else if(strcmp(button[n].retCaption(),"2PShip")==0) //2nd player set ship
                {
                    iWhichPlayer=1;
                    iNextMenuNum = SELECT_SHIP;
                    endMenu();
                }
                else if(strcmp(button[n].retCaption(),"IPContinue")==0)
                {
                    endMenu();
                    iNextMenuNum = SELECT_SHIP;
                }
            
            if(iNextMenuNum==MAIN_MENU)
            {
                if(strcmp(button[n].retCaption(),"Start1")==0) //1 player game
                {
                    endMenu();
                    iWhichPlayer=0;
                    iNextMenuNum = SELECT_SHIP;
                    iGameType=ONE_PLAYER;
                    
                }
                else if(strcmp(button[n].retCaption(),"Start2")==0) //2 player game
                {
                    endMenu();
                    iNextMenuNum = TWO_PLAYER_MENU;
                    iGameType=TWO_PLAYER;
                }
                else if(strcmp(button[n].retCaption(),"Start3")==0) //host internet game
                {
                    endMenu();
                    iNextMenuNum = SELECT_SHIP;
                    iGameType=INTERNET_HOST;
                }
                else if(strcmp(button[n].retCaption(),"Start4")==0) //join internet game
                {
                    //endMenu();
                    iNextMenuNum = GET_IP_MENU;
                    iGameType=INTERNET_JOIN;
                }
                else if(strcmp(button[n].retCaption(),"Exit")==0)
                {
                    endMenu();
                    bQuitGame=true;
                }
            }
                wait=10;
            }
        }
        else
            button[n].setMouseOver(false);
            

    if(bDone==true)
        return true;

    }
    return false;
}

void Menu::endMenu(void)
{
    bOpening=true;
        
    fSlideVel=0;
    bQuitGame=false;
}

void Menu::drawMainLeft(void)
{
    //mainLeft.drawPict(makeVector2(-11.05,0,true));

}

void Menu::drawMainRight(void)
{
    //mainRight.drawPict(makeVector2(11,0,true));

}

void Menu::drawMainBottom(void)
{
    //glColor3f(0,.5,1);
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_COLOR, GL_ONE_MINUS_SRC_COLOR);
        mainBottom.drawPict(makeVector2(0,8.2,true));
    glDisable(GL_BLEND);
   
    button[0].draw();
    button[1].draw();
    button[2].draw();
    button[3].draw();
    button[4].draw();
    button[5].draw();
    
    if(iNextMenuNum==GET_IP_MENU)
        drawGetIP();
}

void Menu::drawOnePlayerLeft(void)
{
    glEnable(GL_BLEND);
        glBlendFunc(GL_SRC_COLOR, GL_ONE);
        //onePlayerLeft.drawPict(makeVector2(-11,0,true));
    glDisable(GL_BLEND);    
}

void Menu::drawOnePlayerRight(void)
{
    glEnable(GL_BLEND);
        glBlendFunc(GL_SRC_COLOR, GL_ONE);
        //onePlayerRight.drawPict(makeVector2(10,0,true));
    glDisable(GL_BLEND);
}

void Menu::drawOnePlayerBottom(void)
{
    glEnable(GL_BLEND);
        glBlendFunc(GL_SRC_COLOR, GL_ONE);
        //onePlayerBottom.drawPict(makeVector2(-1,-13,true));
    glDisable(GL_BLEND);
    
    button[0].draw();
}



void Menu::drawTwoPlayerLeft(void)
{
    glEnable(GL_BLEND);
        glBlendFunc(GL_SRC_COLOR, GL_ONE);
        //onePlayerLeft.drawPict(makeVector2(-11,0,true));
    glDisable(GL_BLEND); 
    
   button[1].draw();
   button[2].draw();   
}

void Menu::drawTwoPlayerRight(void)
{
    glEnable(GL_BLEND);
        glBlendFunc(GL_SRC_COLOR, GL_ONE);
        //onePlayerRight.drawPict(makeVector2(10,0,true));
    glDisable(GL_BLEND);
}

void Menu::drawTwoPlayerBottom(void)
{
    glEnable(GL_BLEND);
        glBlendFunc(GL_SRC_COLOR, GL_ONE);
        //onePlayerBottom.drawPict(makeVector2(-1,-13,true));
    glDisable(GL_BLEND);
    
    button[0].draw();
}



void Menu::drawLobbyLeft(void)
{
    glEnable(GL_BLEND);
        glBlendFunc(GL_SRC_COLOR, GL_ONE);
        //lobbyLeft.drawPict(makeVector2(-11,0,true));
    glDisable(GL_BLEND); 
    
    writeText(-19,14,0,makecol(0,100,200),allFonts[0],"Waiting for players to join and game to start");
}

void Menu::drawLobbyRight(void)
{
    glEnable(GL_BLEND);
        glBlendFunc(GL_SRC_COLOR, GL_ONE);
        //lobbyRight.drawPict(makeVector2(10,0,true));
    glDisable(GL_BLEND);
}

void Menu::drawLobbyBottom(void)
{
    glEnable(GL_BLEND);
        glBlendFunc(GL_SRC_COLOR, GL_ONE);
        //lobbyBottom.drawPict(makeVector2(-1,-13,true));
    glDisable(GL_BLEND);
    
    button[0].draw();
}

void Menu::drawGetIP(void)
{
    glBlendFunc(GL_SRC_COLOR, GL_ONE);
    ipMenu.drawPict(makeVector2(0,3,true));
    
    writeText(-6,5,0,makecol(0,0,0),allFonts[1],sAddress);
    doText(sAddress);
    
    button[6].draw();
}
