/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/
#ifndef ms3d_def
#define ms3d_def

#ifndef byte
typedef unsigned char byte;
#endif // byte

#ifndef word
typedef unsigned short word;
#endif // word



//
// First comes the header.
//
typedef struct  //size = 14
{
    byte    id[10];                                     // always "MS3D000000"
    int     version;                                    // 4
} ms3d_header_t;

//
// Then comes the number of vertices
//
    //word nNumVertices;

//
// Then comes nNumVertices * sizeof (ms3d_vertex_t)
//
typedef struct      //size of structure = 15
{
    byte    flags;                                      // SELECTED | SELECTED2 | HIDDEN
    float   vertex[3];                                  //
    char    boneId;                                     // -1 = no bone
    byte    referenceCount;
} ms3d_vertex_t;

//
// number of triangles
//
//word nNumTriangles;

//
// nNumTriangles * sizeof (ms3d_triangle_t)
//
typedef struct  //size = 70
{
    word    flags;                                      // SELECTED | SELECTED2 | HIDDEN    2
    word    vertexIndices[3];                           //                                  6
    float   vertexNormals[3][3];                        //                                  36
    float   s[3];                                       //                                  12
    float   t[3];                                       //                                  12
    byte    smoothingGroup;                             // 1 - 32                           1
    byte    groupIndex;                                 //                                  1
} ms3d_triangle_t;

//
// number of groups
//
//word nNumGroups;

//
// nNumGroups * sizeof (ms3d_group_t)
//
typedef struct
{
    byte            flags;                              // SELECTED | HIDDEN
    char            name[32];                           //
    word            numtriangles;                       //
    word            *triangleIndices;                   // the groups group the triangles
    char            materialIndex;                      // -1 = no material
} ms3d_group_t;

//
// number of materials
//
//word nNumMaterials;

//
// nNumMaterials * sizeof (ms3d_material_t)
//
typedef struct  //size = 361
{
    char            name[32];                           //                       32
    float           ambient[4];                         //                       16
    float           diffuse[4];                         //                       16
    float           specular[4];                        //                       16
    float           emissive[4];                        //                       16
    float           shininess;                          // 0.0f - 128.0f         4
    float           transparency;                       // 0.0f - 1.0f           4
    char            mode;                               // 0, 1, 2 is unused now 1
    char            texture[128];                        // texture.bmp          128
    char            alphamap[128];                       // alpha.bmp            128
} ms3d_material_t;

//
// save some keyframer data
//
//float fAnimationFPS;
//float fCurrentTime;
//int iTotalFrames;

//
// number of joints
//
//word nNumJoints;

//
// nNumJoints * sizeof (ms3d_joint_t)
//
//
typedef struct
{
    float           time;                               // time in seconds
    float           rotation[3];                        // x, y, z angles
} ms3d_keyframe_rot_t;

typedef struct
{
    float           time;                               // time in seconds
    float           position[3];                        // local position
} ms3d_keyframe_pos_t;

typedef struct
{
    byte            flags;                              // SELECTED | DIRTY
    char            name[32];                           //
    char            parentName[32];                     //
    float           rotation[3];                        // local reference matrix
    float           position[3];

    word            numKeyFramesRot;                    //
    word            numKeyFramesTrans;                  //

    ms3d_keyframe_rot_t *keyFramesRot;      // local animation matrices
    ms3d_keyframe_pos_t *keyFramesTrans;  // local animation matrices
} ms3d_joint_t;

#endif
