/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/

#ifndef GAMEMODE_H
#define GAMEMODE_H

#include "CVector2.h"
#include "Arena.h"
#include "Game.h"
#include "ScoreKeeper.h"
#include "GameSettingsSingleton.h"
#include "NewMenu.h"
#include "Button.h"
#include "CheckBox.h"
#include "ShipSelector.h"
#include "Player.h"
#include "Powerup.h"

#define ONE_PLAYER_GAME  1
#define TWO_PLAYER_GAME  2

#define GM_NA   -1
#define GM_DUEL 0
#define GM_ASTEROIDS    1
#define GM_MISSILE_AVOID    2
#define GM_MISSILE_AVOID2   3
#define GM_ASTEROIDS2   4

#include <vector>
using namespace std;

class Game;


class GameMode
{
protected:
    int nPlayers;  
    NewMenu *menu;  
    
    TPowerupInfoArray pia;
    char gameModeName[30];
    
    
public:
    GameMode(NewMenu *m);
    ~GameMode();
    
    virtual void setUpGame(Game *game);
    virtual CVector2 getPlayerStartPos(int n);    //returns the start position for player's ship
    virtual int getPlayerShipNum(int n);
    
    virtual int getWeaponsSet(int n);
    
    virtual TMenuPage createMenuPage(FONT **allFonts,TButtonAtts bAtts, int prevPage,Model *allModels, ShipArray *sa, Game *game); //creates a menu page to set up this game mode

    virtual void runInGame(Game *g);
    virtual void nextLevel(Game *g);

    virtual void writeStats(Game *g);
};

#endif // GAMEMODE_H

