/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/

#include "GameMode.h" // class's header file

extern FONT* allFonts[20];

void GameMode::setUpGame(Game *game)
{
    CVector2
        pos(0,0,true),
        vel(0,0,false);
        
    CVector2 arena_top(-47,-27), arena_bot(47,34),
             p1(-46,-26) , p2(-45,35) , p3(46,34) , p4(44,-26),
            
            p5(0,0) , p6(10,10);
    
    Arena arena;
    arena.setBRect(arena_top,arena_bot,pos,vel);
    
    /*if(   (*(menu->getResults()))[5].value==CB_SELECTED   )
    {
    } */   
    
    if((*(menu->getResults()))[5].value==CB_SELECTED)  //check to see if walls are on
    {
        arena.addWall(p1,p2);
        arena.addWall(p2,p3);
        arena.addWall(p3,p4);
        arena.addWall(p4,p1);   
    }     
    
    game->setArena(arena);
    
    if((*(menu->getResults()))[4].value==CB_SELECTED)  //check enable asteroids checkbox
        game->startAsteroidsGame();
        
    (GameSettingsSingleton::instance())->setProjWrap(false);    
            /*char sName[30];
    unsigned char iColour;
    unsigned char iShipNum;
    unsigned int starting_lives;*/
    
    strcpy(gameModeName,"Duel");
    (ScoreKeeper::instance())->reset(INCREASING_TIME);    
    (ScoreKeeper::instance())->setTimeLeft(0);
    
    TPlayerAtts p1a,p2a;
    
    strcpy(p1a.sName,"Player1");
    p1a.iColour=0;
    p1a.starting_lives=6;
    p1a.startX=getPlayerStartPos(0).retX();
    p1a.startY=getPlayerStartPos(0).retY();
    
    strcpy(p2a.sName,"Player2");
    p2a.iColour=0;
    p2a.starting_lives=6;
    p2a.startX=getPlayerStartPos(1).retX();
    p2a.startY=getPlayerStartPos(1).retY();
    
    
    //give them differnet id's so they can hurt each other
    game->setPlayerAtts(0,p1a,0);   
    game->setPlayerAtts(1,p2a,1);
    
    pia.infoArray = game->powerupTypes;
    pia.size = game->nPowerupTypes;
}    

CVector2 GameMode::getPlayerStartPos(int n)
{
    CVector2 pos(0,0,true);
    if(n==0)
        pos.setVector(25,0,true);
    else if(n==1)
        pos.setVector(-25,0,true);
    
    return pos;
           
}    

int GameMode::getPlayerShipNum(int n)
{
    //return DONT_CARE;
    if(n==0)    //for player 1
    {
        return (*(menu->getResults()))[2].value;
    }    
    else if(n==1)   //for player 2
    {
        return (*(menu->getResults()))[3].value;    
    }    
}    

int GameMode::getWeaponsSet(int n)
{
    return DONT_CARE;  
}    

TMenuPage GameMode::createMenuPage(FONT **allFonts,TButtonAtts bAtts, int prevPage, Model *allModels, ShipArray *sa, Game *game)
{
    TMenuPage page;
    
    page.nWidgets=6;
    page.widgets = new Widget* [6];
    page.widgetTransitions = new int[6];
    
    page.widgets[0] = new Button(0,makeVector2(0,-3,true),4.5,2.45,allFonts[2],"Play",bAtts);
    page.widgetTransitions[0] = QUIT_MENU;

    page.widgets[1] = new Button(1,makeVector2(0,-6,true),5,2.45,allFonts[2],"Back",bAtts);
    page.widgetTransitions[1] = prevPage;
    
    page.widgets[2] = new ShipSelector(2,makeVector2(10,12,true),allModels,sa,game,allFonts[1],bAtts);
    page.widgetTransitions[2] = NO_TRANSITION;
    
    page.widgets[3] = new ShipSelector(3,makeVector2(-10,12,true),allModels,sa,game,allFonts[1],bAtts);
    page.widgetTransitions[3] = NO_TRANSITION;    
    
    page.widgets[4] = new CheckBox(4,makeVector2(-15,-13,true),1,1,allFonts[4],"Enable Asteroids",bAtts);
    page.widgetTransitions[4] = NO_TRANSITION;
    
    page.widgets[5] = new CheckBox(5,makeVector2(0,-13,true),1,1,allFonts[4],"Walls On",bAtts,true);
    page.widgetTransitions[5] = NO_TRANSITION;        
    
    page.gameModeResult=GM_DUEL;
    
    
    
    return page;     
} 

void GameMode::runInGame(Game *g)
{
    if(g->retPlayer(0)->retLives()==0){
        g->endGame("Player 2 Wins");
    }    
    else if(g->retPlayer(1)->retLives()==0){
        g->endGame("Player 1 Wins");
    }    
    
//    g->retPowerupArray()->placePowerup(g->retArena(), &pia);
}    

void GameMode::nextLevel(Game *g)
{
}   

void GameMode::writeStats(Game *g)
{

    char buf[100];
    
    for(int n=0 ; n<g->retNumPlayers() ; n++)
    {
        int xx;
        if(n==0){
            xx=500;
            writeText_2D(xx,130,0,makecol(200,250,200),allFonts[4],"Player1");
        }    
        else{
            xx=70;
            writeText_2D(xx,130,0,makecol(200,250,200),allFonts[4],"Player2");
        }
            
        sprintf(buf,"Projectiles Fired: %d",g->retPlayer(n)->retShip()->stats.shotsFired);
        writeText_2D(xx,160,0,makecol(200,200,200),allFonts[4],buf);
        sprintf(buf,"Projectiles Hit: %d",g->retPlayer(n)->retShip()->stats.shotsHit);
        writeText_2D(xx,180,0,makecol(200,200,200),allFonts[4],buf);
        
        if(g->retPlayer(n)->retShip()->stats.shotsFired==0)
            sprintf(buf,"Accuracy: 100 percent");
        else
            sprintf(buf,"Accuracy: %d percent",(int)(((float)g->retPlayer(n)->retShip()->stats.shotsHit/(float)g->retPlayer(n)->retShip()->stats.shotsFired)*100));
        writeText_2D(xx,200,0,makecol(200,200,200),allFonts[4],buf);
        
        sprintf(buf,"Kills: %d",g->retPlayer(n)->retShip()->stats.kills);
        writeText_2D(xx,230,0,makecol(200,200,200),allFonts[4],buf);

        sprintf(buf,"Longest No-Hit Streak: %d seconds",(int)((float)g->retPlayer(n)->retShip()->stats.longestStreak/32));
        writeText_2D(xx,250,0,makecol(200,200,200),allFonts[4],buf);        

        if((*(menu->getResults()))[5].value==CB_SELECTED)   //check to see if the walls are on
        {
            sprintf(buf,"Shield Lost To Walls: %d",g->retPlayer(n)->retShip()->stats.shieldLostToWalls);
            writeText_2D(xx,290,0,makecol(200,200,200),allFonts[4],buf);
        }    
        
        if((*(menu->getResults()))[4].value==CB_SELECTED)  //check to see if asteroids are on
        {
            sprintf(buf,"Asteroids Killed: %d",g->retPlayer(n)->retShip()->stats.asteroidsKilled);
            writeText_2D(xx,320,0,makecol(200,200,200),allFonts[4],buf);      
            sprintf(buf,"Hit By Asteroids: %d",g->retPlayer(n)->retShip()->stats.hitByAsteroid);
            writeText_2D(xx,340,0,makecol(200,200,200),allFonts[4],buf);     
            sprintf(buf,"Killed By Asteroids: %d",g->retPlayer(n)->retShip()->stats.killedByAsteroid);
            writeText_2D(xx,360,0,makecol(200,200,200),allFonts[4],buf); 
        }    
    }        
    //writeText_3D(10,16,40,makecol(255,255,255),allFonts[1],"hello");  

}     

GameMode::GameMode(NewMenu *m)
{
    menu = m;
}

GameMode::~GameMode()
{
}


   

