#ifndef game_def
#define game_def

#include <cstdlib>
#include <cstdio>
#include <cmath>
#include <cstring>
#include <allegro.h>
#include <alleggl.h>
#include "Standards.h"
#include "ParticleGenerator.h"
#include "ScoreKeeper.h"

#include "SObject.h"
#include "Arena.h"
#include "PObject.h"
#include "Asteroid.h"
#include "Proj.h"
#include "Powerup.h"
#include "Player.h"
#include "AIPlayer.h"
#include "Turret.h"
#include "GameMode.h"

#define MAX_OBJECTS 2000
#define MAX_PLAYERS 10
#define MAX_POWERUP_TYPES 20

/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/

#define GAME_DUEL           1
#define GAME_ASTEROIDS      2

class GameMode;

class Game
{
private:
    Player *players[MAX_PLAYERS];

    BRect *allObjects[MAX_OBJECTS]; //an array of pointers to all of the interactable objects
    Weapon weapons[MAX_WEAPONS];
    Model *allModels;
    Arena arena;
    ProjArray projs;
    
    AsteroidArray asteroids;
    int iNumPlayers;
    int iNumObjects;

    int iNumWeapons;
    
    int currentGameMode;
    int level;
    int nextLevelCounter;
    
    GameMode *gm;
    
    char endGameMessage[255];
    bool gameEnded;
    
    PowerupArray powerups;
    
public:
    TPowerupInfo powerupTypes[MAX_POWERUP_TYPES];
    int nPowerupTypes;
    
    bool bHotSeat;
    

    void init(void);
    void constructObjectList(void);
    void clearObjectList(void);
    
    void setArena(Arena _arena) { arena=_arena; }
    int addPlayer(Player *p);    //returns the number of the player added, or -1 on failure
    void createPlayer(int n);
    void setPlayerAtts(int n, TPlayerAtts atts, int new_id=-1); //-1 for id means dont's override it
    
    void setupWeapons(char* sWeapons, ParticleGenerator **partGen);
    void setPlayerWeapons(int iPlayer);
    void setModels(Model *_allModels);
    void setAsteroidsParts(ParticleGenerator *pg) {asteroids.setPartGen(pg); }
    
    void startAsteroidsGame(void);
    void startAsteroids(int nAsteroids);
    void nextLevel(void);
    
    void setupPowerupTypes(ParticleGenerator **partGen);
    
    void setGameMode(GameMode *_gm) {gm = _gm;}
    Player* retPlayer(int n);
    Ship* retShip(int n);
    int retNumPlayers(void) {return iNumPlayers;}
    Proj* retNextProj(void);
    ProjArray* retProjArray(void) {return &projs;}
    PowerupArray* retPowerupArray(void) {return &powerups;}
    Arena* retArena(void) {return &arena;}
    void resetProjs(void);

    void endGame(char *message);

    void reset(void);
    
    void draw(void);
    void update(void);
    
    void runGM(void);   //runs game mode specific code;
    
    bool retGameEnded(void) {return gameEnded;}
    
    char* getWeaponName(int wepNum);
    int getNumWeapons();
    
    Game(void);
    ~Game(void);
};


#endif
