/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/

#include "Game.h"

extern FONT* allFonts[20];
extern FONT* agl_font;

void Game::init(void)
{
    for(int n=0 ; n<MAX_PLAYERS ; n++)
    {
        players[n]->init();
    }    
    arena.init();   
    //for(int n=0 ; n<MAX_PROJS ; n++)
    //    projs[n].init();
    projs.init();
    for(int n=0 ; n<MAX_WEAPONS ; n++)
        weapons[n].init();
        
    asteroids.init();
    
    powerups.init();
    
    iNumWeapons=0;
    iNumObjects=0;
    iNumPlayers=0;
    nPowerupTypes=0;
    bHotSeat=false;
    
    currentGameMode = -1;
    level=1;
    nextLevelCounter=0;
    gameEnded=false;

}

void Game::reset(void)
{
    for(int n=0 ; n<MAX_PLAYERS ; n++)
        players[n]->init();
    resetProjs();
    asteroids.init();  
    powerups.init();
    
    iNumObjects=0;
    iNumPlayers=0;
    bHotSeat=false;
    
    currentGameMode = -1;
    level=1;
    nextLevelCounter=0;
    gameEnded=false;
}    

void Game::setupPowerupTypes(ParticleGenerator **partGen){
    nPowerupTypes=0;
    TPowerupInfo pinfo;
    

    pinfo.fMass=.1;
    pinfo.fDampening=.98;
    pinfo.startingLifetime =400;
    pinfo.lifeRandomness = .2; //20% randonmess
    pinfo.createSound = -1;
    pinfo.deathSound = -1;
    pinfo.iType = POWERUP_TYPE_INVINCIBILITY;
    pinfo.partGen=((*partGen)+17);
    pinfo.explosionGen=((*partGen)+8);
    pinfo.model = &allModels[8];
    pinfo.fRadius = .65;
    pinfo.spawnChance = 100;
    powerupTypes[nPowerupTypes] = pinfo;
    nPowerupTypes++;
}

void Game::setupWeapons(char* sWeapons, ParticleGenerator **partGen)
{
    //will load in the weapons from a text file eventually
    
    TProjInfo pinfo;
    iNumWeapons=0;
    
    pinfo.fAccel=.014;
    pinfo.fMaxVel=2;
    pinfo.fAngAccel=.015;
    pinfo.fMaxAngVel=.17;
    pinfo.fMusselVel=pinfo.fMaxVel;
    pinfo.fDampening=.97;
    pinfo.fAngDampening=.92;
    pinfo.fMass=.01;
    pinfo.iType=ENERGY;
    pinfo.iDamageClass=ENERGY;
    pinfo.startingLifetime=40;
    pinfo.lifeRandomness=0;
    pinfo.fireSound=9;
    pinfo.deathSound=-1;
    pinfo.iDamage=6;
    pinfo.dieOnImpact=true;
    pinfo.partGen=0;
    pinfo.explosionGen=((*partGen)+3);
    pinfo.iDamageClass=ENERGY;
    pinfo.bHoming=false;
    pinfo.nProjectiles=1;
    pinfo.spread=0;
    pinfo.armor=1000;
    
    pinfo.model = &allModels[8];
    pinfo.fRadius = .5;
    weapons[iNumWeapons].createWeapon("Lightning Ball",6,pinfo,"w_hud/single_shot.bmp");
    iNumWeapons++;
    
    pinfo.fAccel=.03;
    pinfo.fMaxVel=.9;
    pinfo.fAngAccel=.015;
    pinfo.fMaxAngVel=.23;
    pinfo.fMusselVel=.9;
    pinfo.fDampening=.97;
    pinfo.fAngDampening=.92;
    pinfo.fMass=.1;
    pinfo.iType=MISSILE;
    pinfo.iDamageClass=EXPLOSIVE;
    pinfo.startingLifetime=300;
    pinfo.lifeRandomness=.2;    //20% randomness (ie lifetime will between 240 and 360)
    pinfo.fireSound=10;
    pinfo.deathSound=5;
    pinfo.iDamage=10;
    pinfo.dieOnImpact=true;
    pinfo.partGen=((*partGen)+4);
    pinfo.explosionGen=((*partGen)+5);
    pinfo.bHoming=true;
    pinfo.nProjectiles=6;
    pinfo.spread=M_PI/3;
    pinfo.armor=7;
    
    pinfo.model = &allModels[14];
    pinfo.fRadius = .5;
    weapons[iNumWeapons].createWeapon("Hellstrike",14,pinfo,"w_hud/hellstrike.bmp");
    iNumWeapons++;


    //this is just commented out temperoraly
    pinfo.fAccel=.05;
    pinfo.fMaxVel=3;
    pinfo.fAngAccel=.015;
    pinfo.fMaxAngVel=.17;
    pinfo.fMusselVel=1;
    pinfo.fDampening=.97;
    pinfo.fAngDampening=.92;
    pinfo.fMass=.1;
    pinfo.iType=MISSILE;
    pinfo.iDamageClass=EXPLOSIVE;
    pinfo.startingLifetime=INFINITE_LIFE;
    pinfo.lifeRandomness=0;
    pinfo.fireSound=7;
    pinfo.deathSound=5;
    pinfo.iDamage=20;
    pinfo.dieOnImpact=true;
    pinfo.partGen=((*partGen)+4);
    pinfo.explosionGen=((*partGen)+5);
    pinfo.bHoming=false;
    pinfo.nProjectiles=1;
    pinfo.spread=0;
    pinfo.armor=30;
    
    pinfo.model = &allModels[14];
    pinfo.fRadius = .5;
    weapons[iNumWeapons].createWeapon("Wrath Missile",14,pinfo,"w_hud/missile.bmp");
    iNumWeapons++;
    
    
    pinfo.fAccel=.014;
    pinfo.fMaxVel=5;
    pinfo.fAngAccel=.015;
    pinfo.fMaxAngVel=.17;
    pinfo.fMusselVel=pinfo.fMaxVel;
    pinfo.fDampening=.97;
    pinfo.fAngDampening=.92;
    pinfo.fMass=.01;
    pinfo.iType=INST;
    pinfo.iDamageClass=ENERGY;
    pinfo.startingLifetime=3;
    pinfo.lifeRandomness=0;
    pinfo.fireSound=0;
    pinfo.deathSound=-1;
    pinfo.iDamage=10;
    pinfo.dieOnImpact=false;
    pinfo.partGen=0;/*partGen)+10)*/
    pinfo.explosionGen=0;
    pinfo.bHoming=false;
    pinfo.nProjectiles=1;
    pinfo.spread=0;
    pinfo.armor=0;
    
    pinfo.model = 0;
    pinfo.fRadius = .05;
    weapons[iNumWeapons].createWeapon("Lightning",2,pinfo,"w_hud/lightning.bmp");
    iNumWeapons++;
    
    pinfo.fAccel=.014;
    pinfo.fMaxVel=2.2;
    pinfo.fAngAccel=.015;
    pinfo.fMaxAngVel=.17;
    pinfo.fMusselVel=pinfo.fMaxVel;
    pinfo.fDampening=.97;
    pinfo.fAngDampening=.92;
    pinfo.fMass=.01;
    pinfo.iType=ENERGY;
    pinfo.iDamageClass=EXPLOSIVE;
    pinfo.startingLifetime=3;
    pinfo.lifeRandomness=.9;
    pinfo.fireSound=-1;
    pinfo.deathSound=-1;
    pinfo.iDamage=6;
    pinfo.dieOnImpact=true;
    pinfo.partGen=((*partGen)+5);
    pinfo.explosionGen=((*partGen)+13);
    pinfo.bHoming=false;
    pinfo.nProjectiles=10;
    pinfo.spread=M_PI/5;
    pinfo.armor=0;
    
    pinfo.model = 0;
    pinfo.fRadius = .05;
    weapons[iNumWeapons].createWeapon("Shot Gun",14,pinfo,"w_hud/shotgun.bmp");
    iNumWeapons++;
    
    
    pinfo.fAccel=.000/*.005*/;
    pinfo.fMaxVel=.1;
    pinfo.fAngAccel=.015;
    pinfo.fMaxAngVel=0.15;
    pinfo.fMusselVel=0;
    pinfo.fDampening=.94;
    pinfo.fAngDampening=0;
    pinfo.fMass=4;
    pinfo.iType=MINE;
    pinfo.iDamageClass=EXPLOSIVE;
    pinfo.startingLifetime=1000;
    pinfo.lifeRandomness=0;
    pinfo.fireSound=-1;
    pinfo.deathSound=-1;
    pinfo.iDamage=30;
    pinfo.dieOnImpact=true;
    pinfo.partGen=((*partGen)+10);
    pinfo.explosionGen=((*partGen)+11);
    pinfo.bHoming=false;
    pinfo.nProjectiles=1;
    pinfo.spread=0;
    pinfo.armor=50;
    
    pinfo.model = /*&allModels[10]*/0;
    pinfo.fRadius = .65;
    weapons[iNumWeapons].createWeapon("Plasma Mine",25,pinfo,"w_hud/one_mine.bmp");
    iNumWeapons++;
    
    
    pinfo.fAccel=.014;
    pinfo.fMaxVel=2;
    pinfo.fAngAccel=.015;
    pinfo.fMaxAngVel=.17;
    pinfo.fMusselVel=pinfo.fMaxVel;
    pinfo.fDampening=.97;
    pinfo.fAngDampening=.92;
    pinfo.fMass=.01;
    pinfo.iType=ENERGY;
    pinfo.iDamageClass=ENERGY;
    pinfo.startingLifetime=INFINITE_LIFE;
    pinfo.lifeRandomness=0;
    pinfo.fireSound=9;
    pinfo.deathSound=-1;
    pinfo.iDamage=4;
    pinfo.dieOnImpact=true;
    pinfo.partGen=0;
    pinfo.explosionGen=((*partGen)+3);
    pinfo.iDamageClass=ENERGY;
    pinfo.bHoming=false;
    pinfo.nProjectiles=3;
    pinfo.spread=M_PI/10;
    pinfo.armor=1000;
    
    pinfo.model = &allModels[8];
    pinfo.fRadius = .5;
    weapons[iNumWeapons].createWeapon("Tri-Shot",7,pinfo,"w_hud/tri_shot.bmp");
    iNumWeapons++;


    pinfo.fAccel=.03;
    pinfo.fMaxVel=.9;
    pinfo.fAngAccel=.014;
    pinfo.fMaxAngVel=.23;
    pinfo.fMusselVel=.9;
    pinfo.fDampening=.97;
    pinfo.fAngDampening=.92;
    pinfo.fMass=.1;
    pinfo.iType=MISSILE;
    pinfo.iDamageClass=EXPLOSIVE;
    pinfo.startingLifetime=300;
    pinfo.lifeRandomness=.2;    //20% randomness (ie lifetime will between 240 and 360)
    pinfo.fireSound=10;
    pinfo.deathSound=5;
    pinfo.iDamage=10;
    pinfo.dieOnImpact=true;
    pinfo.partGen=((*partGen)+4);
    pinfo.explosionGen=((*partGen)+5);
    pinfo.bHoming=true;
    pinfo.nProjectiles=1;
    pinfo.spread=M_PI/3;
    pinfo.armor=7;
    
    pinfo.model = &allModels[14];
    pinfo.fRadius = .5;
    weapons[iNumWeapons].createWeapon("Homing Missiles",14,pinfo,"w_hud/homing_missile.bmp");
    iNumWeapons++;
    
    
    pinfo.fAccel=/*.005*/0;
    pinfo.fMaxVel=.7;
    pinfo.fAngAccel=.015;
    pinfo.fMaxAngVel=0.15;
    pinfo.fMusselVel=-.5;
    pinfo.fDampening=.94;
    pinfo.fAngDampening=0;
    pinfo.fMass=4;
    pinfo.iType=MINE;
    pinfo.iDamageClass=EXPLOSIVE;
    pinfo.startingLifetime=1000;
    pinfo.lifeRandomness=0;
    pinfo.fireSound=-1;
    pinfo.deathSound=-1;
    pinfo.iDamage=30;
    pinfo.dieOnImpact=true;
    pinfo.partGen=((*partGen)+10);
    pinfo.explosionGen=((*partGen)+11);
    pinfo.bHoming=false;
    pinfo.nProjectiles=4;
    pinfo.spread=M_PI/2;
    pinfo.armor=30;
    
    pinfo.model = /*&allModels[10]*/0;
    pinfo.fRadius = .65;
    weapons[iNumWeapons].createWeapon("Spider Mine",25,pinfo,"w_hud/four_mines.bmp");
    iNumWeapons++;
    
    
    pinfo.fAccel=.014;
    pinfo.fMaxVel=1.3;
    pinfo.fAngAccel=.015;
    pinfo.fMaxAngVel=.17;
    pinfo.fMusselVel=pinfo.fMaxVel;
    pinfo.fDampening=.97;
    pinfo.fAngDampening=.92;
    pinfo.fMass=6;
    pinfo.iType=ENERGY;
    pinfo.iDamageClass=ENERGY;
    pinfo.startingLifetime=INFINITE_LIFE;
    pinfo.lifeRandomness=0;
    pinfo.fireSound=-1;
    pinfo.deathSound=-1;
    pinfo.iDamage=30;
    pinfo.dieOnImpact=true;
    pinfo.partGen=((*partGen)+14);
    pinfo.explosionGen=((*partGen)+15);
    pinfo.bHoming=false;
    pinfo.nProjectiles=4;
    pinfo.spread=M_PI/10;
    pinfo.armor=1000;
    
    pinfo.model = /*&allModels[8]*/NULL;
    pinfo.fRadius = 1;
    weapons[iNumWeapons].createWeapon("Concussion",25,pinfo,"w_hud/concussion.bmp");
    iNumWeapons++;
    
    
    pinfo.fAccel=/*.005*/0;
    pinfo.fMaxVel=-.4;
    pinfo.fAngAccel=.015;
    pinfo.fMaxAngVel=0.15;
    pinfo.fMusselVel=-.4;
    pinfo.fDampening=.94;
    pinfo.fAngDampening=0;
    pinfo.fMass=.5;
    pinfo.iType=MINE;
    pinfo.iDamageClass=PROJ_KILLER;
    pinfo.startingLifetime=500;
    pinfo.lifeRandomness=0;
    pinfo.fireSound=-1;
    pinfo.deathSound=-1;
    pinfo.iDamage=6;
    pinfo.dieOnImpact=true;
    pinfo.partGen=((*partGen)+16);
    pinfo.explosionGen=((*partGen)+18);
    pinfo.bHoming=false;
    pinfo.nProjectiles=18;
    pinfo.spread=M_PI*1.5;
    pinfo.armor=20;
    
    pinfo.model = 0;
    pinfo.fRadius = .65;
    weapons[iNumWeapons].createWeapon("Defense Ring",50,pinfo,"w_hud/defense.bmp");
    iNumWeapons++;
        
        
        
    pinfo.fAccel=.05;
    pinfo.fMaxVel=3;
    pinfo.fAngAccel=.005;
    pinfo.fMaxAngVel=.12;
    pinfo.fMusselVel=1.3;
    pinfo.fDampening=.97;
    pinfo.fAngDampening=.92;
    pinfo.fMass=.2;
    pinfo.iType=MISSILE;
    pinfo.iDamageClass=EXPLOSIVE;
    pinfo.startingLifetime=INFINITE_LIFE;
    pinfo.lifeRandomness=0;
    pinfo.fireSound=7;
    pinfo.deathSound=5;
    pinfo.iDamage=150;
    pinfo.dieOnImpact=true;
    pinfo.partGen=((*partGen)+4);
    pinfo.explosionGen=((*partGen)+5);
    pinfo.bHoming=true;
    pinfo.nProjectiles=1;
    pinfo.spread=0;
    pinfo.armor=41;
    
    pinfo.model = &allModels[14];
    pinfo.fRadius = .7;
    weapons[iNumWeapons].createWeapon("Redeemer Missile",20,pinfo,"w_hud/redeemer.bmp");
    iNumWeapons++;
    
    
    pinfo.fAccel=.014;
    pinfo.fMaxVel=2.3;
    pinfo.fAngAccel=.015;
    pinfo.fMaxAngVel=.19;
    pinfo.fMusselVel=pinfo.fMaxVel;
    pinfo.fDampening=.97;
    pinfo.fAngDampening=.92;
    pinfo.fMass=.001;
    pinfo.iType=ENERGY;
    pinfo.iDamageClass=BALLISTIC;
    pinfo.startingLifetime=45;
    pinfo.lifeRandomness=.6;
    pinfo.fireSound=9;
    pinfo.deathSound=-1;
    pinfo.iDamage=1;
    pinfo.dieOnImpact=true;
    pinfo.partGen=0;
    pinfo.explosionGen=((*partGen)+3);
    pinfo.bHoming=false;
    pinfo.nProjectiles=2;
    pinfo.spread=M_PI/90;
    pinfo.armor=1000;
    
    pinfo.model = &allModels[8];
    pinfo.fRadius = .5;
    weapons[iNumWeapons].createWeapon("Gattling Gun",2,pinfo,"w_hud/gattling.bmp");
    iNumWeapons++;
    
    pinfo.fAccel=.014;
    pinfo.fMaxVel=1.3;
    pinfo.fAngAccel=.015;
    pinfo.fMaxAngVel=.15;
    pinfo.fMusselVel=pinfo.fMaxVel;
    pinfo.fDampening=.97;
    pinfo.fAngDampening=.92;
    pinfo.fMass=.001;
    pinfo.iType=ENERGY;
    pinfo.iDamageClass=PROJ_KILLER;
    pinfo.startingLifetime=1000;
    pinfo.lifeRandomness=.6;
    pinfo.fireSound=9;
    pinfo.deathSound=-1;
    pinfo.iDamage=2;
    pinfo.dieOnImpact=false;
    pinfo.partGen=0;
    pinfo.explosionGen=((*partGen)+3);
    pinfo.bHoming=false;
    pinfo.nProjectiles=24;
    pinfo.spread=M_PI*2;
    pinfo.armor=10;
    
    pinfo.model = &allModels[8];
    pinfo.fRadius = .5;
    weapons[iNumWeapons].createWeapon("Rebound Gun",40,pinfo,"w_hud/rebound.bmp");
    iNumWeapons++;
    
    pinfo.fAccel=.014;
    pinfo.fMaxVel=1.5;
    pinfo.fAngAccel=.015;
    pinfo.fMaxAngVel=.15;
    pinfo.fMusselVel=pinfo.fMaxVel;
    pinfo.fDampening=.97;
    pinfo.fAngDampening=.92;
    pinfo.fMass=.001;
    pinfo.iType=ENERGY;
    pinfo.iDamageClass=EMP;
    pinfo.startingLifetime=10;
    pinfo.lifeRandomness=0;
    pinfo.fireSound=-1;
    pinfo.deathSound=-1;
    pinfo.iDamage=100;
    pinfo.dieOnImpact=false;
    pinfo.partGen=((*partGen)+19);
    pinfo.explosionGen=((*partGen)+20);
    pinfo.bHoming=false;
    pinfo.nProjectiles=20;
    pinfo.spread=M_PI*2;
    pinfo.armor=10;
    
    pinfo.model = /*&allModels[8]*/0;
    pinfo.fRadius = 3;
    weapons[iNumWeapons].createWeapon("EMP Wave",30,pinfo,"w_hud/emp.bmp");
    iNumWeapons++;
    
    
    
    pinfo.fAccel=.5;
    pinfo.fMaxVel=.5;
    pinfo.fAngAccel=1;
    pinfo.fMaxAngVel=1;
    pinfo.fMusselVel=1;
    pinfo.fDampening=.94;
    pinfo.fAngDampening=0;
    pinfo.fMass=4;
    pinfo.iType=MINE;
    pinfo.iDamageClass=EXPLOSIVE;
    pinfo.startingLifetime=1000;
    pinfo.lifeRandomness=0;
    pinfo.fireSound=-1;
    pinfo.deathSound=-1;
    pinfo.iDamage=20;
    pinfo.dieOnImpact=true;
    pinfo.partGen=((*partGen)+21);
    pinfo.explosionGen=((*partGen)+22);
    pinfo.bHoming=true;
    pinfo.nProjectiles=2;
    pinfo.spread=M_PI*2;
    pinfo.armor=25;
    
    pinfo.model = /*&allModels[10]*/0;
    pinfo.fRadius = .65;
    weapons[iNumWeapons].createWeapon("Berserkers",25,pinfo,"w_hud/berserkers.bmp");
    iNumWeapons++;
    
    /*pinfo.fAccel=.014;
    pinfo.fMaxVel=2;
    pinfo.fAngAccel=.015;
    pinfo.fMaxAngVel=.17;
    pinfo.fMusselVel=.8;
    pinfo.fDampening=.97;
    pinfo.fAngDampening=.92;
    pinfo.fMass=.3;
    pinfo.iType=MISSILE;
    pinfo.iDamageClass=EXPLOSIVE;
    pinfo.iDamage=30;
    pinfo.dieOnImpact=true;
    pinfo.partGen=((*partGen)+4);
    pinfo.explosionGen=((*partGen)+7);
    pinfo.bHoming=false;
    
    pinfo.model = &allModels[8];
    pinfo.fRadius = .5;
    weapons[iNumWeapons].createWeapon("Missile2",20,pinfo);
    iNumWeapons++;    */
}

void Game::setPlayerWeapons(int iPlayer)
{
    players[iPlayer]->setWeapons(weapons,iNumWeapons);

}

void Game::constructObjectList(void)
{
    outtext(LOGFILE,"\nConstructing Object List\n");

    outtext(LOGFILE,"  adding players to object list\n");
    for(int n=0 ; n<MAX_PLAYERS ; n++)
    {
        if(players[n]->retExist()==true)
        {
            allObjects[iNumObjects] = players[n]->retShipForObjectList();
            if(allObjects[iNumObjects])     //if something was added
                iNumObjects++;
        }
    }
    
    outtext(LOGFILE,"  adding walls to object list\n");
    for(int n=0 ; n<arena.retNumWalls() ; n++)
    {
        if(arena.retWall(n)->retExist()==true)
        {
            allObjects[iNumObjects] = (BRect*)arena.retWall(n);
            iNumObjects++;
        }
    }
    
    outtext(LOGFILE,"  adding projectiles to object list\n");
    for(int n=0 ; n<MAX_PROJS ; n++)
    {
        allObjects[iNumObjects] = projs.retProj(n);
        iNumObjects++;
    }

    outtext(LOGFILE,"  adding asteroids to object list\n");
    for(int n=0 ; n<MAX_ASTEROIDS ; n++)
    {
        allObjects[iNumObjects] = asteroids.retAsteroid(n);
        iNumObjects++;
    }    
    
    outtext(LOGFILE,"  adding powerups to object list\n");
    for(int n=0 ; n<MAX_POWERUPS ; n++)
    {
        allObjects[iNumObjects] = powerups.retPowerup(n);
        iNumObjects++;
    }    
    
    char string[40];
    sprintf(string,"Number of objects added: %d\n\n",iNumObjects);
    outtext(LOGFILE,string);
}

void Game::clearObjectList(void)
{
    outtext(LOGFILE,"\nClearing Object List\n");
    for(int n=0 ; n<iNumObjects ; n++)
        allObjects[n]=0;
    iNumObjects=0;
}    

void Game::draw(void)
{
    arena.draw();


    for(int n=0 ; n<MAX_PROJS ; n++)
    {
        if(projs.retProj(n)!=0 && projs.retProj(n)->retExist()==true)
            projs.retProj(n)->draw();
    }
    
    asteroids.draw();
    powerups.draw();
    
    //draw the player's ships
    for(int n=0 ; n<MAX_PLAYERS ; n++)
    {
        if(players[n]->retExist()==true)  
        {
            players[n]->draw();

        }
    }
    
    //draw the huds
    for(int n=0 ; n<MAX_PLAYERS ; n++)
    {
        if(players[n]->retExist()==true)  
        {    
            if(bHotSeat==true && (n==0 || n==1))  //it is a hot seat game
            {
                players[n]->drawHotSeatHUD(n);
            }
            else if(n==0)   
                players[n]->drawHUD();
        }
    }
    
    if(gameEnded==true)
    {
        ortho_begin(SCREEN_W, SCREEN_H);
            writeText_2D(400-(strlen(endGameMessage)*15)/2,70,0,makecol(200,200,255),allFonts[3],endGameMessage);  
            writeText_2D(400-(strlen(endGameMessage)*15)/2,100,0,makecol(200,200,200),allFonts[4],"Hit Enter to Continue");
        
            gm->writeStats(this);
        ortho_end();  
    }    
}

void Game::update(void)
{
    CollisionInfo info1,info2;
    arena.update();
    runGM();
    
    
    /*if(key[KEY_T]){
        outtext(LOGFILE,"Making a test proj\n");
        Powerup* p = powerups.retNextPowerup();
        if(p)
            p->create(powerupTypes[0] , makeVector2(0,0,true));
    }*/
    
    if(gameEnded==false)
    {
    
    for(int n=0 ; n<MAX_PLAYERS ; n++)
    {
        if(players[n]->retExist()==true)
        {
            //(players[n].retShip()) -> update();
            players[n]->update(n,arena);
            if(players[n]->autoShoot())
                players[n]->retShip()->shoot(retProjArray());
            if(players[n]->isDead()==true)
                players[n]->startRespawnCounter();
            
            //    players[n].respawn(n);
        }
    }

    //players[0]->setTarget(players[1]->retShip());
    //players[1]->setTarget(players[0]->retShip());

    for(int n=0 ; n<iNumPlayers ; n++)
    {
        if(players[n]->retExist()==true)
            players[n]->findTarget(allObjects,iNumObjects);
    }
    
    for(int n=0 ; n<MAX_PROJS ; n++)
    {
        if(projs.retProj(n)!=0 && projs.retProj(n)->retExist()==true)
            projs.retProj(n)->update(arena);
    }
    
    powerups.update();
    asteroids.update();
    ScoreKeeper::instance()->update();  //update the score keeper
    
    for(int i=0 ; i<iNumObjects ; i++)
        allObjects[i]->clearPointOfCollision();

    /******************COLLISION DETECTION***************************/
    for(int i=0 ; i<iNumObjects ; i++)
    {

        for(int j=i+1 ; j<iNumObjects ; j++)
        {
            if(i!=j && allObjects[i]->retExist()==true && allObjects[j]->retExist()==true)
            {
                //TColInfo colInfo; 
                bool bCol=false;
                
                if(allObjects[i]->retProjType()==ENERGY && allObjects[j]->retProjType()==ENERGY)
                    continue;
                
                bCol = allObjects[i]->checkColWithBRect(allObjects[j]);
                
                if(bCol==true)
                {
                    info1=allObjects[i]->reactToCollision();                    
                    info2=allObjects[j]->reactToCollision();
                    
                    allObjects[i]->reactToCollisionInfo(info2);
                    allObjects[j]->reactToCollisionInfo(info1);
                    //allObjects[i]->reactToCollision(colInfo);
                    //allObjects[j]->reactToCollision(colInfo);
                    //                COLLISION
//                    ((PObject*)allObjects[i])->reactToCollision(colInfo);
//                    ((SObject*)allObjects[j])->reactToCollision(colInfo);
                    //allObjects[j]->reactToCollision(colInfo);
                }
            }
        }
    }

    for(int i=0 ; i<iNumObjects ; i++)
        for(int j=0 ; j<iNumObjects ; j++)
            if(i!=j && allObjects[i]->retExist()==true && allObjects[j]->retExist()==true)
                if(allObjects[i]->retType()==CIRC && allObjects[j]->retType()==LINE)
                    allObjects[i]->checkColWithBRect(allObjects[j]);
 
   
     /* 
    for(int i=0 ; i<iNumObjects ; i++)
    {
        for(int j=0 ; j<MAX_PROJS; j++)
        {
            if(projs[j].retExist()==true)
            {

                outtext(LOGFILE,string);
            
                if(((BRect)projs[j]).checkColWithBRect(allObjects[i])==true)
                    {}//projs[j].destroy();
                
                if(projs[j].checkColWithBRect((BRect*)&arena)==false)
                    projs[j].destroy();
            }
        }
    }
    */
    
    if(currentGameMode==GAME_ASTEROIDS)
    {
        if(asteroids.asteroidsAlive()==false && nextLevelCounter==0)    //increase leve
        {
            nextLevelCounter=40;
        }    
    }
    
    if(nextLevelCounter>0)
        nextLevelCounter--;
    if(nextLevelCounter==1)
        nextLevel();
        
    }    
}


void Game::startAsteroidsGame(void)
{
    currentGameMode=GAME_ASTEROIDS;
    level=1;
    startAsteroids(3);
    nextLevelCounter=0;
}

void Game::nextLevel(void)
{
    level++;
    if(currentGameMode==GAME_ASTEROIDS)
    {
        startAsteroids(level+2);
        for(int n=0 ; n<iNumPlayers ; n++)
        {
            retShip(n)->makeInvincible(90);  //make it invincible when the asteroids come back
        }    
    }
    
    //tell the game mode that another level is coming
    if(gm)
        gm->nextLevel(this);
}

void Game::runGM(void)
{
    if(gm)
        gm->runInGame(this);    
}    

Player* Game::retPlayer(int n)
{
    if(n>=0 && n<MAX_PLAYERS)
        return players[n];
    else
        return (Player*)NULL;
}

Ship* Game::retShip(int n)
{
    if(n>=0 && n<MAX_PLAYERS)
        return players[n]->retShip();
    else
        return (Ship*)NULL;
}

void Game::createPlayer(int n)
{
    if(n>=0 && n<MAX_PLAYERS)
    {
        if(players[n]->retExist()==false)
        {
            players[n]->create();
            
            iNumPlayers++;
        }
    }
}

int Game::addPlayer(Player *p)
{
    int ret=-1;
    /*if(iNumPlayers < MAX_PLAYERS)
    {
        ret=iNumPlayers;
        iNumPlayers++;
    }*/
    
    
    for(int n=0 ; n<MAX_PLAYERS ; n++)
    {
        if(players[n]->retExist()==false)
        {
            char buf[30];
            sprintf(buf,"  add player %d\n",n);
            outtext(LOGFILE,buf);
            delete players[n];          //delete the old player
            players[n] = p;             //and set the new one
            players[n]->create();
            setPlayerWeapons(n);
            iNumPlayers++;
            return n;
        }
    }
    
    return ret;
  /*  if(iNumPlayers < MAX_PLAYERS)
    {
        players[iNumPlayers] = player;
        iNumPlayers++;
    }*/
 //   constructObjectList();
}



void Game::setPlayerAtts(int n, TPlayerAtts atts, int new_team_id)
{
    if(n>=0 && n<MAX_PLAYERS && players[n] && players[n]->retExist()==true)
    {
        players[n]->setPlayer(atts);
        
        if(new_team_id==-1)  //means use the normal id
            players[n]->setid(n,n);
        else
            players[n]->setid(n,new_team_id);
    }
}

void Game::setModels(Model *_allModels) 
{ 
    allModels = _allModels;
    asteroids.setModels(&allModels[11],11,13);
}

void Game::startAsteroids(int nAsteroids)
{
    asteroids.startAsteroids(nAsteroids,(BRect*)&arena);
}

Proj* Game::retNextProj(void)
{
    /*iNumProjs++;
    if(iNumProjs>MAX_PROJS)
        iNumProjs=1;
        
    return &projs[iNumProjs-1];*/
    return projs.retNextProj();
}

void Game::resetProjs(void)
{
    projs.init();    
}    

void Game::endGame(char *message)
{
    if(gameEnded==false)    //only end the game if it is not already ended
    {
        strcpy(endGameMessage,message);
        gameEnded=true;
    }    
}    

char* Game::getWeaponName(int wepNum){
    if(wepNum>=0 && wepNum<iNumWeapons){
        return weapons[wepNum].retName();
    }
}

int Game::getNumWeapons(){
    return iNumWeapons;
}

Game::Game(void) 
{
    for(int n=0 ; n<MAX_PLAYERS ; n++)
    {
        players[n] = new Player();
    }    
    init();
}

Game::~Game(void) 
{
    for(int n=0 ; n<MAX_PLAYERS ; n++)
        delete players[n];    
}
