/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/

#ifndef CONTROLLER_H
#define CONTROLLER_H

#include "allegro.h"

#define UP      1
#define DOWN    2
#define LEFT    4
#define RIGHT   8
#define SHOOT   16
#define NEXT_WEAPON 32
#define COUNTERMEASURE  64

#define KEYBOARD    1
#define JOYSTICK    2

#define MAX_KEYS    256

class Controller
{
private:
    unsigned char keysPressed;
    unsigned char controllerType;
    
    unsigned int keyPrefs[MAX_KEYS];

public:
    void init(void);
    void initKeyPrefs(int player=0);

    bool retUp(void) { return keysPressed & UP; }
    bool retDown(void) { return keysPressed & DOWN; }
    bool retLeft(void) { return keysPressed & LEFT; }
    bool retRight(void) { return keysPressed & RIGHT; }
    bool retShoot(void) { return keysPressed & SHOOT; }
    bool retNextWeapon(void) { return keysPressed & NEXT_WEAPON; }
    bool retCountermeasure(void) { return keysPressed & COUNTERMEASURE; }

    void pollController(void);

    Controller();
    ~Controller();
};

#endif // CONTROLLER_H

