/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/

#include "controller.h" // class's header file

void Controller::pollController(void)
{
    keysPressed=0;
    
    if(controllerType==KEYBOARD)
    {
        if(keypressed()==TRUE)
        {
            keysPressed |= keyPrefs[(readkey() >> 8)];
        }
    }
}

void Controller::init(void)
{
    keysPressed=0;
    controllerType=KEYBOARD;
    
    for(int n=0 ; n<MAX_KEYS ; n++)
        keyPrefs[n]=0;
    
    initKeyPrefs(0);
}

void Controller::initKeyPrefs(int player)
{
    if(player==0)
    {
        keyPrefs[KEY_UP] = UP;
        keyPrefs[KEY_DOWN] = DOWN;
        keyPrefs[KEY_LEFT]= LEFT;
        keyPrefs[KEY_RIGHT]= RIGHT;
        keyPrefs[KEY_RCONTROL]= SHOOT;
        keyPrefs[KEY_RSHIFT]= NEXT_WEAPON;
        keyPrefs[KEY_0_PAD]= COUNTERMEASURE;
    }
    else if(player==1)
    {
        keyPrefs[KEY_W] = UP;
        keyPrefs[KEY_S] = DOWN;
        keyPrefs[KEY_A]= LEFT;
        keyPrefs[KEY_D]= RIGHT;
        keyPrefs[KEY_LCONTROL]= SHOOT;
        keyPrefs[KEY_LSHIFT]= NEXT_WEAPON;
        keyPrefs[KEY_SPACE]= COUNTERMEASURE;       
    }
}

// class constructor
Controller::Controller()
{
	// insert your code here
}

// class destructor
Controller::~Controller()
{
	// insert your code here
}

