#ifndef cclient_def
#define cclient_def

#include <cstdlib>
#include <cstdio>
#include <cmath>
#include <iostream>
#include <allegro.h>
#include <alleggl.h>
#include <gl\glu.h>	
#include <libnet.h>
#include "standards.h"

#include "CNetwork.h"
#include "CPacket.h"
#include "Server.h"

#include "Player.h"
#include "Game.h"

#ifndef QUEUE_SIZE
#define QUEUE_SIZE  100
#endif

using namespace std;


class Client
{
private:
    Server *local_server;
    CPacket incoming;
    
    Player temp_player;
    Player *you;
    Player player[MAX_CLIENTS];
    
    
    
    
    NET_CONN *server_conn;      //the connection to the server
    CNetworkConnection connection;
    CPacket packet;
    
    bool connected;
    Game *game;     //pointer to the game

    int iPlayer1Num, iPlayer2Num;
    Server *localServer;
    bool bInGame;
    
    CPacket queue[QUEUE_SIZE];
    int iQueueSize;
        
public:


    void close(void);


    void send(CPacket pack, int from=0);
    
    Client(void) {init();}
    ~Client(void) {}



    void run(void);

    void createPlayer(char *name, int att_num);
    
    void runText(char *message);
    
    void drawAllPlayers(void);
    
    
    void sendPacket(CPacket _incoming);
    void create(CNetworkConnection _connection, char *address);
    int recieve(void);
    int checkResponse(void);
    void init(void);
    void setGame(Game *_game) {game = _game;}
    
    
    void setPlayerAtts(int iPlayerNum,TPlayerAtts atts);
    int retPlayer1Num(void) {return iPlayer1Num; }
    Player* retPlayer1(void);
    
    
    void setAsLocal(Server *_local_server, bool _bHotSeat=false);
    void setupHotSeat(void);
    
    void update(void);
    void getKeys(void);
    void draw(void);
    void runLobby(TPlayerAtts atts, TPlayerAtts atts2);
    
    void thrust(void);
    void removeFromQueue(int n);
    
};


#endif
