#include "Client.h"

extern FONT* agl_font;







void Client::createPlayer(char *name, int att_num)
{
    iPlayer1Num=-1;
//    temp_player.create(name,att_num);  //create a temp player with the player's name
    you=&temp_player;
}

void Client::close(void)
{
    if(server_conn)
    {
        net_closeconn(server_conn);
            server_conn = (NET_CONN*)NULL;
    }
}







void Client::run(void)
{
    static char message[1024];

    if(local_server)
    {
        if(connected==false)
        {
            packet.create("ReJo");
            char *name=you->retName();
            int length=strlen(name);
            packet.appendByte(length);
            for(int n=0 ; n<length ; n++)
                packet.appendByte(name[n]);
//            packet.appendByte(you->retAttsNum());    
                       
            connected=true;     
            send(packet);

        }
        else
        {
            packet=incoming;
            incoming.init();
        }
    }
    else
    {
        if(connected==false && checkResponse()==1)  //connecting for the first time
        {
            packet.create("ReJo");
            
            char *name=you->retName();
            int length=strlen(name);
            packet.appendByte(length);
            for(int n=0 ; n<length ; n++)
                packet.appendByte(name[n]);
//            packet.appendByte(you->retAttsNum());
           
            connected=true; 
            send(packet);

        }
        
        if(connected==true)
 {}//           packet.setSize(recieve(packet.retData()));
    }
    
    
    if(connected==true)
    {

        if(packet.checkPacket("You")==1)
        {

            iPlayer1Num=packet.getNextByte();
            you=&player[iPlayer1Num];
        }
        else if(packet.checkPacket("text")==1)
        {
            int length=packet.getNextByte();

            for(int n=0 ; n<1024 ; n++)
                message[n]=0;

            for(int n=0 ; n<length ; n++)
                message[n]=packet.getNextByte();
        }
        
    }
    glEnable(GL_TEXTURE_2D);
        allegro_gl_printf(agl_font, 0, -4, 0, makecol(0, 255, 255), "%s",message);
    glDisable(GL_TEXTURE_2D);
    
    

        glEnable(GL_TEXTURE_2D);
            allegro_gl_printf(agl_font, 0, -1.5, 0, makecol(0, 255, 255), "Connected: %d Player num: %d",connected,iPlayer1Num);
        glDisable(GL_TEXTURE_2D);    
}
/*
void Client::runLobby(void)
{
    static char message[1024]="";
    
    run();
    
    runText(message);
    
    glEnable(GL_TEXTURE_2D);
        allegro_gl_printf(agl_font, 0, -3, 0, makecol(0, 255, 255), "%s",message);
    glDisable(GL_TEXTURE_2D);
    
}
*/

void Client::runText(char *message)
{
    static int cursor=0;

    if(keypressed())
    {
        char key=readkey()& 0xff;
        
        if(key==13)     //enter
        {
            packet.create("text");
            packet.appendByte(cursor);
            for(int n=0 ; n<cursor ; n++)
                packet.appendByte(message[n]);
                
            send(packet);
             
            cursor=0;
            message[0]=0;
        }
        else if(key==8) //backspace
        {
            if(cursor>0)
                cursor--;
            message[cursor]=0;  
        }
        else
        {
            message[cursor]=key;
            cursor++;
            message[cursor]=0;
        }
    }
}










void Client::create(CNetworkConnection _connection, char *address)
{

    connection=_connection;
    server_conn=net_openconn(connection.retNetworkDriver(), NULL);
    
    if(server_conn)
        outtext(LOGFILE,"Server connection made\n");
    
    net_connect(server_conn,address);  
    
     if(server_conn)
        outtext(LOGFILE,"Server connection made 222\n"); 

}

int Client::recieve(void)
{
    int ret=0;
    char data[1024];
    
    if(connected==true)
    {
        if(!localServer)  //there is no local server
        {
            //return net_receive_rdm(server_conn,data,1024);
            int iSize;
            iSize = net_receive_rdm(server_conn,data,1024);
            if(iSize>0)
            {
                if(iQueueSize<QUEUE_SIZE)
                {
                    queue[iQueueSize].setData(data,iSize);
                    iQueueSize++;
                }
            }
            
        }
     /*   else
        {
            if(incoming.retSize()>0)
            {
                if(iQueueSize<QUEUE_SIZE)
                {
                    queue[iQueueSize] = incoming;
                    iQueueSize++;
                }
            }
        }*/
    }
    else
        return 0;
        
    return ret;
}

void Client::send(CPacket pack, int from)
{
    if(!localServer && connected==true)   //not the local client
    {
        net_send_rdm(server_conn,pack.retData(),pack.retSize());
                // outtext(LOGFILE,"SEND\n");   
    }
    else if(localServer)
    {
            //char info[200];
            //sprintf(info,"S: %d \n",n);

    
        localServer->sendPacket(pack,from);
    }
}


void Client::sendPacket(CPacket _incoming)
{
    //incoming=_incoming;
    if(iQueueSize<QUEUE_SIZE)
    {
        queue[iQueueSize] = _incoming;
        iQueueSize++;
    }
}

//returns 0 on no response
//        1 when the connection is good
//       -1 when there is an error
int Client::checkResponse(void)
{
    outtext(LOGFILE,"in Client::checkResponse\n");
    int ret=0;  
    
    if(localServer) //there is a local server
    {
        outtext(LOGFILE,"     there is a local server\n");
        return 1;   //there is a local server, so of course it connected ok
    }
    else
    {
        outtext(LOGFILE,"     there is not a local server\n");
      //  if(server_conn)
        ret = net_poll_connect(server_conn);
      //  else
      //      outtext(LOGFILE,"No Server Connection Here\n");
    
        if(ret==0)  //no response yet
        {
            return 0;
        }
        else if(ret<0)  //error
        {
            net_closeconn(server_conn);
            return -1;
        }
        else    //its all good
            return 1;

    }
    return ret;
}


void Client::init(void)
{
    local_server = (Server*)NULL;
    
    
    
    server_conn = (NET_CONN*)NULL;
    connected=false;
    iPlayer1Num=-1;
    iPlayer2Num=-1;
//    bHotSeat=false;
    localServer = (Server*)NULL;
    bInGame=false;
    
    for(int n=0 ; n<QUEUE_SIZE ; n++)
        queue[n].init();
    iQueueSize=0;
}


void Client::draw(void)
{
    /*if(bHotSeat)
    {
        player[iPlayer1Num].drawHotSeatHUD();
        player[iPlayer2Num].drawHotSeatHUD();
    }
    else
    {
        player[iPlayer1Num].drawHUD();
    }*/
    //drawAllPlayers();
}

void Client::drawAllPlayers(void)
{
    for(int n=0 ; n<MAX_CLIENTS ; n++)
    {
        if(player[n].retExist()==true)
        {
            player[n].draw();
        }
    }
}


void Client::setAsLocal(Server *_local_server, bool _bHotSeat) 
{
    outtext(LOGFILE,"Client set as local\n");
    localServer=_local_server; 
    connected=false; 
    game->bHotSeat = _bHotSeat;

    if(game->bHotSeat==true)
        setupHotSeat();
}

void Client::setupHotSeat(void)
{
    //iPlayer1Num=0;
    //iPlayer2Num=1;
}

void Client::update(void)
{
    if(connected==true)    //it is connected
    {
        recieve();
        
        CPacket recieved;
        for(int n=0 ; n<iQueueSize ; n++)
        {
            recieved.init();
            //recieved = retNextPacket();
            
            recieved = queue[n];
            
            if(recieved.checkPacket("sPos")==1)
            {
                int iPlayerNum = recieved.getNextByte();
                float x,y,vx,vy,vm,ax,ay,am;
                
            /*packet.appendFloat(ship->retPos().retX());
            packet.appendFloat(ship->retPos().retY());
            packet.appendFloat(ship->retVel().retX());
            packet.appendFloat(ship->retVel().retY());
            packet.appendFloat(ship->retVel().retMag());
            packet.appendFloat(ship->retAccel().retX());
            packet.appendFloat(ship->retAccel().retY());
            packet.appendFloat(ship->retAccel().retMag());*/          
                
                
                //position
                x=recieved.getFloat();
                y=recieved.getFloat();
                
                //velocity
                vx=recieved.getFloat();
                vy=recieved.getFloat();
                vm=recieved.getFloat();

                //accleration
                ax=recieved.getFloat();
                ay=recieved.getFloat();
                am=recieved.getFloat();
 
            /*           
                char string[60];
                sprintf(string,"Player: %d Pos: %f,%f\n",iPlayerNum,x,y);
                outtext(LOGFILE,string);
            */
            
                Ship *tempShip;
                tempShip = game->retShip(iPlayerNum);
                if(tempShip)
                {
                    CVector2 pos(x,y,true),vel(vx,vy,false),accel(ax,ay,false);
                    
                    vel.setMag(vm);
                    accel.setMag(am);
                    
                    /*
                    if(!(tempShip->retPos()==pos))
                    {
                        tempShip->setPos(pos);
                    }
                    else
                        tempShip->retVel().setMag(0);
                        
                    //if(!(tempShip->retAccel()==accel))
                        tempShip->setAccel(accel);*/
                    tempShip->setPos(pos);
                    tempShip->setVel(vel);
                    tempShip->setAccel(accel);
                }
 
            }
            removeFromQueue(n);
        }
    }
}

void Client::getKeys(void)
{
    Ship *ship = game->retShip(iPlayer1Num);
    static bool kp1=false,kp2=false;

    if(ship)
    {
        packet.init();
        packet.create("keys");

        if(localServer)
        {
            if(key[KEY_UP])
                ship->thrust();  

            ship->dampenVelocity();
            if(!key[KEY_UP])
                ship->thrusting=false;    //reset the thrusting var
        
            if(key[KEY_RCONTROL])
                ship->shoot(/*game->retNextProj()*/game->retProjArray());
        
            if(key[KEY_LEFT])
                ship->turnLeft();
            else if(key[KEY_RIGHT])
                ship->turnRight();
            else
                ship->dampenAngVelocity();
                
            if(key[KEY_RSHIFT] && kp1==false)
            {
                ship->nextWeapon();
                kp1=true;
            }
            if(!key[KEY_RSHIFT])
                kp1=false;
        }
        else
        {     
            if(key[KEY_UP])
                packet.appendByte('u');
            //else
            //    packet.appendByte(/*(unsigned char)0*/');
            
            if(key[KEY_LEFT])
                packet.appendByte('l');
            else if(key[KEY_RIGHT])
                packet.appendByte('r');
            //else
            //    packet.appendByte((unsigned char)0);
                  
            if(key[KEY_RSHIFT] && kp1==false)
            {
                packet.appendByte('n');
                kp1=true;
            }
            if(!key[KEY_RSHIFT])
                kp1=false;
                
            if(key[KEY_RCONTROL])
                packet.appendByte('s');
                
            packet.appendByte('X');
            send(packet);
        }
    }
    
    if(game->bHotSeat==true)  //if it is a hotseat game
    {
        Ship *ship2 = game->retShip(iPlayer2Num);
        if(ship2)
        {
            if(key[KEY_W])
                ship2->thrust();  
            else
                ship2->dampenVelocity();
            
            if(key[KEY_LCONTROL])
                ship2->shoot(/*game->retNextProj()*/game->retProjArray());
            
            if(key[KEY_LSHIFT] && kp2==false)
            {
                ship2->nextWeapon();
                kp2=true;
            }
            if(!key[KEY_LSHIFT])
                kp2=false;
            
            if(key[KEY_A])
                ship2->turnLeft();
            else if(key[KEY_D])
                ship2->turnRight();
            else
                ship2->dampenAngVelocity();  
        }
    }
}

void Client::runLobby(TPlayerAtts atts, TPlayerAtts atts2)
{
    outtext(LOGFILE,"in Client::runLobby\n");
    if(connected==false && checkResponse()==1)  //connecting for the first time
    {  
        connected=true;     //it is now connected
        outtext(LOGFILE,"Client connected\n");
        
        //so send a packet requesting to join the game
        packet.create("ReJo");    //create a request join packet

        send(packet);
        outtext(LOGFILE,"Rejo packet sent to server\n");

        if(game->bHotSeat==true)
            send(packet,1);
        

    }  
    else if(connected==true)    //it is connected
    {
        char data[1024];
        int iSize;
        
        recieve();  //recieve data from the server
        
        CPacket recieved;
        
        for(int n=0 ; n<iQueueSize ; n++)
        {
            recieved = queue[n];
            packet.init();
            packet.setData(data,iSize);
        
            if(recieved.checkPacket("You")==1)
            {
                bInGame=true;   //the player is now in the game
                
                if(iPlayer1Num==-1) //the player has not already been added
                {
                    iPlayer1Num=recieved.getNextByte();
            
                    char text[30];
                    sprintf(text,"Client assigned player num: %d by server\n",iPlayer1Num);
                    outtext(LOGFILE,text);
            
                    //add this player to the game
                    game->createPlayer(iPlayer1Num);
                    outtext(LOGFILE,"Player added to client-side of game\n");
            
                    removeFromQueue(n);
 
                    setPlayerAtts(iPlayer1Num , atts);
                }
                //else if player one has already been added, and it is a hot seat game,
                //then this 'You' packet must be for the second player
                else if( game->bHotSeat==true /*&& iPlayer2Num==-1*/) 
                {
                    iPlayer2Num=recieved.getNextByte();
                    game->createPlayer(iPlayer2Num);
                    removeFromQueue(n);
                    setPlayerAtts(iPlayer2Num , atts2);
                }
            }
            else if(recieved.checkPacket("add")==1)
            {
                int iNum=recieved.getNextByte();
                game->createPlayer(iNum);
                removeFromQueue(n);
            }
            else if(recieved.checkPacket("atts")==1)  //a packet with player atts has been recieved
            {
                TPlayerAtts atts;
            
                strcpy(atts.sName,"");
                atts.iColour=0;
                atts.iShipNum=recieved.getNextByte();
                int iPlayerNum = recieved.getNextByte();
            
                game->setPlayerAtts(iPlayerNum,atts);
            
                packet.init();
                removeFromQueue(n);
            }
        }
        
/*        
        allegro_gl_begin();    
            glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
        
            glEnable(GL_TEXTURE_2D);
                allegro_gl_printf(agl_font, 0, 6, 0, makecol(0, 255, 255), "Num: %d",iPlayer1Num);
                allegro_gl_printf(agl_font, 0, 4, 0, makecol(0, 255, 255), "There are %d players",game->retNumPlayers());

            glDisable(GL_TEXTURE_2D);
        
            glFlush();
            allegro_gl_flip();   
        allegro_gl_end();
*/        
    }
    else
    {
        allegro_gl_begin();    
            glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
        
            glEnable(GL_TEXTURE_2D);
                allegro_gl_printf(agl_font, 0, 6, 0, makecol(0, 255, 255), "Not Connected");
            glDisable(GL_TEXTURE_2D);
        
            glFlush();
            allegro_gl_flip();   
        allegro_gl_end();
    }
}

void Client::setPlayerAtts(int iPlayerNum,TPlayerAtts atts)
{
    game->setPlayerAtts(iPlayerNum,atts); 
       
    packet.init();
    packet.create("atts");
    packet.appendByte(atts.iShipNum);
        
    send(packet,iPlayerNum);
    
    
    /*game->retPlayer(iPlayerNum)->setid(iPlayerNum);
            
    char text[30];
    sprintf(text,"Player %d's id set\n",iPlayerNum);
    outtext(LOGFILE,text);*/
    /*
    if(bHotSeat==true)
    {
        game->setPlayerAtts(iPlayer2Num,atts);
        
        packet.init();
        packet.create("atts");
        packet.appendByte(atts.iShipNum);
        
        send(packet);
    }*/
}

Player* Client::retPlayer1(void)
{
    if(game)
    {
        return game->retPlayer(iPlayer1Num);
    }
    return(Player*)NULL;
}

/*
CPacket Client::retNextPacket(void)
{
    CPacket ret;
    ret.init();
    if(iQueueSize>0)
    {
        ret = queue[0];
        for(int n=1 ; n<iQueueSize ; n++)
        {
            queue[n-1] = queue[n];
        }
        iQueueSize--;
    }
    
    return ret;
}*/

void Client::removeFromQueue(int n)
{
    for(int i=n+1 ; i<iQueueSize ; i++)
    {
        queue[i-1] = queue[i];
    }
    iQueueSize--;
}
