/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/

#ifndef CHECKBOX_H
#define CHECKBOX_H

#include <cstdlib>
#include <cstdio>
#include <cmath>
#include <allegro.h>
#include <alleggl.h>
#include "Standards.h"
#include "Button.h" // inheriting class's header file


class CheckBox : public Button
{
protected:
    bool checked;    
    
public:
    CheckBox(int _id, CVector2 pos, float w, float h, FONT *f, char *c, TButtonAtts &ba, bool _checked=false);
    CheckBox(const CheckBox &other);
    ~CheckBox();
    
    void draw(void);
    void update(TMouse &mouse);
    
    void onButtonPressed(void);
    TWidgetStatus checkStatus(void);
};

#endif // CHECKBOX_H

