/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/

#include "CheckBox.h" // class's header file

CheckBox::CheckBox(int _id, CVector2 pos, float w, float h, FONT *f, char *c, TButtonAtts &ba, bool _checked) : Button(_id,pos,w,h,f,c,ba)
{
    checked=_checked;        
}
    
CheckBox::CheckBox(const CheckBox &other) : Button(other)
{
    checked = other.checked;    
}    

void CheckBox::draw(void)
{
    drawOutline(atts.outlineColourHighlighted);
    
    if(checked) //if it is checked
    {
        glDisable(GL_LIGHTING);
        glBegin(GL_LINES);

            /*float c[4]={atts.outlineColourHighlighted[0],atts.outlineColourHighlighted[1],atts.outlineColourHighlighted[2],1};
            glMaterialfv( GL_FRONT, GL_DIFFUSE, c );
            glNormal3f(0,0,1);*/
            glColor3fv(atts.outlineColourHighlighted);
            
            glVertex3f(pos.retX() + br_offset.retX(),pos.retY() + br_offset.retY(),0);  //bottom right
            glVertex3f(pos.retX() + tl_offset.retX(),pos.retY() + tl_offset.retY(),0);  //top left
            
            glVertex3f(pos.retX() + br_offset.retX(),pos.retY() + tl_offset.retY(),0);  //top right
            glVertex3f(pos.retX() + tl_offset.retX(),pos.retY() + br_offset.retY(),0);  //bottom left
            
            //glVertex3f(br_offset.retX(),br_offset.retY(),0);  //bottom right
        glEnd();     
    }    
    
    if(caption)
    {    
        int captionColour;
        if(buttonDown)
            captionColour = makecol(atts.captionColourDown[0],atts.captionColourDown[1],atts.captionColourDown[2]);
        else if(bMouseOver)
            captionColour = makecol(atts.captionColourHighlighted[0],atts.captionColourHighlighted[1],atts.captionColourHighlighted[2]);
        else
            captionColour = makecol(atts.captionColour[0],atts.captionColour[1],atts.captionColour[2]);

        writeText_3D(pos.retX()+br_offset.retX()+.5, pos.retY()+tl_offset.retY(), 0, captionColour, labelFont, caption);   
    }
}
    
void CheckBox::update(TMouse &mouse)
{
    bool oButtonDown = buttonDown;  //get if the button is being pressed right now
    Button::update(mouse);   
    
    if(buttonDown && !oButtonDown)  //if it is just being clicked now
    {
        checked=!checked;           //change it's checked status
    }    
    
} 

void CheckBox::onButtonPressed(void)
{
    //do nothing when a checkbox is pressed
}    

TWidgetStatus CheckBox::checkStatus(void)
{
    TWidgetStatus s;
    s.id=id;
    s.notify=false;
    //s.value = (checked==true)?CB_SELECTED : CB_NOT_SELECTED;
    if(checked==true)
        s.value = CB_SELECTED;
    else
        s.value = CB_NOT_SELECTED;
    
   return s;   
} 
