/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/

#ifndef cvector2_def
#define cvector2_def

#include <cstdlib>
#include <cstdio>
#include <cmath>

#include "Standards.h"

using namespace std;

class CVector2
{
private:
    float x,y;
    float mag; 
    
    bool position;  //whether or not it is a position vector
    bool normalized;
    

    CVector2 add(CVector2 op1, CVector2 op2);
    CVector2 sub(CVector2 op1, CVector2 op2);
    CVector2 div(CVector2 op1, float op2);
    CVector2 mult(CVector2 op1, float op2);
    
    float dotProd(CVector2 op1, CVector2 op2);
    
public:
    
    void zero(void) {x=0; y=0; mag=0; normalized=false;}
    void isPosition(bool _position);
    void setVector(float _x, float _y, bool _position=true, bool _normalized=false);
    void printVector(BITMAP *backgr, int px, int py);
    
    CVector2 findNormal(void);
    CVector2 rotate(float angle);
    
    bool isNormalized(void) {return normalized;}
    static CVector2 normalize(CVector2 vect);
    
    /**********DATA ACCESS*********************/
    float retX(void) {return x;}
    float retY(void) {return y;}
    float retMag(void) {return mag;}
    
    void setX(float _x) {x=_x;}    
    void setY(float _y) {y=_y;}    
    
    void setMag(float _mag) { mag=_mag; }
    
    /*********OVERLOADED OPERATORS*************/
    //normalize
    CVector2 operator~(void);
    //dot product
    float operator|(CVector2 op2);
    
    //vector addition and subtraction
    CVector2 operator+(CVector2 op2);
    CVector2 operator-(CVector2 op2);
    CVector2 operator+=(CVector2 op2);
    CVector2 operator-=(CVector2 op2);
    
    //unary negative
    CVector2 operator-(void);
    
    //scalar division
    CVector2 operator/(float op2);
    CVector2 operator/=(float op2);
    
    //scalar multiplication
    CVector2 operator*(float op2);
    CVector2 operator*=(float op2);
    friend CVector2 operator*(float op1, CVector2 op2);
    
    friend bool operator==(CVector2 op1, CVector2 op2);
    
    /************INITIALIAZTION ROUTINES*********/
    void init(void) {x=0; y=0; mag=0; position=true; normalized=false;}
    CVector2::CVector2(void) {init();}
    CVector2::CVector2(float _x,float _y, bool _position=true) {init(); setVector(_x,_y,_position,false); }
    CVector2::~CVector2(void) {}
};

CVector2 makeVector2(float x,float y, bool position);
#endif
