/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/

#include "CVector2.h"

CVector2 CVector2::normalize(CVector2 vect)
{
    CVector2 ret=vect;
    
    if(vect.position==false)    //only normalize it if it is not a position vector
    {
        if(vect.normalized==true) //if it is already normalized
            ret=vect;
        else
        {
            ret.mag = sqrt(vect.x*vect.x + vect.y*vect.y);
            
            if(ret.mag!=0)
            {
                ret.x = vect.x / ret.mag;
                ret.y = vect.y / ret.mag;
            }
            ret.normalized=true;
        }
    }
    return ret;     
}

void CVector2::printVector(BITMAP *backgr, int px, int py)
{
    //textprintf(backgr,font,px,py,makecol(255,0,0),"%f %f mag:%f",x,y,mag);
}

void CVector2::isPosition(bool _position)
{
    position=_position;
    
    if(position==false)     //it is now no longer a position vector
        *this = ~(*this);   //normalize it
}

void CVector2::setVector(float _x, float _y, bool _position, bool _normalized)
{ 
    init();
    
    x=_x; 
    y=_y; 
    position=_position; 
    normalized=_normalized;
    
    if(position==false && normalized==false)
        *this = normalize(*this);
}

CVector2 CVector2::add(CVector2 op1, CVector2 op2)
{
    CVector2 ret=op1;
    
    if(ret.position==true)
    {
        if(op2.position==false)
        {
            ret.x += op2.x * op2.mag;
            ret.y += op2.y * op2.mag;
        }
        else
        {
            ret.x += op2.x;
            ret.y += op2.y;
        }
    }
    
    else
    {
        if(op2.position==false)
        {
           ret.x*=ret.mag;
           ret.y*=ret.mag; 
           if(op2.position==false)
            {
                ret.x += op2.x * op2.mag;
                ret.y += op2.y * op2.mag;
            }
            else
            {
                ret.x += op2.x;
                ret.y += op2.y;
            }
            ret.normalized=false;
            ret=~ret;
        }
    
    }
    return ret;
}

CVector2 CVector2::sub(CVector2 op1, CVector2 op2)
{
    return add(op1,-op2);
}

float CVector2::dotProd(CVector2 op1, CVector2 op2)
{
    float ret=0;

    ret = op1.x * op2.x + op1.y * op2.y;
    return ret;
}

CVector2 CVector2::div(CVector2 op1, float op2)
{
    CVector2 ret=op1;
    
    if(op1.position==false)
    {
        ret.mag = op1.mag/op2;
    }
    else
    {
        ret.x = op1.x / op2;
        ret.y = op1.y / op2;
    }

    return ret;
}

CVector2 CVector2::mult(CVector2 op1, float op2)
{
    CVector2 ret=op1;
    
    if(op1.position==false)
    {
        ret.mag = op1.mag*op2;
    }
    else
    {
        ret.x = op1.x * op2;
        ret.y = op1.y * op2;
    }

    return ret;
}

CVector2 CVector2::findNormal(void)
{
    CVector2 ret=*this;
    
    ret.x=y;
    ret.y=-x;
    
    ret.isPosition(false);  //a normal is not a position vector

    return ret;
}

//rotates the vector a given number of radians
CVector2 CVector2::rotate(float angle)
{
    CVector2 ret=*this;
    
    ret.x =  x*cos(angle) + y*sin(angle);
    ret.y = -x*sin(angle) + y*cos(angle);
    
    return ret;
}

/******************OVERLOADED OPERATORS********************/

//normalize
CVector2 CVector2::operator~(void)
{
    CVector2 ret = normalize(*this);
    return ret;
}


//vector addition and subtraction
CVector2 CVector2::operator+(CVector2 op2)
{
    CVector2 ret = add(*this,op2);
    return ret;
}

CVector2 CVector2::operator+=(CVector2 op2)
{
    *this = add(*this,op2);
    return *this;
}

CVector2 CVector2::operator-(CVector2 op2)
{
    CVector2 ret = sub(*this,op2);
    return ret;
}


CVector2 CVector2::operator-=(CVector2 op2)
{
    *this = sub(*this,op2);
    return *this;
}

CVector2 CVector2::operator-(void)
{
    CVector2 ret=*this;
    
    ret.x=-ret.x;
    ret.y=-ret.y;
     
    return ret;
}

//dot product
float CVector2::operator|(CVector2 op2)
{
    return dotProd(*this,op2);
}

//scalar division
CVector2 CVector2::operator/(float op2)
{
    return div(*this,op2);
}

CVector2 CVector2::operator/=(float op2)
{
    *this= div(*this,op2);
    return *this;
}

//scalar multiplication
CVector2 CVector2::operator*(float op2)
{
    return mult(*this,op2);
}

CVector2 CVector2::operator*=(float op2)
{
    *this = mult(*this,op2);
    return *this;
}


//a friend function
CVector2 operator*(float op1, CVector2 op2)
{
    return op2.mult(op2,op1);
}

//a friend function
bool operator==(CVector2 op1, CVector2 op2)
{
    return (op1.x==op2.x && op1.y==op2.y && op1.mag==op2.mag);
}


CVector2 makeVector2(float x,float y, bool position)
{
    CVector2 ret(x,y,position);
    return ret;
}
