#ifndef cvobject_def
#define cvobject_def

#include <cstdlib>
#include <cstdio>
#include <cmath>

#include <allegro.h>
#include <alleggl.h>

#include "Standards.h"
#include "CVector2.h"

using namespace std;

typedef struct
{
    float accel, max_vel;
    float rot_accel, rot_max_vel;
}TVObjectAtts;

class CVObject
{
private:
    CVector2 pos,vel,accel;
    float rot_vel, rot_accel;
    
    bool exist;
    
    float bank;
    
    TVObjectAtts atts;

public:

    void setAccel(float x, float y, float mag);
    void setVel(float x, float y, float mag);

    void move(void);
    void applyFriction(float amount);
    void applyAngFriction(float amount);
    
    void thrust(void);
    void turnRight(void);
    void turnLeft(void);

    void draw(void);
    
    /***********DATA ACCESS*******************/
    void setPos(CVector2 _pos) {pos=_pos;}
    void setVel(CVector2 _vel) {vel=_vel;}
    void setAccel(CVector2 _accel) {accel=_accel;}
    void setAtts(TVObjectAtts _atts) {atts=_atts;}
    
    CVector2 retPos(void) {return pos;}
    CVector2 retVel(void) {return vel;}
    CVector2 retAccel(void) {return accel;}
    TVObjectAtts retAtts(void) {return atts;}
    
    /***********INITIALIZATION*****************/
    void init(void);
    void create(CVector2 _pos, CVector2 _vel, CVector2 _accel);
    
    CVObject(){ init(); }
    CVObject(CVector2 _pos, CVector2 _vel, CVector2 _accel) 
        { create(_pos,_vel,_accel); }
    CVObject(CVector2 _pos, CVector2 _vel, CVector2 _accel, TVObjectAtts _atts) 
        { create(_pos,_vel,_accel); atts=_atts; }
    
    ~CVObject(void){ }

};


#endif
