#include "CVObject.h"

void CVObject::thrust(void)
{ 
    accel.setMag(atts.accel);
}

void CVObject::turnRight(void) 
{ 
    rot_accel=-atts.rot_accel;
    
    if(bank>-45)
        bank-=5 * accel.retMag()*100;
} 

void CVObject::turnLeft(void) 
{ 
    rot_accel=+atts.rot_accel;
    
    if(bank<45)
        bank+=5 * accel.retMag()*100;
}


void CVObject::move(void)
{
    vel+=accel;
    
    if(vel.retMag()>atts.max_vel)
        vel.setMag(atts.max_vel);
        
    pos+=vel;

    if((rot_vel<atts.rot_max_vel && rot_accel>0) ||
       (rot_vel>-atts.rot_max_vel && rot_accel<0))
        rot_vel += rot_accel;

    accel=accel.rotate(rot_vel); 

    if(bank>0)
        bank--;
    else if(bank<0)
        bank++;
}

void CVObject::applyFriction(float amount)
{
    accel.setMag(0);
    vel*=amount;
}

void CVObject::applyAngFriction(float amount)
{
    rot_accel=0;
    rot_vel*=amount;
}

void CVObject::setAccel(float x, float y, float mag)
{
    accel.setVector(x,y,false,false);
    accel.setMag(mag);
}

void CVObject::setVel(float x, float y, float mag)
{
    vel.setVector(x,y,false,false);
    vel.setMag(mag);
}

void CVObject::draw(void)
{

        
    glPushMatrix();            
           
    CVector2 yAxis(0,1,false);
    float angRad = acos(yAxis|accel);  
    
    if(accel.retX()<0)
        angRad=-angRad;        
       
    glTranslatef(-pos.retX(),pos.retY(),0); 
    
    glRotatef(angRad*RAD2DEG,0,0,1);            
    
    //glRotatef(angle*RAD2DEG,0,0,1);
    glRotatef(bank,0,1,0);
          
                                                
    glBegin(GL_TRIANGLES);
    
        
        glColor3f(1,1,1); glVertex3f(0,1,0);
        glColor3f(0,0,1); glVertex3f(-.5,-.5,0);
        glColor3f(.8,1,.8); glVertex3f(0,.5,-.4);
        
        
        
        glColor3f(0,0,1); glVertex3f(-.5,-.5,0);
        glColor3f(0,0,1); glVertex3f(.5,-.5,0);
        glColor3f(.8,1,.8); glVertex3f(0,.5,-.4);
        
        
        
        glColor3f(1,1,1); glVertex3f(0,1,0);
        glColor3f(0,0,1); glVertex3f(.5,-.5,0);
        glColor3f(.8,1,.8); glVertex3f(0,.5,-.4);
        
        
    glEnd();
    
    glPopMatrix();
    
}

void CVObject::init(void)
{
    exist=false;
    pos.zero();
    vel.zero();
    accel.zero();
    //angle=M_PI/2;
    bank=0;
    
    atts.accel=0;
    atts.max_vel=0;
    
    atts.rot_accel=0;
    atts.rot_max_vel=0;
    
 //   pos.setVector(54,245,true);
    
    
}

void CVObject::create(CVector2 _pos, CVector2 _vel, CVector2 _accel)
{    
    exist=true;
    pos=_pos;
    vel=_vel;
    accel=_accel;
    
    outtext(LOGFILE,"HERE!!!");
}
