#ifndef cserver_def
#define cserver_def

#include <cstdlib>
#include <cstdio>
#include <cmath>
#include <iostream>
#include <allegro.h>
#include <alleggl.h>
#include <gl\glu.h>	
#include <libnet.h>
#include "standards.h"

#include "CNetwork.h"
#include "CPacket.h"
#include "CPlayer.h"

#define MAX_CLIENTS 8

class CClient;

class CServer
{
private:
    NET_CONN *listen_conn;
    NET_CONN *client_conn[MAX_CLIENTS];
    int number_of_clients;
    
    CNetworkConnection connection;
    CPacket packet;
    CPacket incoming;

    CClient *local_client;
    
    CPlayer player[MAX_CLIENTS];
    int number_of_players;

public:
    void init(void);
    void create(CNetworkConnection _connection);          //initializes he connections
    void closeServer(void);     //closes all open connections
    int listen(void);          //listens for connecting clients
    int recieve(char *data, int *sender);   //recieves data and stores info in the given pointers
    void sendTo(CPacket pack, int client_num);   //sends a chunk of data to the given client
    void broadcast(CPacket pack); //sends the chunk of data to all clients

    void sendPacket(CPacket _incoming) {incoming=_incoming;}
    
    CServer(void) {init();}
    ~CServer(void) {}
    
    void setLocalClient(CClient *_local_client);
    
    void run(void);
    void runLobby(void);
    void addPlayer(char *name, int atts_num);
    
    void runText(int sender);
};


#endif
