#include "CServer.h"
#include "CClient.h"

extern FONT* agl_font;

void CServer::init(void)
{
    listen_conn=(NET_CONN*)NULL;
    for(int n=1 ; n<MAX_CLIENTS ; n++)
        client_conn[n]=(NET_CONN*)NULL;
    number_of_clients=1;
    number_of_players=0;
}

void CServer::create(CNetworkConnection _connection)
{
    connection=_connection;
    
    
    //open an listening connection
    listen_conn = net_openconn(connection.retNetworkDriver(), "");
    
    net_listen(listen_conn);    //start listening on the listen connection

}

void CServer::closeServer(void)
{
    //closes all of the clients connections
    for(int n=1 ; n<number_of_clients ; n++)
    {
        if(client_conn[n])
        {
            net_closeconn(client_conn[n]);
            client_conn[n]=(NET_CONN*)NULL;
        }
    }
    
    //closes the listening connection
    if(listen_conn)
    {
        net_closeconn(listen_conn);
        listen_conn=(NET_CONN*)NULL;
    }
}

//returns 1 when a new connection is made
//        0 when no new connection
int CServer::listen(void)
{
    NET_CONN* new_conn = (NET_CONN*)NULL;
 
    //listen on the listening connection, and, if a connection is being made
    //store the new connection in new_conn   
    new_conn = net_poll_listen(listen_conn);
    
    //if a new connection has been made
    if(new_conn)
    {
        //store it in the next client connection spot
        client_conn[number_of_clients] = new_conn;
        number_of_clients++;
        return 1;
    }
    
    return 0;
}

//recieve data
//returns the size of the recieved data
int CServer::recieve(char *data, int *sender)
{
    int data_length=0;
    for(int n=1 ; n<number_of_clients ; n++)
    {
        //go through all of the clients and check of incoming data
        //if any is found, store it in the passed array
        data_length=net_receive_rdm(client_conn[n], data, 1024);
        if(data_length>0)
        {
            //send back the sender, and the length of the data
            *sender = n;
            return data_length;
        }
    }
    return -1;
}

void CServer::sendTo(CPacket pack, int client_num)   //sends a chunk of data to the given client
{
    if(client_num==0)    //the local client
        local_client->sendPacket(pack);   
    else if(client_conn[client_num])
        net_send_rdm(client_conn[client_num],pack.retData(),pack.retSize());
}

void CServer::broadcast(CPacket pack) //sends the chunk of data to all clients
{
    for(int n=1 ; n<number_of_clients ; n++)
    {
        if(client_conn[n])
            net_send_rdm(client_conn[n],pack.retData(),pack.retSize());
    }
    local_client->sendPacket(pack);
}



void CServer::run(void)
{
    if(listen()==1)     //there is a new connection
    {
        /*
        packet.create("join");  //create a 'join' packet to send to the client
        //adds the number assigned to the client to the packet
        packet.appendByte(number_of_clients-1);
        //sends the packet to the player
        send_to(packet.retData(),number_of_clients-1,packet.retSize());
        */
        
    }
    
    //clear the packet
    packet.init();
    int sender=0;  
    
    if(incoming.retSize()>0)    //there is a packet waiting from the local client
    {
    
        packet=incoming;
        sender=0;              //0 means it is the local client
        incoming.init();
    }
    else
    {
        //recieve new data, storing it in the packet, and recording the sender
        packet.setSize(recieve(packet.retData(),&sender));
    } 
    
    if(packet.retSize()>0)  //if a packet was recieved
    {
        if(packet.checkPacket("ReJo")==1)  //check to see if a request to join has been recieved
        {
            char name[30];
            int length=packet.getNextByte();
            for(int n=0 ; n<length ; n++)
                name[n]=packet.getNextByte();
                
            int atts_num=packet.getNextByte();     //represents the ship the player has choosen
                
            addPlayer(name,atts_num);    
                
            //create a new packet holding the number assigned to the client
            packet.create("You");
            packet.appendByte(sender);
            //send it back to the client
            sendTo(packet,sender);
        }
        else if(packet.checkPacket("text")==1)
        {
            runText(sender);    //handels the recieving and broadcasting of any messages      
        }    
    }
}


void CServer::runText(int sender)
{
    static char message[1024]="";

    int name_length=strlen(player[sender].retName());           //length of the name of the sender
    int message_length=packet.getNextByte() + name_length +2;   //length of the name of the sender plus the length of the actual message plus 2 extra for the colon and space
            
    char *name = player[sender].retName();  //get the name of the player that sent the message
    
    //clear the buffer for the outgoing message
    for(int n=0 ; n<1024 ; n++)
        message[n]=0;
    
    int n;
    //add the name of the sender to the message
    for(n=0 ; n<name_length ; n++)
        message[n]=name[n];
        
    //add the colon and the space
    message[n]=':';
    message[n+1]=' ';
    n+=2;

    //add the recieved message (from the packet) to the outgoing message
    for(; n<message_length ; n++)
        message[n]=packet.getNextByte();
    message[n+1]=0;
            
    //create a new packet with this new message in it, and broadcast that    
    packet.create("text");
    packet.appendByte(message_length+1);
    for(n=0 ; n<message_length+1 ; n++)
        packet.appendByte(message[n]);
                    
    broadcast(packet);
}

void CServer::runLobby(void)
{
    static char message[1024]="";
    static int cursor=0;
    
    run();

    
    glEnable(GL_TEXTURE_2D);
        allegro_gl_printf(agl_font, 0, -3, 0, makecol(0, 255, 255), "%s",message);
    glDisable(GL_TEXTURE_2D);
}

void CServer::setLocalClient(CClient *_local_client) 
{
    local_client = _local_client;
}

void CServer::addPlayer(char *name, int atts_num)
{
    if(number_of_players<MAX_CLIENTS)
    {
        player[number_of_players].create(name,atts_num);
        
        CVector2 pos;
        
        
        if(number_of_players==0)
            pos.setVector(-5,-5,true);
        else
            pos.setVector(5,5,true);
            
        CVector2 vel(0,0,false),accel(-1,0,false);
        
        player[number_of_players].setPosition(pos,vel,accel);
        
        number_of_players++;
    
    }
}
