#include "CList.h"

template<class dataType>
int CList<dataType>::operator[](int op2)
{
    return access(op2);
}

template<class dataType>
int CList<dataType>::getSize(void)
{
    int counter=0;
    cNode<dataType> *i;
    
    if(first){
    for(i=first ; i->getNext() ; i=i->getNext())
    {
        counter++;
    }
    counter++;  //add one, because generally when counting, people don't
                //start at 0 like C does.
    }
    
    return counter;
}

//returns the nth element in the list. If n larger than the last element,
//it will return the least element. If n is negative, it will return the first
//element
template<class dataType>
dataType CList<dataType>::access(int n)
{
    cNode<dataType> *i; 
    int counter=0;
    
    if(n>0)
    {  
    
    //goes through the list, starting at the first node, and continuing while
    //we're not at the end of the list and have not yet reached the spot we want
    for(i=first ; i->getNext() ; i=i->getNext())
    {
        if(counter>=n)
            break;
        counter++;
    }
    }
    else
        i=first;
    
    return i->returnValue();        
}

//adds a new element to the end of the list
template<class dataType> 
void CList<dataType>::add(dataType data)
{
    //creates a node
    cNode<dataType> *node = new cNode<dataType>;
    //puts the given data into the node
    node->setValue(data);

    cNode<dataType> *i;    //a temp node used for going through the list
    if(!first)            //if there is no first node already
    {
        first=node;        //this node is then the first
        first->setLast();  //and last nodes in the list
    }
    else
    {
        //finds tha last node in the list. i will then point to it.
        for(i=first ; i->getNext() ; i=i->getNext());     
        //this new node will be the last node in the list
        node->setLast();       
        //get the previous last node to add the new node
        i->add(node);
    }     
}

//inserts the given piece of data after the nth element
//a negative number for n will insert the node that the start of the list
//and a large number will place it at the end
template<class dataType> 
void CList<dataType>::insertAfter(dataType data, int n)
{
    int counter=0;
    cNode<dataType> *i;    //a temp node used for going through the list
    //creates a node
    cNode<dataType> *node = new cNode<dataType>;
    //puts the given data into the node
    node->setValue(data);
    
    //if n is a negative index, it means to insert the node
    //at the start of the list
    if(n<0) 
    {
        node->add(first);
        first=node;
    }
    else
    {
    //goes through the whole list, and finds the nth spot as long as it is not out of bounds
    //i will be the nth element
    for(i=first ; i->getNext() ; i=i->getNext())
    {
        if(counter>=n)
            break;
        counter++;
    }
    
    //the node to be added is given the pointer for the next node from the ith node
    node->add(i->getNext());
    
    //the ith node is then told to point at the new one
    i->add(node);
    }
}

//inserts the given data before the nth element
//a negative number for n will insert the node that the start of the list
//and a large number will place it at the end
template<class dataType> 
void CList<dataType>::insertBefore(dataType data, int n)
{
    int counter=1;
    cNode<dataType> *i;    //a temp node used for going through the list
    //creates a node
    cNode<dataType> *node = new cNode<dataType>;
    //puts the given data into the node
    node->setValue(data);
        
    //if n is referring to the zeroth or smaller node, it means to insert the node
    //at the start of the list
    if(n<=0) 
    {
        node->add(first);
        first=node;
    }
    else
    {
    
    //goes through the whole list, and finds the nth spot as long as it is not out of bounds
    //i will be the nth element
    for(i=first ; i->getNext() ; i=i->getNext())
    {
        if(counter>=n)
            break;
        counter++;
    }
    
    //the node to be added is given the pointer for the next node from the ith node
    node->add(i->getNext());
    
    //the ith node is then told to point at the new one
    i->add(node); 
    }
}

//inserts the given piece of data after the nth element
template<class dataType> 
void CList<dataType>::replaceAt(dataType data, int n)
{
    int counter=0;
    cNode<dataType> *i;    //a temp node used for going through the list
       
    for(i=first ; i->getNext() ; i=i->getNext())
    {
        if(counter>=n)
            break;
        counter++;
    }
    
    i->setValue(data);
}

//reomoves the nth element, only works if the nth element is in the bounds
//of the list
template<class dataType>
void CList<dataType>::removeElement(int n)
{
    cNode<dataType> *i,*previous,*temp;
    int counter=0;

    if(n==0 &&          //removing the first element
    first!=last)   //and it is not the last element 
    {
        temp=first;
        first = first->getNext();   //first is now what was second
        free (temp);                //the memory that used to be first is destroyed
    
    }
    else if(n==0 && first==last)
    {
        free(first);
        first=last=NULL;
    }
    else
    {
    //sets the pointer to the first element in the list
    i=first;
    while (i->getNext())    //as long as the next element exists keep going
    {
        if(counter==n)  //if the element we're looking at right now is the nth element
        {
            //if i was the last element
            if(i->retisLast())
            {
                //the previous element is now the last
                previous->setLast();
                free(i);
            }
            else
            {
                //the previous must set its next element to the next of the ith element
                previous->add(i->getNext());
            
                //free the memoey allocated for i
                //free(i);
            }
            break;
        }
        //the previous element is now the one we're looking at
        previous=i;
        //move i to the next element
        i=i->getNext();
        counter++;
    }
    }
}

//deletes the list, freeing all of the memory it allocated
template<class dataType> 
void CList<dataType>::freeList(void)
{
    cNode<dataType> *i,*temp;
    
    if(first){
    //goes through all the nodes in the list
    for(i=first ; i->getNext() ; )
    {
        temp=i;                 //place the pointer to i in temp
        i=i->getNext();         //move i to the next element
        free(temp);            //free the memory that i was pointing at before
    } 
    } 
    first=last=NULL; 
}
