#ifndef cclient_def
#define cclient_def

#include <cstdlib>
#include <cstdio>
#include <cmath>
#include <iostream>
#include <allegro.h>
#include <alleggl.h>
#include <gl\glu.h>	
#include <libnet.h>
#include "standards.h"

#include "CNetwork.h"
#include "CPacket.h"
#include "CServer.h"

#include "CPlayer.h"

using namespace std;


class CClient
{
private:
    NET_CONN *server_conn;      //the connection to the server
    CNetworkConnection connection;
    CPacket packet;
    
    bool connected;
    int player_num;
    
    CServer *local_server;
    CPacket incoming;
    
    CPlayer temp_player;
    CPlayer *you;
    CPlayer player[MAX_CLIENTS];
    
public:
    void init(void);
    void create(CNetworkConnection _connection, char *address);
    void close(void);
    int checkResponse(void);
    int recieve(char *data);
    void send(CPacket pack);
    
    CClient(void) {init();}
    ~CClient(void) {}

    void sendPacket(CPacket _incoming) {incoming=_incoming;}
    void setAsLocal(CServer *_local_server);
    void run(void);
    void runLobby(void);
    void createPlayer(char *name, int att_num);
    
    void runText(char *message);
    
    void drawAllPlayers(void);
};


#endif
