#include "CClient.h"

extern FONT* agl_font;

void CClient::init(void)
{
    server_conn = (NET_CONN*)NULL;
    local_server = (CServer*)NULL;
    
    connected=false;
    player_num=-1;
}

void CClient::create(CNetworkConnection _connection, char *address)
{
    connection=_connection;
    server_conn=net_openconn(connection.retNetworkDriver(), NULL);
    
    net_connect(server_conn,address);   
}

void CClient::setAsLocal(CServer *_local_server) 
{
    local_server=_local_server; 
    connected=false; 
}

void CClient::createPlayer(char *name, int att_num)
{
    player_num=-1;
    temp_player.create(name,att_num);  //create a temp player with the player's name
    you=&temp_player;
}

void CClient::close(void)
{
    if(server_conn)
    {
        net_closeconn(server_conn);
            server_conn = (NET_CONN*)NULL;
    }
}

//returns 0 on no response
//        1 when the connection is good
//       -1 when there is an error
int CClient::checkResponse(void)
{
    int ret=0;  
    
    ret = net_poll_connect(server_conn);
    
    if(ret==0)  //no response yet
    {
        return 0;
    }
    else if(ret<0)  //error
    {
        net_closeconn(server_conn);
        return -1;
    }
    else    //its all good
        return 1;
}

int CClient::recieve(char *data)
{
    if(connected==true)
        return net_receive_rdm(server_conn,data,1024);
    else
        return 0;
}

void CClient::send(CPacket pack)
{
    if(!local_server && connected==true)   //not the local client
        net_send_rdm(server_conn,pack.retData(),pack.retSize());
    else if(local_server)
    {
        local_server->sendPacket(pack);
    }
}



void CClient::run(void)
{
    static char message[1024];

    if(local_server)
    {
        if(connected==false)
        {
            packet.create("ReJo");
            char *name=you->retName();
            int length=strlen(name);
            packet.appendByte(length);
            for(int n=0 ; n<length ; n++)
                packet.appendByte(name[n]);
            packet.appendByte(you->retAttsNum());    
                       
            connected=true;     
            send(packet);

        }
        else
        {
            packet=incoming;
            incoming.init();
        }
    }
    else
    {
        if(connected==false && checkResponse()==1)  //connecting for the first time
        {
            packet.create("ReJo");
            
            char *name=you->retName();
            int length=strlen(name);
            packet.appendByte(length);
            for(int n=0 ; n<length ; n++)
                packet.appendByte(name[n]);
            packet.appendByte(you->retAttsNum());
           
            connected=true; 
            send(packet);

        }
        
        if(connected==true)
            packet.setSize(recieve(packet.retData()));
    }
    
    
    if(connected==true)
    {

        if(packet.checkPacket("You")==1)
        {

            player_num=packet.getNextByte();
            you=&player[player_num];
        }
        else if(packet.checkPacket("text")==1)
        {
            int length=packet.getNextByte();

            for(int n=0 ; n<1024 ; n++)
                message[n]=0;

            for(int n=0 ; n<length ; n++)
                message[n]=packet.getNextByte();
        }
        
    }
    glEnable(GL_TEXTURE_2D);
        allegro_gl_printf(agl_font, 0, -4, 0, makecol(0, 255, 255), "%s",message);
    glDisable(GL_TEXTURE_2D);
    
    

        glEnable(GL_TEXTURE_2D);
            allegro_gl_printf(agl_font, 0, -1.5, 0, makecol(0, 255, 255), "Connected: %d Player num: %d",connected,player_num);
        glDisable(GL_TEXTURE_2D);    
}

void CClient::runLobby(void)
{
    static char message[1024]="";
    
    run();
    
    runText(message);
    
    glEnable(GL_TEXTURE_2D);
        allegro_gl_printf(agl_font, 0, -3, 0, makecol(0, 255, 255), "%s",message);
    glDisable(GL_TEXTURE_2D);
    
}


void CClient::runText(char *message)
{
    static int cursor=0;

    if(keypressed())
    {
        char key=readkey()& 0xff;
        
        if(key==13)     //enter
        {
            packet.create("text");
            packet.appendByte(cursor);
            for(int n=0 ; n<cursor ; n++)
                packet.appendByte(message[n]);
                
            send(packet);
             
            cursor=0;
            message[0]=0;
        }
        else if(key==8) //backspace
        {
            if(cursor>0)
                cursor--;
            message[cursor]=0;  
        }
        else
        {
            message[cursor]=key;
            cursor++;
            message[cursor]=0;
        }
    }
}

void CClient::drawAllPlayers(void)
{
    for(int n=0 ; n<MAX_CLIENTS ; n++)
    {
        if(player[n].doesExist()==true)
        {
            player[n].draw();
        }
    }
}
