/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/

#ifndef ccamera_def
#define ccamera_def

#include <iostream>
#include <allegro.h>
#include <alleggl.h>
#include <gl\glu.h>	
#include "standards.h"

#include "CVector3.h"

using namespace std;


class CCamera
{
private:
    CVector3 pos,forward,up;
    CVector3 offset;
    int shakeCounter;
    int shakeMag;       //magnitude of the shake
    
public:    
    void init(void);
    
    void applyCamera(void);
    void moveCamera(void);
    bool setOrthoViewport(int w, int h);
    
    CCamera::CCamera(CVector3 _pos,CVector3 _forward, CVector3 _up) {pos=_pos; forward=_forward; up=_up; init();}
    CCamera::CCamera(void) {pos.zero(); forward.setVector(0,0,1); up.setVector(0,1,0); init(); pos.z=-200;}

    float retX(void) {return pos.x;}
    float retZ(void) {return pos.z;}
    float retY(void) {return pos.y;}
    void setPosition(CVector3 _pos){pos=_pos;}

    void rotateInXZ(float amount);
    void rotateInYZ(float amount);
    
    void moveForward(float amount);
    void strafeRight(float amount);
    
    void shake(int amount);
};

/***************************
        Orientation:

              +ve y
                |
                |
                |
                |
 +ve x <--------0
               /
              /
             /
          +ve z

***************************/


#endif
