/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/

#include "CCamera.h"

void CCamera::init(void)
{
    offset.zero();
    shakeCounter=0;
}

void CCamera::shake(int amount)
{
    shakeCounter+=amount;
    
    if(shakeCounter > amount)
        shakeMag = shakeCounter;
    else
        shakeMag = amount;
}    

bool CCamera::setOrthoViewport(int w, int h)
{
	//Initialize OpenGL projection matrix
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
    gluOrtho2D(0.0, (float)w, 0.0, (float)h);    
	
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
}  


void CCamera::applyCamera(void)
{
    glMatrixMode (GL_PROJECTION);
    glLoadIdentity ();
    //glFrustum (-1.0, 1.0, -1.0, 1.0, 1.0, 300.0);
    gluPerspective(45.0f,(GLfloat)800/(GLfloat)600, 0.1f, 1000.0f);
    glMatrixMode (GL_MODELVIEW);
    glLoadIdentity();

	
	CVector3 xAxis(1,0,0),yAxis(0,1,0),zAxis(0,0,1);
	


		
	glRotatef (up.retYAng()*RAD2DEG, 1, 0, 0);
	glRotatef (forward.retZAng()*RAD2DEG, 0, 1, 0);
	
    glTranslatef(-(pos+offset).x,-(pos+offset).y,(pos+offset).z);


	
    //glTranslatef (-10, -10, -10 /*-pos.z*/);
	
//	glRotatef (camera.zangle, 0, 0, 1);

	//glMatrixMode (GL_MODELVIEW);
}

void CCamera::moveCamera(void)
{
	if(shakeCounter>0)
	{
	    int r = rand()%(shakeMag*2) - shakeMag;
        offset.setVector( ((float)r)/15 , ((float)r)/15 ,0);
        shakeCounter-=4;   
	}    
	else
	   offset.zero();
}    

void CCamera::rotateInXZ(float amount)
{
    forward=forward.rotateAboutY(amount);
}

/*void CCamera::rotateInYZ(float amount)
{
    up=up.rotateAboutZ(amount);
}*/

void CCamera::rotateInYZ(float amount)
{
    up=up.rotateAboutX(amount);
}

void CCamera::moveForward(float amount)
{
    pos = pos+(forward*amount);
}

void CCamera::strafeRight(float amount)
{
    pos -= (forward^up)*amount;
}
