/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/

#ifndef BUTTON_H
#define BUTTON_H

#include <cstdlib>
#include <cstdio>
#include <cmath>
#include <allegro.h>
#include <alleggl.h>
#include "Standards.h"
#include "Widget.h" // inheriting class's header file

typedef struct
{
    bool drawOutline; 
    float outlineColour[3];
    float outlineColourHighlighted[3];
    float outlineColourDown[3];
    int captionColour[3];
    int captionColourHighlighted[3]; 
    int captionColourDown[3]; 
}TButtonAtts;    

class Button : public Widget
{
protected:
    FONT *labelFont;  
    char caption[50];
    TButtonAtts atts;
    
    bool buttonDown;
    
    //will store that the button has been pressed. Accessed via checkStatus()
    bool buttonPressed; 
    
public:
    Button(int _id, CVector2 pos, float w, float h, FONT *f, char *c, TButtonAtts &ba);
    Button(const Button &other);
    ~Button();
    
    void copyButtonAtts(TButtonAtts other);
    
    void draw(void);
    void update(TMouse &mouse);
    
    virtual void onButtonPressed(void);
    TWidgetStatus checkStatus(void);
};

#endif // BUTTON_H

