/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/

#include "Button.h" // class's header file

//extern FONT* allFonts[20];

Button::Button(int _id, CVector2 pos, float w, float h, FONT *f, char *c, TButtonAtts &ba) : Widget(_id,pos,w,h)
{
    labelFont = f;
    strcpy(caption,c);
    copyButtonAtts(ba);
    buttonDown=false;
    buttonPressed=false;
}

Button::Button(const Button &other) : Widget(other)
{
    labelFont = other.labelFont; 
    strcpy(caption,other.caption); 
    copyButtonAtts(other.atts);  
    buttonDown=false;
    buttonPressed=false;
}    

Button::~Button()
{
}

void Button::copyButtonAtts(TButtonAtts other)
{
    atts.drawOutline = other.drawOutline;
    for(int n=0 ; n<3 ; n++)
    {
        atts.outlineColour[n] = other.outlineColour[n];
        atts.outlineColourHighlighted[n] = other.outlineColourHighlighted[n];
        atts.outlineColourDown[n] = other.outlineColourDown[n];
        atts.captionColour[n] = other.captionColour[n];
        atts.captionColourHighlighted[n] = other.captionColourHighlighted[n]; 
        atts.captionColourDown[n] = other.captionColourDown[n];
    }    
}    

void Button::draw(void)
{
    //Widget::draw();   
    if(atts.drawOutline==true)
    {
        if(buttonDown)
            drawOutline(atts.outlineColourDown);
        else if(bMouseOver)
            drawOutline(atts.outlineColourHighlighted);
        else    
            drawOutline(atts.outlineColour);
    }    
        
    if(caption)
    {    
        int captionColour;
        if(buttonDown)
            captionColour = makecol(atts.captionColourDown[0],atts.captionColourDown[1],atts.captionColourDown[2]);
        else if(bMouseOver)
            captionColour = makecol(atts.captionColourHighlighted[0],atts.captionColourHighlighted[1],atts.captionColourHighlighted[2]);
        else
            captionColour = makecol(atts.captionColour[0],atts.captionColour[1],atts.captionColour[2]);

        writeText_3D(pos.retX()+tl_offset.retX()+.5, pos.retY()+tl_offset.retY(), 0, captionColour, labelFont, caption);   
    }    
}    

void Button::update(TMouse &mouse)
{
    Widget::update(mouse);
    
    if(bMouseOver && (mouse.b & 1) )   //the button is being clicked
    {
        buttonDown=true;    
    }  

    if(buttonDown)      //if the button is pressed
    {
        if(!bMouseOver)     //no longer mouseover, so button is not down anymore
            buttonDown=false;     
        else if(!(mouse.b & 1))   //still mouseover, but mouse is no longer pressed
        {
            buttonDown=false;
            //button has been pressed
            onButtonPressed();
        }    
    }       
}    

void Button::onButtonPressed(void)
{
    buttonPressed=true;  
    //if(callback)    
}   

//will return true if the button has been pressed,
//returns false otherwise. Resets the button back to not pressed
TWidgetStatus Button::checkStatus(void)
{
    TWidgetStatus s;
    s.id=id;
    s.value=NA;
    if(buttonPressed==true)
    {
        s.notify=true;
        buttonPressed=false;
    }    
    else
        s.notify=false;
        
    return s;    
}     
