/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/

#ifndef BRect_def
#define BRect_def


#include <cstdlib>
#include <cstdio>
#include <cmath>
#include <allegro.h>
#include <alleggl.h>
#include "Standards.h"

#include "CVector2.h"
#include "Object.h"

using namespace std;

//iType (types of BRects)
#define RECT    0
#define CIRC    1
#define LINE    2

//projType  (types of projectiles)
#define NOT_PROJ    -1
#define ENERGY      0
#define MISSILE     1
#define MINE        2
#define INST        4
#define ASTEROID    5

//genType   (used for projectiles and collision info)
#define TYPE_UNKNOWN    0
#define TYPE_PROJ       1
#define TYPE_SHIP       2
#define TYPE_ASTEROID   3
#define TYPE_WALL       4



typedef struct
{
    float shieldDamage,armorDamage,projDamage;
    int owner_id;                 //player's id (ie id of ship, or id of projectile's owner)
    int owner_team;
    int ptrToOwner;
    int genType;
}CollisionInfo;

//bounding rectangle object
//contains information about the bounding box's size and its position
class BRect : virtual public Object
{
protected:
    CVector2 tl_offset,     //offset from pos to the top left of the bounding box
             br_offset,     //offset from pos to the bottom right of the bounding box
             pos;
             
    CVector2 p1,p2;         
    CVector2 slope,norm;
             
    CVector2 pointOfCollision;
             
    //for collision 
    CVector2 vel;
    float fMass;
    
    float radius;
    
    float angle;
    
    //bool bIsRect;
    unsigned short iType;   
    short projType;
    short genType;
    
    int iPict;
    int id,team_id;
        
public:
    void setAngle(float _angle) {angle = _angle;}

    virtual bool checkColWithBRect(BRect *ob2);
    
    virtual bool doCircleCircleCol(BRect *ob2);
    
    virtual void draw(bool wireframe=false);
    virtual void update(void){ /*if(exist==true) pos += vel;*/ }
    
    virtual CollisionInfo reactToCollision(void);
    virtual void reactToCollisionInfo(CollisionInfo &info);
    
    void die(void);
    
    void setid(int _id, int _team_id) {id = _id; team_id = _team_id; }
    int retid(void) {return id;}
    
    int retType(void) {return iType;}
    int retGenType(void) {return genType;}
    short int retProjType(void) {return projType;}
    
    virtual bool targetable(void) {return false;}
    
    float retRadius(void) {return radius;}
    CVector2 retPos(void) {return pos;}
    CVector2 retVel(void) {return vel;}
    float retMass(void) {return fMass;}
    CVector2 retP1(void) {return p1;}
    CVector2 retP2(void) {return p2;}
    CVector2 retTl_offset(void) {return tl_offset;}
    CVector2 retBr_offset(void) {return br_offset;}
    
    //if it is a line, then this will return its length
    CVector2 retSlope(void) {return slope; }
    
    void setVel(CVector2 _vel) { vel=_vel; }
    void setVel(float mag) {vel.setMag(mag);}
    void setMass(float _mass) {fMass = _mass;}
    void setPos(CVector2 _pos) {pos = _pos;}
    
    void init(void);
    void setBRect(CVector2 _tl_offset, CVector2 _br_offset, CVector2 _pos, CVector2 _vel);
    void setBCirc(float _radius, CVector2 _pos, CVector2 _vel);
    void setLine(CVector2 _p1, CVector2 _p2, CVector2 _vel);
    
    void setPict(float w, float h, char *filename, bool tga=false); 
    void drawPict(CVector2 p, float alpha=1);
    
    void clearPointOfCollision(void) { pointOfCollision.zero();}
    
    BRect(void){ init(); }
    BRect(const BRect &other);
    ~BRect(void) {}
    

};


#endif

