/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/

#include "BRect.h"

void BRect::draw(bool wireframe)
{
    //assumes that allegro_gl_begin has already been called
    if(exist==true)
    {
        glPushMatrix();

        glBegin(GL_LINE_STRIP);
            float blue[4]={0,0,1,1};
            glMaterialfv( GL_FRONT, GL_DIFFUSE, blue );
            glMaterialfv( GL_FRONT, GL_AMBIENT, blue );
            glMaterialfv( GL_FRONT, GL_SPECULAR, blue );
            glMaterialfv( GL_FRONT, GL_EMISSION, blue );
            glNormal3f(0,0,1);

            if(iType==RECT)
            {
                glVertex3f(br_offset.retX(),br_offset.retY(),0);  //bottom right
                glVertex3f(tl_offset.retX(),br_offset.retY(),0);  //bottom left
                glVertex3f(tl_offset.retX(),tl_offset.retY(),0);  //top left
                glVertex3f(br_offset.retX(),tl_offset.retY(),0);  //top right
                glVertex3f(br_offset.retX(),br_offset.retY(),0);  //bottom right
            }
            else if(iType==CIRC)
            {
                glVertex3f(-radius,0,0);
                    glVertex3f(-radius*cos(M_PI/4),radius*sin(M_PI/4),0);
                glVertex3f(0,radius,0);
                    glVertex3f(radius*cos(M_PI/4),radius*sin(M_PI/4),0);
                glVertex3f(radius,0,0);
                    glVertex3f(radius*cos(M_PI/4),-radius*sin(M_PI/4),0);
                glVertex3f(0,-radius,0);
                    glVertex3f(-radius*cos(M_PI/4),-radius*sin(M_PI/4),0);
                glVertex3f(-radius,0,0);
                
            }
            else if(iType==LINE)
            {
                glVertex3f(p1.retX(),p1.retY(),0);
                glVertex3f(p2.retX(),p2.retY(),0);
            }
        glEnd();
        
        glPopMatrix();

    }
}

void BRect::setBCirc(float _radius, CVector2 _pos, CVector2 _vel)
{   
    radius = _radius;
    pos=_pos;
    vel=_vel;
    //bIsRect=false;
    iType=CIRC;

    exist=true;
}

void BRect::setBRect(CVector2 _tl_offset, CVector2 _br_offset, CVector2 _pos, CVector2 _vel)
{
    tl_offset=_tl_offset;
    br_offset=_br_offset;
    pos=_pos;
    vel=_vel;
    
    p1 = pos+tl_offset;
    p2 = pos+br_offset;
    
    //bIsRect=true;
    iType=RECT;
    
    exist=true;
}

void BRect::setLine(CVector2 _p1, CVector2 _p2, CVector2 _vel)
{
    p1 = _p1;
    p2 = _p2;
    vel = _vel;
    
    pos = (p2 + p1)/2;
    
    iType=LINE;
    exist=true;
    
    
    slope = p2 - p1;
    norm = -slope.findNormal();
    slope.isPosition(false);
    norm.isPosition(false);
    norm.setMag(1);
}

bool BRect::doCircleCircleCol(BRect *ob2)
{
    bool ret=false;
    
                //the distance between the two centres
            float fDist = get_dist(pos.retX(),pos.retY(),ob2->retPos().retX(),ob2->retPos().retY());   
            
            
            //the simulated velocity of the first object to make the second one stationary
            //relative to the first one
            CVector2 simVel = vel - ob2->retVel();
            simVel.isPosition(false);
            
            //checks to see if the two circles could possibly touch this frame
            //based on how far apart they are, and their speeds
            if(fDist > simVel.retMag() + radius + ob2->retRadius())
            {
                //a collision could not occur, they are too far apart
                return false;
            }
                
            //get the line connecting the two centres (moving from the first to the second
            CVector2 line(ob2->retPos().retX() - pos.retX(),
                          ob2->retPos().retY() - pos.retY(),false);
                              
            float fDotProd1 = simVel | line;
                
            if(fDotProd1 <=0)  //they are not moving towards each other
            {
                //there can be no collision
                return false;
            }          
            
            //the vector line projected onto the velocity vector
            //it represents the distance along the velocity vector
            //where the point is closest to the centre of the other circle
            float D = (simVel | line) * line.retMag();    
            
            //the distance from the point defined by D to the centre of the second circle
            float F = sqrt(line.retMag()*line.retMag() - D*D);
            
            //the distance along the velocity vector from the point represented by
            //F to the centre of the first circle at the point of collision
            float T = sqrt((radius+ob2->retRadius())*(radius+ob2->retRadius()) - F*F);
            
            //the distance the first circle needs to move before it hits the other circle
            float distance_to_move = D - T;
            
            //distance_to_move is the distance that ob1 would have to move assuming that
            //ob2 is stationary
            
            if(distance_to_move <= simVel.retMag()) //they do collide then
            {
                /*float val;
                if(ob2->vel.retMag()!=0)
                    val = distance_to_move / ob2->vel.retMag();
                else
                    val = distance_to_move;*/
                
                //move both of the objects to the exact point of collision
                //CVector2 offset;
                
   //             pos+=vel*val;
   //             ob2->pos+=ob2->vel*val;
           //     vel*=val;
           //     ob2->vel*=val;
                
   //             vel.zero();
   //             ob2->vel.zero();
                
                ret=true;
            }

    return ret;

}

bool BRect::checkColWithBRect(BRect *ob2)
{
    bool ret=false;

    
    
    if(exist==true && ob2->retExist()==true)
    {
        if(iType==CIRC && ob2->retType()==CIRC)   //circle - circle collision
        {
        
            //vel.isPosition(false);
            //ob2->vel.isPosition(false);
            
            if(doCircleCircleCol(ob2)==true)
            {
                
                
                CVector2 ccLine;    //the line connecting the centres of the two circles
                float v1InDirofCCLine,v2InDirofCCLine;
                         
                ccLine = ob2->retPos() - retPos();
                ccLine.isPosition(false);
                ccLine.setMag(1);
                
                ob2->pointOfCollision.setVector(-ccLine.retX(),-ccLine.retY(),true);
                pointOfCollision.setVector(ccLine.retX()*1.3,ccLine.retY()*1.3,true);
                
                
                v1InDirofCCLine = (retVel() | ccLine) * vel.retMag();
                v2InDirofCCLine = (ob2->retVel() | ccLine) * ob2->retVel().retMag();
        
                
         //      vel -= ccLine*v1InDirofCCLine;
         //       ob2->vel-= ccLine*v2InDirofCCLine;
                
                
                //component of the velocity in the direction of the normal for both objects
                float a1 = (retVel() | ccLine) * vel.retMag() ;     
                float a2 = (ob2->retVel() | ccLine) * ob2->retVel().retMag();
                
                float p = (2*(a1-a2)) / (fMass + ob2->retMass()) ;
                
                /*CVector2 v1F = vel - (n*p*ob2->retMass());
                CVector2 v2F = ob2->vel + (n*p*fMass);
                
                vel = v1F;
                ob2->setVel(v2F);*/
                
                vel -= (ccLine*p*ob2->retMass());
                ob2->vel += (ccLine*p*fMass);
                
                ret=true;
               /*        
                vel.zero();
                ob2->vel.zero();       
                */
 /*               
                //get the line connecting the two centres (moving from the first to the second
                //the normal to the tangent of the collision
                CVector2 n(ob2->retPos().retX() - pos.retX(),
                      ob2->retPos().retY() - pos.retY(),false);    
                
                //component of the velocity in the direction of the normal for both objects
                float a1 = (vel | n)* vel.retMag() ;     
                float a2 = (ob2->vel | n)* ob2->vel.retMag();
                
                float p = (2*(a1-a2)) / (fMass + ob2->retMass()) ;
                
                CVector2 v1F = vel - (n*p*ob2->retMass());
                CVector2 v2F = ob2->vel + (n*p*fMass);
                
                vel = v1F;
                ob2->setVel(v2F);
*/

                    
              
                //pos+=vel;
                //ob2->pos+=ob2->vel;
                        
              //  doCircleCircleCol(ob2);
            }  
            
        }
        else if((iType==CIRC && ob2->retType()==LINE) || (iType==LINE && ob2->retType()==CIRC))    //circle-line collision
        {
            BRect *circ,*line;
            if(iType==LINE && ob2->retType()==CIRC)
            {
                circ = ob2;
                line = this;
            }
            else if(iType==CIRC && ob2->retType()==LINE)
            {
                circ = this;
                line = ob2;
            }
        
            float velInDirOfNorm;
            velInDirOfNorm = (circ->vel | line->norm) * circ->vel.retMag();
            
            CVector2 l; //the line connecting the centre of the circle and an arbitrary point on the line
            l = line->p1 - circ->pos;
            l.isPosition(false);
            
            //project l onto the line's normal to get the shortest distance from the point to the line
            float d  =  (l | line->norm);

            if(d<0)
                d*=-1;
            d*=l.retMag();  

            if(velInDirOfNorm + circ->radius >= d && circ->vel.retMag()>0) //there is a collision
            {
                float distToCentre; //distance from the circle to the centre of the line
                distToCentre = get_dist(circ->pos.retX(),circ->pos.retY(),line->pos.retX(),line->pos.retY());
           
                if(distToCentre<=line->slope.retMag()/2)
                {
                    CVector2 recoil;
                    recoil = line->norm * (circ->vel | line->norm) * circ->vel.retMag();
                    recoil.isPosition(false);


                    circ->vel -= recoil*1.5;

                    circ->pointOfCollision.setVector(circ->pos.retX()+line->norm.retX()*circ->radius,
                                                     circ->pos.retY()+line->norm.retY()*circ->radius,
                                                     false);
                    
                    /*circ->pointOfCollision.setVector(circ->pos.retX()-abval(line->norm.retX())*circ->radius,
                                 circ->pos.retY()-abval(line->norm.retY())*circ->radius,
                                 false);*/
                    

                    ret=true;
                }
            }
        }
        else if( (iType==CIRC && ob2->retType()==RECT) || (iType==RECT && ob2->retType()==CIRC) )
        {
            BRect *circ,*rect;
            if(iType==CIRC)
            {
                circ = this;
                rect = ob2;
            }
            else
            {
                circ=ob2;
                rect=this;
            }
            
            if(circ->pos.retX() > rect->pos.retX()+rect->tl_offset.retX() && circ->pos.retX() < rect->pos.retX()+rect->br_offset.retX() &&
               circ->pos.retY() > rect->pos.retY()+rect->tl_offset.retY() && circ->pos.retY() < rect->pos.retY()+rect->br_offset.retY() )
            {
                ret=true;
                  
            }
        }
    }
    return ret;
}

void BRect::setPict(float w, float h, char *filename, bool tga)
{
    CVector2 tl(-w/2,-h/2,true),
             br(w/2,h/2,true);
             
    setBRect(tl,br,makeVector2(0,0,true),makeVector2(0,0,false));
    
    //iPict = loadTexture(filename,tga);  
    iPict = loadTexture(filename);     
}


void BRect::drawPict(CVector2 p, float alpha)
{
    setColour(1,1,1,alpha);
    
    //bool textures_on;
    //glGetBooleanv(GL_TEXTURE_2D,&textures_on);
    if(iPict!=-1)
    {
        glEnable(GL_TEXTURE_2D);
        glBindTexture(GL_TEXTURE_2D,iPict);
    }
    glPushMatrix();
    glEnable(GL_BLEND);
    glDepthMask(false);
    //glDisable(GL_LIGHTING);
    
    glBlendFunc(GL_SRC_ALPHA,GL_ONE);	
    
    glBegin(GL_QUADS);
        
        glTexCoord2f(1,1);
        glVertex2f(p.retX() + br_offset.retX(),p.retY() + tl_offset.retY());  //top right

        glTexCoord2f(0,1);
        glVertex2f(p.retX() + tl_offset.retX(),p.retY() + tl_offset.retY());  //top left

        glTexCoord2f(0,0);
        glVertex2f(p.retX() + tl_offset.retX(),p.retY() + br_offset.retY());  //bottom left

        glTexCoord2f(1,0);
        glVertex2f(p.retX() + br_offset.retX(),p.retY() + br_offset.retY());  //bottom right   
   glEnd();
   
   
   glPopMatrix();
   //glEnable(GL_LIGHTING);
   glDisable(GL_BLEND);
   glDepthMask(true);
   glDisable(GL_TEXTURE_2D);
   //glDisable(GL_TEXTURE_2D);
   /*if(textures_on==false)   glDisable(GL_TEXTURE_2D);
   else                     glEnable(GL_TEXTURE_2D);*/
}

CollisionInfo BRect::reactToCollision(void)
{
    CollisionInfo colInfo;
    
    colInfo.armorDamage=0;
    colInfo.shieldDamage=0;
    colInfo.owner_id=-1;
    colInfo.owner_team=-1;
    
    colInfo.genType=genType;
    
    if(iType==LINE)
    {
        colInfo.shieldDamage=2;
        colInfo.genType=TYPE_WALL;
    }    
    
    return colInfo;
}

void BRect::reactToCollisionInfo(CollisionInfo &info)
{

}

void BRect::die(void)
{
    exist=false;
}

void BRect::init(void)
{
    Object::init();

    tl_offset.zero();
    br_offset.zero();
    pos.zero();
    vel.zero();
    p1.zero();
    p2.zero();
    slope.zero();
    norm.zero();
    
    angle=0;
    fMass=1;
    iType=0;
    iPict=-1;
    projType=NOT_PROJ;
    genType = TYPE_UNKNOWN;
    id=0;
}

BRect::BRect(const BRect &other)
{
    tl_offset = other.tl_offset;
    br_offset = other.br_offset;
    pos = other.pos;
    vel = other.vel;
    p1 = other.p1;
    p2 = other.p2;
    slope = other.slope;
    norm = other.norm;
    
    angle = other.angle;
    fMass = other.fMass;
    iType = other.iType;
    iPict = other.iPict;
    projType = other.projType;
    genType = other.genType;    
    id=other.id;
}    
