/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/

#include "AsteroidsGameMode2p.h" // class's header file

AsteroidsGameMode2p::AsteroidsGameMode2p(NewMenu *m) :  AsteroidsGameMode(m)
{
}
    
AsteroidsGameMode2p::~AsteroidsGameMode2p()
{
}    
    
void AsteroidsGameMode2p::setUpGame(Game *game)
{
    AsteroidsGameMode::setUpGame(game);
    
    TPlayerAtts p2a;
    strcpy(p2a.sName,"Player2");
    p2a.iColour=0;
    p2a.starting_lives=3;
    p2a.startX=getPlayerStartPos(1).retX();
    p2a.startY=getPlayerStartPos(1).retY();
    
    game->setPlayerAtts(1,p2a,0);   //set up player2 to have the same team id as player 1 (so they can't hurt each other)

    if((*(menu->getResults()))[5].value==CB_SELECTED)  //check to see if co-op is on
        GameSettingsSingleton::instance()->setCoOp(true);       
    else
        GameSettingsSingleton::instance()->setCoOp(false);     

}    

CVector2 AsteroidsGameMode2p::getPlayerStartPos(int n)    //returns the start position for player's ship
{
    if(n==1)    //second player
        return makeVector2(-31,-20,true); 
    else
        return AsteroidsGameMode::getPlayerStartPos(n);
}    

int AsteroidsGameMode2p::getPlayerShipNum(int n)
{
    if(n==0)    
        return AsteroidsGameMode::getPlayerShipNum(n);
    else
        return 6;
}    
    
int AsteroidsGameMode2p::getWeaponsSet(int n)
{
    return AsteroidsGameMode::getWeaponsSet(n);
}    
    
TMenuPage AsteroidsGameMode2p::createMenuPage(FONT **allFonts,TButtonAtts bAtts, int prevPage,Model *allModels, ShipArray *sa, Game *g) //creates a menu page to set up this game mode
{
    TMenuPage page;
    
    page.nWidgets=5;
    page.widgets = new Widget* [5];
    page.widgetTransitions = new int[5];
    
    page.widgets[0] = new Button(0,makeVector2(0,1.5,true),4.5,2.45,allFonts[2],"Play",bAtts);
    page.widgetTransitions[0] = QUIT_MENU;

    page.widgets[1] = new Button(1,makeVector2(0,-6,true),5,2.45,allFonts[2],"Back",bAtts);
    page.widgetTransitions[1] = prevPage;
    
    page.widgets[2] = new CheckBox(2,makeVector2(-19,-10,true),1,1,allFonts[4],"Walls On",bAtts,false);
    page.widgetTransitions[2] = NO_TRANSITION;    
    
    page.widgets[3] = new CheckBox(3,makeVector2(-5,-10,true),1,1,allFonts[4],"Maniac Mode",bAtts,false);
    page.widgetTransitions[3] = NO_TRANSITION;    
    
    page.widgets[4] = new CheckBox(4,makeVector2(10,-10,true),1,1,allFonts[4],"Projectile Wrap",bAtts,false);
    page.widgetTransitions[4] = NO_TRANSITION;    

//    page.widgets[5] = new CheckBox(5,makeVector2(5,-10,true),1,1,allFonts[4],"CoOp",bAtts,false);
//    page.widgetTransitions[5] = NO_TRANSITION;  

    page.gameModeResult=GM_ASTEROIDS2;
    
    return page;    
}    

void AsteroidsGameMode2p::runInGame(Game *g)
{
    if(menu)
    {
        /****************RUNS MANIAC MODE*********************/
        if((*menu->getResults())[3].value==CB_SELECTED)   //if the Maniac Mode is selected
        {
            for(int n=0 ; n<g->retNumPlayers() ; n++)
            {
                g->retShip(n)->thrust();
                g->retShip(n)->thrust();
            }    
        }
    } 
    
    if(g->retPlayer(0)->retLives()==0 && g->retPlayer(1)->retLives()==0){
        g->endGame("Game Over");
    }   
}    
