/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/

#ifndef ASTEROIDSGAMEMODE_H
#define ASTEROIDSGAMEMODE_H

#include "gamemode.h"

#include "CVector2.h"
#include "Arena.h"
#include "Game.h"

#include "NewMenu.h"
#include "Button.h"
#include "CheckBox.h"
#include "Player.h"

#include <vector>
using namespace std;

class AsteroidsGameMode : public GameMode
{
private:   
public:
    AsteroidsGameMode(NewMenu *m);
    ~AsteroidsGameMode();
    
    void setUpGame(Game *game);
    int getPlayerShipNum(int n);
    int getWeaponsSet(int n);
    CVector2 getPlayerStartPos(int n);
    TMenuPage createMenuPage(FONT **allFonts,TButtonAtts bAtts, int prevPage, Model *allModels, ShipArray *sa, Game *game); //creates a menu page to set up this game mode
    void runInGame(Game *g);
    void nextLevel(Game *g);
    void writeStats(Game *g);
};

#endif

