/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/

#include "AsteroidsGameMode.h" // class's header file

extern FONT* allFonts[20];

AsteroidsGameMode::AsteroidsGameMode(NewMenu *m) : GameMode(m)
{
    //menu = m;
}

AsteroidsGameMode::~AsteroidsGameMode()
{
}

void AsteroidsGameMode::setUpGame(Game *game)
{
    CVector2 arena_top(-49,-38), arena_bot(49,38);
    CVector2 pos(0,0,true),vel(0,0,false);
    
    Arena arena;
    arena.setBRect(arena_top,arena_bot,pos,vel);
    
    /*char buf[40];
    sprintf(buf,"Game Type: %d",menu->getGameModeResult());
    outtext(LOGFILE,buf);*/
    //(*(menu->getResults()))[1].value;
    
    if((*(menu->getResults()))[2].value==CB_SELECTED)  //check to see if walls are on
    {
        CVector2 p1(-46,-26) , p2(-45,35) , p3(46,34) , p4(44,-26);
        arena.addWall(p1,p2);
        arena.addWall(p2,p3);
        arena.addWall(p3,p4);
        arena.addWall(p4,p1);   
    }   
    game->setArena(arena);
    
    game->startAsteroidsGame();
    
    ScoreKeeper::instance()->reset(SCORE_BASED);
    ScoreKeeper::instance()->setScoreInc(100);
    ScoreKeeper::instance()->setMultiplierInc(0.04);
    ScoreKeeper::instance()->setMultiplierDecay(0.00095);
    
    if( (*(menu->getResults()))[4].value == CB_SELECTED)
        (GameSettingsSingleton::instance())->setProjWrap(true);
    else
        (GameSettingsSingleton::instance())->setProjWrap(false);
    
    TPlayerAtts p1a;
    strcpy(p1a.sName,"Player1");
    p1a.iColour=0;
    p1a.starting_lives=3;
    p1a.startX=getPlayerStartPos(0).retX();
    p1a.startY=getPlayerStartPos(0).retY();
    //give them differnet id's so they can hurt each other
    game->setPlayerAtts(0,p1a,0);
}    

int AsteroidsGameMode::getPlayerShipNum(int n)
{
    return 7;
}    

int AsteroidsGameMode::getWeaponsSet(int n)
{
    return 2;   
}    

CVector2 AsteroidsGameMode::getPlayerStartPos(int n)    //returns the start position for player's ship
{
    if(n==0)    //first player
        return makeVector2(31,-20,true); 
}  

TMenuPage AsteroidsGameMode::createMenuPage(FONT **allFonts,TButtonAtts bAtts, int prevPage, Model *allModels, ShipArray *sa, Game *game)
{
    TMenuPage page;
    
    page.nWidgets=5;
    page.widgets = new Widget* [5];
    page.widgetTransitions = new int[5];
    
    page.widgets[0] = new Button(0,makeVector2(0,1.5,true),4.5,2.45,allFonts[2],"Play",bAtts);
    page.widgetTransitions[0] = QUIT_MENU;

    page.widgets[1] = new Button(1,makeVector2(0,-6,true),5,2.45,allFonts[2],"Back",bAtts);
    page.widgetTransitions[1] = prevPage;
    
    page.widgets[2] = new CheckBox(2,makeVector2(-19,-10,true),1,1,allFonts[4],"Walls On",bAtts,false);
    page.widgetTransitions[2] = NO_TRANSITION;    
    
    page.widgets[3] = new CheckBox(3,makeVector2(-4,-10,true),1,1,allFonts[4],"Maniac Mode",bAtts,false);
    page.widgetTransitions[3] = NO_TRANSITION;    
    
    page.widgets[4] = new CheckBox(4,makeVector2(5,-10,true),1,1,allFonts[4],"Projectile Wrap",bAtts,false);
    page.widgetTransitions[4] = NO_TRANSITION;    

    page.gameModeResult=GM_ASTEROIDS;
    
    return page;    
}   

void AsteroidsGameMode::runInGame(Game *g)
{
    if(menu)
    {
        /****************RUNS MANIAC MODE*********************/
        if((*menu->getResults())[3].value==CB_SELECTED)   //if the Maniac Mode is selected
        {
            for(int n=0 ; n<g->retNumPlayers() ; n++)
            {
                g->retShip(n)->thrust();
                g->retShip(n)->thrust();
            }    
        }
    } 
    
    if(g->retPlayer(0)->retLives()==0){
        g->endGame("Game Over");
    }       
}  

void AsteroidsGameMode::writeStats(Game *g)
{
    char buf[100];
    
    for(int n=0 ; n<g->retNumPlayers() ; n++)
    {
        int xx;
        if(n==0){
            xx=500;
            writeText_2D(xx,130,0,makecol(200,250,200),allFonts[4],"Player1");
        }    
        else{
            xx=70;
            writeText_2D(xx,130,0,makecol(200,250,200),allFonts[4],"Player2");
        }
            
        sprintf(buf,"Projectiles Fired: %d",g->retPlayer(n)->retShip()->stats.shotsFired);
        writeText_2D(xx,160,0,makecol(200,200,200),allFonts[4],buf);
        sprintf(buf,"Projectiles Hit: %d",g->retPlayer(n)->retShip()->stats.shotsHit);
        writeText_2D(xx,180,0,makecol(200,200,200),allFonts[4],buf);
        
        if(g->retPlayer(n)->retShip()->stats.shotsFired==0)
            sprintf(buf,"Accuracy: 100 percent");
        else
            sprintf(buf,"Accuracy: %d percent",(int)(((float)g->retPlayer(n)->retShip()->stats.shotsHit/(float)g->retPlayer(n)->retShip()->stats.shotsFired)*100));
        writeText_2D(xx,200,0,makecol(200,200,200),allFonts[4],buf);

        if((*(menu->getResults()))[2].value==CB_SELECTED)  //check to see if walls are on
        {
            sprintf(buf,"Shield Lost To Walls: %d",g->retPlayer(n)->retShip()->stats.shieldLostToWalls);
            writeText_2D(xx,250,0,makecol(200,200,200),allFonts[4],buf);
        }
            
        sprintf(buf,"Asteroids Killed: %d",g->retPlayer(n)->retShip()->stats.asteroidsKilled);
        writeText_2D(xx,280,0,makecol(200,200,200),allFonts[4],buf);      
        sprintf(buf,"Hit By Asteroids: %d",g->retPlayer(n)->retShip()->stats.hitByAsteroid);
        writeText_2D(xx,300,0,makecol(200,200,200),allFonts[4],buf);     
        sprintf(buf,"Killed By Asteroids: %d",g->retPlayer(n)->retShip()->stats.killedByAsteroid);
        writeText_2D(xx,320,0,makecol(200,200,200),allFonts[4],buf); 
        
        sprintf(buf,"Longest No-Hit Streak: %d seconds",(int)((float)g->retPlayer(n)->retShip()->stats.longestStreak/32));
        writeText_2D(xx,350,0,makecol(200,200,200),allFonts[4],buf);    
    }        
    //writeText_3D(10,16,40,makecol(255,255,255),allFonts[1],"hello");  
}    

void AsteroidsGameMode::nextLevel(Game *g)
{
    ScoreKeeper::instance()->addToMultiplier(.5,0);    //increase the multiplier by .5   
    ScoreKeeper::instance()->addToMultiplier(.5,1);    //increase the multiplier by .5
}     
