/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/

#ifndef arena_def
#define arena_def

#include <cstdlib>
#include <cstdio>
#include <cmath>
#include <allegro.h>
#include <alleggl.h>
#include "Standards.h"

#include "CVector2.h"
#include "Object.h"
#include "BRect.h"
#include "Model.h"

#include "Animation.h"

#define MAX_WALLS   10
#define MAX_NODES   100

using namespace std;

typedef struct
{
    CVector2 pos,n,offset;
    int dir;
    float offset_mag;
}TNode;

typedef struct
{
    int nNodes;
    TNode *nodes;

}TWallNodes;
    



class Arena : public BRect
{
protected:
    BRect wall[MAX_WALLS];
    int iNumWalls;
    TWallNodes wallNodes[MAX_WALLS];
    int nodeSpacing;
    float vibrationMag, vibrationSpeed;
    //int numNodes;

public:
    void init(void);
    void draw(bool wireframe=false);
    void update(void);
    void addWall(CVector2 _p1, CVector2 _p2);
    
    int retNumWalls(void) {return iNumWalls;}
    BRect* retWall(int n) {/*if(n>=0 && n<iNumWalls)*/return &wall[n];}
    
    Arena(void) {init();}
    ~Arena(void){}


};


#endif
