/***********************************
Copyright (c) 2006, Richard Cassan
All rights reserved.
***********************************/

#include "Arena.h"

void Arena::init(void)
{
    BRect::init();
    for(int n=0 ; n<MAX_WALLS ; n++)
        wall[n].init();
    iNumWalls=0;
    
    nodeSpacing = 6;
    vibrationMag=.25;
    vibrationSpeed=.2;
    //numNodes=0;
}

void Arena::addWall(CVector2 _p1, CVector2 _p2)
{
    if(iNumWalls<MAX_WALLS)
    {
        CVector2 v(0,0,false);
        wall[iNumWalls].setLine(_p1,_p2,v);
        
        CVector2 slope,pos;
        float lineLength;
        int nodes;
        
        slope = wall[iNumWalls].retSlope();
        //slope = slope.normalize(slope);
        slope.isPosition(false);
        lineLength = slope.retMag();
        wallNodes[iNumWalls].nNodes = (int)( lineLength / (float)nodeSpacing ) +1;
        wallNodes[iNumWalls].nodes = new TNode[wallNodes[iNumWalls].nNodes];
        
        pos = wall[iNumWalls].retP1();
        for(int n=0 ; n<wallNodes[iNumWalls].nNodes ; n++)
        {
            //node[numNodes+n].pos = pos;
            wallNodes[iNumWalls].nodes[n].pos = pos;
            wallNodes[iNumWalls].nodes[n].n = slope.findNormal();
            wallNodes[iNumWalls].nodes[n].n.isPosition(true);
            
            wallNodes[iNumWalls].nodes[n].offset = wallNodes[iNumWalls].nodes[n].n;
            wallNodes[iNumWalls].nodes[n].offset.isPosition(false);
            wallNodes[iNumWalls].nodes[n].offset.setMag(   ( ((float)(rand()%50))/100 - .25) );
            //wallNodes[iNumWalls].nodes[n].offset.setVector();
            wallNodes[iNumWalls].nodes[n].dir=rand()%2;
            if(wallNodes[iNumWalls].nodes[n].dir == 0 )
                wallNodes[iNumWalls].nodes[n].dir = -1;

            
            //pos += slope*nodeSpacing;
            pos.setVector(pos.retX()+slope.retX()*nodeSpacing,pos.retY()+slope.retY()*nodeSpacing,true);
            //pos.setVector( slope.retX()*nodeSpacing, slope.retY()*nodeSpacing, true );
        }
        
        wallNodes[iNumWalls].nodes[wallNodes[iNumWalls].nNodes-1].pos = _p2;
                   
        //numNodes+=nodes;
        iNumWalls++;
    }
}

void Arena::update(void)
{
    for(int n=0 ; n<iNumWalls ; n++)
    {    
        for(int i=1 ; i<wallNodes[n].nNodes-1 ; i++)
        {
            //wallNodes[n].nodes[i].offset += wallNodes[n].nodes[i].n*.1 * wallNodes[n].nodes[i].dir;
            wallNodes[n].nodes[i].offset.setMag( wallNodes[n].nodes[i].offset.retMag() + vibrationSpeed*wallNodes[n].nodes[i].dir   );    
                
            if(abval( wallNodes[n].nodes[i].offset.retMag() )>vibrationMag)
            {
                wallNodes[n].nodes[i].dir *= -1;
            }    
        }
    }        
}    

void Arena::draw(bool wireframe)
{
    //BRect::draw();
    float lineLength;

    CVector2 slope,pos,tPos;
    CVector2 offset;
                
    float tx,ty;
    float rColour;


    glDisable(GL_LIGHTING);
    glEnable(GL_BLEND);
    glDisable(GL_TEXTURE_2D);
    glBlendFunc(GL_SRC_ALPHA,GL_ONE);

    
 
    for(int n=0 ; n<iNumWalls ; n++)
    {
        //draw the first node without offset
        glBegin(GL_LINE_STRIP); 
        setColour(.8,.8,1,1); 
        glVertex3f(wallNodes[n].nodes[0].pos.retX()
                  ,wallNodes[n].nodes[0].pos.retY()
                  ,0); 
        
        
        //glColor4f(1-rColour,1-rColour,1,.5);
        setColour(1-.25,1-.25,1,.5);
        
        //draw all the in-between nodes with offset
        for(int i=1 ; i<wallNodes[n].nNodes-1 ; i++)
        {
            //setColour(.8,.8,1,1); 
            glVertex3f(wallNodes[n].nodes[i].pos.retX() + wallNodes[n].nodes[i].offset.retX()*wallNodes[n].nodes[i].offset.retMag()
                      ,wallNodes[n].nodes[i].pos.retY() + wallNodes[n].nodes[i].offset.retY()*wallNodes[n].nodes[i].offset.retMag()
                      ,0); 
        } 
        
        //draw the last node without offset    
        setColour(.8,.8,1,1); 
        glVertex3f(wallNodes[n].nodes[wallNodes[n].nNodes-1].pos.retX()
                  ,wallNodes[n].nodes[wallNodes[n].nNodes-1].pos.retY()
                  ,0);         
            
        glEnd();  
        
         
  
        
        /*glBegin(GL_LINE_STRIP); 
        for(int i=0 ; i<wallNodes[n].nNodes ; i++)
        {
            setColour(.8,.8,1,1); 
            glVertex3f(wallNodes[n].nodes[i].pos.retX()
                      ,wallNodes[n].nodes[i].pos.retY()
                      ,0); 
        }       
        glEnd();*/
    } 


    /*for(int nBorder=0 ; nBorder<2 ; nBorder++)
    {
        glBegin(GL_LINE_LOOP);
    
        for(int n=0 ; n<iNumWalls ; n++)
        {
            //wall[n].draw();
            slope = wall[n].retSlope();
            lineLength = slope.retMag();
            numNodes = lineLength / nodeSpacing;
        
            pos = wall[n].retP1();
            
            //glColor4f(.8,.8,1,1);
            setColour(.8,.8,1,1);
            glVertex3f(pos.retX(),pos.retY(),0);
            
            rColour = (float)(rand()%100)/200;
            //glColor4f(1-rColour,1-rColour,1,.5);
            setColour(1-rColour,1-rColour,1,.5);
            
            for(int n2=1 ; n2<numNodes-1 ; n2++)
            {
                pos=makeVector2(pos.retX()+slope.retX()*nodeSpacing,pos.retY()+slope.retY()*nodeSpacing,true);
                

                offset= slope.findNormal();
                offset.isPosition(true);
                offset.setMag( (float)(rand()%100)/50 - 1 );

                tPos=makeVector2(pos.retX()+offset.retX()*offset.retMag(),pos.retY()+offset.retY()*offset.retMag(),true);

                glVertex3f(tPos.retX(),tPos.retY(),0);
            }
    
        }
        glEnd();
    }*/
    
    glDisable(GL_BLEND);
    glEnable(GL_LIGHTING);

}
