/*   ______   ___    ___
    /\  _  \ /\_ \  /\_ \                             
    \ \ \L\ \\//\ \ \//\ \      __     __   _ __   ___ 
     \ \  __ \ \ \ \  \ \ \   /'__`\ /'_ `\/\`'__\/ __`\
      \ \ \/\ \ \_\ \_ \_\ \_/\  __//\ \L\ \ \ \//\ \L\ \
       \ \_\ \_\/\____\/\____\ \____\ \____ \ \_\\ \____/
        \/_/\/_/\/____/\/____/\/____/\/___L\ \/_/ \/___/
                                       /\____/
         A game programming library    \_/__/   Version 4.2.0
         
         Space Battle using Dev-C++ 4.9.9.2   (c) 2006 by Gia T. Nguyen  */

// *******************************************************************************
//
// Last Updated:  February 23, 2006
//
// *******************************************************************************

#include <allegro.h>
#include <stack>
#include <string>
#include <math.h>
#include <fstream>
#include "spacedata.h"
using namespace std;

/* Global Constants */

#define MASTER_CONFIG "allegro.cfg"
#define CFG_FILE "spacebattle.cfg"             
#define FORMATION_FILE "spacebattle2.cfg"
#define DATA_FILE "spacebattle.dat"

#define GREEN makecol(0,255,0)                
#define RED makecol(255,0,0)
#define BLUE makecol(0,0,255)
#define YELLOW makecol(255,255,0)
#define BLACK makecol(0,0,0)
#define WHITE makecol(255,255,255)

#define MAX_X 14                           
#define MAX_Y 10
                     
#define BMP_SIZE 24
#define SQUARE_SIZE 25
#define MOUSE_TOLERANCE  10

/* Type Definitions */
enum Pause {
     TENTH_SEC = 100,
     THIRD_SEC = 300,
     HALF_SEC  = 500,
     FULL_SEC  = 1000,
     PAUSE = 5500
};
enum Ship {                                
     CARRIER    = 5,
     BATTLESHIP = 4,
     DESTROYER  = 3,
     CORVETTE   = 2,
     GUNBOAT    = 2,
     GUNBOAT1   = 1,
     EMPTY      = 0
};
enum Player {                               
     COMPUTER,
     HUMAN
};     
enum Level {
     CADET = 1,
     ENSIGN = 2,
     LIEUTENANT=3,
     COMMANDER=4,
     CAPTAIN=5
};
enum Mouse {                               
     LEFT_BUTTON = 1,
     RIGHT_BUTTON = 2
};
enum InputType {                          
     MOUSE_FIRE   = 1,
     MOUSE_RECON  = 2,
     AUTO_FIRE    = 3,
     LOAD_DATA    = 4,
     SOUND_TOGGLE = 5,
     CARRIER_SALVO1 = 6,
     CARRIER_SALVO2 = 7,
     BATTLESHIP_SALVO1 = 8,
     BATTLESHIP_SALVO2 = 9,
     DESTROYER_SALVO1 = 10,
     DESTROYER_SALVO2 = 11,
     SINGLE_SALVO = 12
};
enum FireDirection {
     UP = 1,
     RIGHT = 2,
     DOWN = 3,
     LEFT = 4,
     ROUND_TRIP = 5
};
     
typedef struct Coord {                      
       int x;
       int y;
};
typedef struct Hit {                        
       int x;                     
       int y;
       char type;                      
};
typedef struct BoxCoord {
        Coord top;
        Coord bottom;
};
typedef char Grid[MAX_X][MAX_Y];                  
typedef stack<Hit> Bucket;

/* Global Variables */

Grid friendly_grid, enemy_grid;

Coord enemycoord={10,10};
Coord friendlycoord={10,305};
Coord enemycoord_bottom={360,260};
Coord friendlycoord_bottom={360,555};

BoxCoord enemygrid = {enemycoord,enemycoord_bottom};
BoxCoord friendlygrid = {friendlycoord,friendlycoord_bottom};

Bucket manual_list, hitlist, humanlist;

DATAFILE *data;

BITMAP *explosion;                          
BITMAP *enemy;
BITMAP *friendly;
BITMAP *bkg;
BITMAP *enemy_label;
BITMAP *friendly_label;
BITMAP *missed;
BITMAP *probe;
BITMAP *noprobe;
BITMAP *gameover;

SAMPLE *explode_snd;
SAMPLE *ping_snd;
SAMPLE *done_snd;
SAMPLE *announce_snd;
SAMPLE *blip_snd;
SAMPLE *intro_snd;

bool load_data=false;
bool sound_on=true;
bool manual_click=false;

int advanced_salvo=0;
int escore=5, fscore=5;
int e1=0,e2=0,e3=0,e4=0,e5=0;
int f1=0,f2=0,f3=0,f4=0,f5=0;
int playlevel=LIEUTENANT;
int recons;
int loadship_click=0;
int loadship=CARRIER;
int pause=HALF_SEC;
int skip = -1;
int max_recon;
int volume;
int videox;
int videoy;

/* Function Prototyping */

void init();
void init_grid();
void load_bmp();
void load_wav();
void load_formation();
void draw_bkg();
void draw_reconbox();
void draw_labels();
void counter_shot();
void draw_score();
void finish();
void load_intro();
void erase_probe();
void load_binaries();
void show_gridlegend();
void show_reconlegend();
void show_salvolegend();
void get_playlevel();
void show_ready();
void show_tip();

void deinit();
void deinit(int err_code);

void manual_load();
void manual_load(Coord firecoord);

void draw_bitmap(BITMAP *bitmap, int x, int y);
void draw_bitmap(BITMAP *bitmap, int X, int Y, int x, int y);

void draw_grid(int who);
void recon(Coord firecoord);
void load_gameboard(int who);
void draw_scores(int who);
void show_shipdesc(int ship);

bool play();
bool fire_shot(Coord firecoord);
bool isvalid(int x, int y);

int get_inputs();
int rndgen(int rndmax);
int load_datafile(int who,int *skip);
int fire_advanced(Coord firecoord,int salvo_type);

Coord calc_mousepos(int who, bool *valid);
Coord auto_fire(int who);
Coord compute_fire(int who);

/* Debug Only */
bool debug=false;
int debug_computer_data = -1;
int debug_human_data = -1;
