#ifndef _WORLD_H
#define _WORLD_H

#include <stdio.h>
#include "math.h"
#include "object.h"

#define SQUARE_WIDTH  64
#define SQUARE_HEIGHT  2
#define SQUARE_DEPTH  64

typedef struct SCREEN_COORD {
   int x, y;
} SCREEN_COORD;

class Point : public VECTOR {
public:
   VECTOR normal;
   float staticLight;
   float dynamicLight;
   Point(void) {}
   Point(float _x, float _y, float _z, VECTOR _normal, float _staticLight, float _dynamicLight) {
      x = _x;
      y = _y;
      z = _z;
      normal = _normal;
      staticLight = _staticLight;
      dynamicLight = _dynamicLight;
   }
   VECTOR getVector(void) { VECTOR temp; temp.x = x; temp.y = y; temp.z = z; return temp; }
   int getLight(void) { return (int)(staticLight * dynamicLight / 255); }
   float dist;
private:
};

class Square {
public:
   Square(void) {}
   ~Square(void) {}
   int texture;
   bool fringe;
private:
};

class World {
public:
   World(void) : w(0), h(0), point(NULL), square(NULL), objects(NULL) {}
   ~World(void) { destroyPoint(); destroySquare(); }
   void setW(int _w) { w = _w; }
   void setH(int _h) { h = _h; }
   int getW(void) { return w; }
   int getH(void) { return h; }
   void createPoint(void) { if (point != NULL) { destroyPoint(); } point = new Point[(w + 1) * (h + 1)]; }
   void createSquare(void) { if (square != NULL) { destroySquare(); } square = new Square[w * h]; }
   void destroyPoint(void) { delete [] point; point = NULL; }
   void destroySquare(void) { delete [] square; square = NULL; }
   Point *getPoint(int x, int y) {
      if (x >= 0 && y >= 0 && x < w + 1 && y < h + 1) {
         return &point[x + y * (w + 1)];
      }
      else {
         return NULL;
      }
   }
   Square *getSquare(int x, int y) {
      if (x >= 0 && y >= 0 && x < w && y < h) {
         return &square[x + y * w];
      }
      else {
         return NULL;
      }
   }
private:
   int w, h;
   Point *point;
   Square *square;
   ObjectList *objects;
};

#endif

