#include "texture.h"
#include "video.h"

TextureSet::TextureSet(void)
{
   count = 0;
   for (int i = 0; i < 256; i++) {
      textures[i] = NULL;
   }
}

TextureSet::~TextureSet(void)
{
}

void TextureSet::open(char *fileName)
{
   int tileW, tileH;
   int spacingTop, spacingBottom, spacingLeft, spacingRight;
   int tilesX, tilesY;
   int templateW, templateH;
   int x, y;
   int x1, y1, x2, y2;
   int i;
   int red, green, blue;
   int pixel;
   int bitmapX, bitmapY;

   if (textures[0] != NULL) {
      close();
   }

   BITMAP *temp = load_bitmap(fileName, NULL);

   tileW = tileH = 32;
   tilesX = tilesY = 16;
   spacingTop = spacingBottom = spacingLeft = spacingRight = 1;

   templateW = tilesX * (tileW + spacingLeft + spacingRight);
   templateH = tilesY * (tileH + spacingTop + spacingBottom);

   i = 0;
   for (y = 0; y < tilesY; y++) {
      red = 0;
      green = 0;
      blue = 0;
      for (x = 0; x < tilesX; x++) {
         x1 = spacingLeft + x * (tileW + spacingLeft + spacingRight);
         y1 = spacingTop  + y * (tileH + spacingTop  + spacingBottom);
         x2 = x1 + tileW - 1;
         y2 = y1 + tileH - 1;

         textures[i] = create_bitmap(tileW, tileH);
         blit(temp, textures[i], x1, y1, 0, 0, tileW, tileH);
         if (i % 32 == 0) {
            for (bitmapX = 0; bitmapX < tileW; bitmapX++) {
               for (bitmapY = 0; bitmapY < tileH; bitmapY++) {
                  pixel = getpixel(textures[i], bitmapX, bitmapY);
                  red   += getr_depth(videoDepth, pixel);
                  green += getg_depth(videoDepth, pixel);
                  blue  += getb_depth(videoDepth, pixel);
               }
            }
            colours[(int)(i / 32)] = makecol_depth(videoDepth, red / (tileW * tileH), green / (tileW * tileH), blue / (tileW * tileH));
         }
         i++;
      }
   }

   destroy_bitmap(temp);
}

void TextureSet::close(void)
{
   for (int i = 0; i < 256; i++) {
      destroy_bitmap(textures[i]);
   }
}