#ifndef _MATH_H
#define _MATH_H

#include <math.h>
#include <allegro.h>

#ifndef M_PI
#define M_PI 3.141592654
#endif

#define DEG(n)    ((n) * 180.0 / M_PI)
#define RAD(n)    ((n) * M_PI / 180.0)
#define B_DEG(n)  ((n) / (360.0 / 256.0))

typedef struct VECTOR {
   float x, y, z;
} VECTOR;

V3D_f makeVertex(float x, float y, float z, float u, float v, int c);
VECTOR makeVector(float x, float y, float z);
float ran(float max);
float dist(float x1, float y1, float z1, float x2, float y2, float z2);
float vectorDivergence(const VECTOR *const v1, const VECTOR *const v2);
VECTOR planeNormal(const VECTOR *const v1, const VECTOR *const v2, const VECTOR *const v3);
float getLightLevel(float radiusFull, float levelFull, float radiusNone, float levelNone, float distance);

#endif
