#include "math.h"

#include <stdlib.h>
#include <allegro.h>
#include <math.h>

V3D_f makeVertex(float x, float y, float z, float u, float v, int c)
{
   V3D_f temp = {x, y, z, u, v, c};
   return temp;
}

VECTOR makeVector(float x, float y, float z)
{
   VECTOR temp = {x, y, z};
   return temp;
}

float ran(float max)
{
   return ((float)rand() / (float)RAND_MAX) * max;
}

float dist2d(float x1, float y1, float x2, float y2)
{
   float dx = x1 - x2;
   float dy = y1 - y2;
   return sqrt(dx * dx + dy * dy);
}

float dist(float x1, float y1, float z1, float x2, float y2, float z2)
{
   float dx = x1 - x2;
   float dy = y1 - y2;
   float dz = z1 - z2;
   return sqrt((dx * dx) + (dy * dy) + (dz * dz));
}

float vectorDivergence(const VECTOR *const v1, const VECTOR *const v2)
{
   float a, b, c;
   a = vector_length_f(v1->x, v1->y, v1->z);
   b = vector_length_f(v2->x, v2->y, v2->z);
   c = dist(v1->x, v1->y, v1->z, v2->x, v2->y, v2->z);
   return DEG(acos((a * a + b * b - c * c) / (2 * a * b)));
}

VECTOR planeNormal(const VECTOR *const v1, const VECTOR *const v2, const VECTOR *const v3)
{
   VECTOR temp;
   cross_product_f(v1->x - v2->x, v1->y - v2->y, v1->z - v2->z, v3->x - v2->x, v3->y - v2->y, v3->z - v2->z, &temp.x, &temp.y, &temp.z);
   return temp;
}

float getLightLevel(float radiusFull, float levelFull, float radiusNone, float levelNone, float distance)
{
   float levelDistance = levelNone;

   if (distance < radiusFull) {
      levelDistance = levelFull;
   }
   else if (distance < radiusNone) {
      levelDistance = (radiusNone - distance) * ((levelFull - levelNone) / (radiusNone - radiusFull));
   }

   return levelDistance;
}

void furToHpr(VECTOR front, VECTOR up, VECTOR right, float *heading, float *pitch, float *roll)
{
}
