/*
Function prototypes for Danny's Platform Game.
Keep these sorted in alphabetical order,
with a blank line in between functions.
*/

#include "headers.h"

void activate_switch_block (LEVEL_TYPE *level, CELL_DATA_TYPE *cell_data, 
							int x_cell, int y_cell,	int cell_index,
							ANIMATION_TYPE animations[], BITMAP *sprites[],
							RLE_SPRITE *rle_sprites[], char is_rle_sprite[]);

int add_animation (int x_cell, int y_cell, double x_offset, double y_offset, int cell_index, 
				   int frames_delay, int num_iterations, int num_frames, int tag,
				   double x_velocity, double y_velocity, ANIMATION_TYPE animations[],
				   BITMAP *sprites[], RLE_SPRITE *rle_sprites[], char is_rle_sprite[]);

void assign_cell_types (CELL_DATA_TYPE *cell_data);

int check_input (BITMAP **buffer, BITMAP **status_bar_bmp, BITMAP *sprites[], 
				 RLE_SPRITE *rle_sprites[], char is_rle_sprite[],
				  LEVEL_TYPE *level, PLAYER_TYPE *player, WINDOW_TYPE *window,
				  KEYS_TYPE *keysdown, CELL_DATA_TYPE *cell_data, ANIMATION_TYPE animations[],
				  int *music_volume);

int collect_item (int x_cell, int y_cell, int type, LEVEL_TYPE *level, PLAYER_TYPE *player,
				   CELL_DATA_TYPE *cell_data, BITMAP **status_bar_bmp, RLE_SPRITE *rle_sprites[],
				   WINDOW_TYPE *window);

void detect_collisions (COLLISION_INPUT_TYPE *collision_input_data, LEVEL_TYPE *level,
						PLAYER_TYPE *player, ENEMY_TYPE enemies[], ENEMY_DATA_TYPE enemy_data[],
						KEYS_TYPE *keysdown, CELL_DATA_TYPE *cell_data,
						COLLISION_DETECTION_TYPE collision_data[2][4]);

int draw_big_numbers (int pos_x, int pos_y, long value, BITMAP **status_bar_bmp,
					   RLE_SPRITE *rle_sprites[], CELL_DATA_TYPE *cell_data);

void draw_small_numbers (int pos_x, int pos_y, long value, BITMAP **buffer,
					   RLE_SPRITE *rle_sprites[], CELL_DATA_TYPE *cell_data);

void draw_animations (BITMAP **buffer, BITMAP *sprites[], RLE_SPRITE *rle_sprites[], 
					  PLAYER_TYPE *player, WINDOW_TYPE *window, CELL_DATA_TYPE *cell_data, 
					  ANIMATION_TYPE animations[], char is_rle_sprite[]);

void draw_enemies(BITMAP **buffer, BITMAP *sprites[], WINDOW_TYPE *window, ENEMY_TYPE enemies[],
				  ENEMY_DATA_TYPE enemy_data[]);

void draw_player(BITMAP **buffer, BITMAP *sprites[], RLE_SPRITE *rle_sprites[], PLAYER_TYPE *player,
				 WINDOW_TYPE *window, CELL_DATA_TYPE *cell_data, KEYS_TYPE *keysdown, 
				 char is_rle_sprite[]);

void draw_screen (BITMAP **buffer, BITMAP **status_bar_bmp, RLE_SPRITE **background_image, 
				  BITMAP *sprites[], RLE_SPRITE *rle_sprites[], LEVEL_TYPE *level,
				  PLAYER_TYPE *player, ENEMY_TYPE enemies[], ENEMY_DATA_TYPE enemy_data[],
				  WINDOW_TYPE *window, CELL_DATA_TYPE *cell_data, ANIMATION_TYPE animations[],
				  KEYS_TYPE *keysdown, char is_rle_sprite[]);

void fix_filename_escape_chars(char *filename);

int get_animation_frame (int which_cell, CELL_DATA_TYPE *cell_data);

int get_cell(LEVEL_TYPE *level, CELL_DATA_TYPE *cell_data, int x, int y);

void get_collision_input (COLLISION_INPUT_TYPE *collision_input_data, int type, int which,
						  KEYS_TYPE *keysdown, PLAYER_TYPE *player, ENEMY_TYPE enemies[],
						  ENEMY_DATA_TYPE enemy_data[], ANIMATION_TYPE animations[]);

void hurt_player (int move_direction, int damage, char start_blinking, PLAYER_TYPE *player);

void initialize_player (LEVEL_TYPE *level, PLAYER_TYPE *player, WINDOW_TYPE *window,
						CELL_DATA_TYPE *cell_data);

void init_beginning (int screen_x_size, int screen_y_size, int color_depth, BITMAP **buffer,
					 BITMAP **status_bar_bmp, LEVEL_TYPE *level, PLAYER_TYPE *player,
					 WINDOW_TYPE *window, KEYS_TYPE *keysdown);

void kill_enemy (int which_enemy, ENEMY_TYPE enemies[], ENEMY_DATA_TYPE enemy_data[], 
				 ANIMATION_TYPE animations[], BITMAP *sprites[], RLE_SPRITE *rle_sprites[],
				 char is_rle_sprite[]);

void kill_player (PLAYER_TYPE *player);

void load_enemy_data (int which_enemy, FILE *fp_in, ENEMY_DATA_TYPE enemy_data[]);

void load_music (SAMPLE *background_music, char *music_filename, int *music_volume);

int load_sprites (BITMAP *sprites[], RLE_SPRITE *rle_sprites[], PLAYER_TYPE *player, 
				  ENEMY_DATA_TYPE enemy_data[], CELL_DATA_TYPE *cell_data,
				  char is_rle_sprite[]);

void load_level (RLE_SPRITE **background_image, BITMAP **status_bar_bmp, BITMAP *sprites[],
				 RLE_SPRITE *rle_sprites[], LEVEL_TYPE *level, PLAYER_TYPE *player,
				 ENEMY_TYPE enemies[], ENEMY_DATA_TYPE enemy_data[], WINDOW_TYPE *window,
				 CELL_DATA_TYPE *cell_data, ANIMATION_TYPE animations[], int which_level,
				 char music_filename[]);

int move_animations (COLLISION_INPUT_TYPE *collision_input_data, 
					  COLLISION_DETECTION_TYPE collision_data[2][4],
					  LEVEL_TYPE *level, PLAYER_TYPE *player, WINDOW_TYPE *window,
					  CELL_DATA_TYPE *cell_data, ANIMATION_TYPE animations[],
					  ENEMY_TYPE enemies[], ENEMY_DATA_TYPE enemy_data[], KEYS_TYPE *keysdown,
					  BITMAP *sprites[], RLE_SPRITE *rle_sprites[], char is_rle_sprite[]);

int move_enemies (LEVEL_TYPE *level, PLAYER_TYPE *player, KEYS_TYPE *keysdown,
				   ENEMY_TYPE enemies[], ENEMY_DATA_TYPE enemy_data[], WINDOW_TYPE *window,
				   COLLISION_INPUT_TYPE *collision_input_data, 
				   COLLISION_DETECTION_TYPE collision_data[2][4], CELL_DATA_TYPE *cell_data,
				   ANIMATION_TYPE animations[], BITMAP *sprites[], RLE_SPRITE *rle_sprites[],
				   char is_rle_sprite[]);

void move_player (LEVEL_TYPE *level, PLAYER_TYPE *player, ENEMY_TYPE enemies[], 
					  WINDOW_TYPE *window, KEYS_TYPE *keysdown,
					  COLLISION_DETECTION_TYPE collision_data[2][4], CELL_DATA_TYPE *cell_data);

int move_projectiles (int which_ani, COLLISION_INPUT_TYPE *collision_input_data, 
					  COLLISION_DETECTION_TYPE collision_data[2][4],
					  LEVEL_TYPE *level, PLAYER_TYPE *player, WINDOW_TYPE *window,
					  CELL_DATA_TYPE *cell_data, ANIMATION_TYPE animations[],
					  ENEMY_TYPE enemies[], ENEMY_DATA_TYPE enemy_data[], KEYS_TYPE *keysdown,
					  BITMAP *sprites[], RLE_SPRITE *rle_sprites[], char is_rle_sprite[]);

void play_music (SAMPLE *background_music, int *music_volume);

int react_to_collision_detection (BITMAP **status_bar_bmp, BITMAP *sprites[], 
								  RLE_SPRITE *rle_sprites[], char is_rle_sprite[],
								  LEVEL_TYPE *level, WINDOW_TYPE *window, PLAYER_TYPE *player,
								  COLLISION_DETECTION_TYPE collision_data[2][4], 
								  KEYS_TYPE *keysdown, CELL_DATA_TYPE *cell_data,
								  ANIMATION_TYPE animations[]);

int rectangles_collide (int x_cell_1, int y_cell_1, double x_offset_1, double y_offset_1,
						int width_1, int height_1, int x_cell_2, int y_cell_2, 
						double x_offset_2, double y_offset_2, int width_2, int height_2);

void refresh_status_bar (char draw_health, char refresh_health, 
						 char draw_lives, char refresh_lives, 
						 char draw_score, char refresh_score, 
						 char draw_o2_bar, char refresh_o2_bar, 
						 char draw_item, char refresh_item, 
						 BITMAP **status_bar_bmp, RLE_SPRITE *rle_sprites[],
						 PLAYER_TYPE *player, WINDOW_TYPE *window, CELL_DATA_TYPE *cell_data);

void scan_area_for_enemies (int x1_cell, int y1_cell, int x2_cell, int y2_cell, 
							LEVEL_TYPE *level, ENEMY_TYPE *enemies, ENEMY_DATA_TYPE enemy_data[],
							CELL_DATA_TYPE *cell_data);

void scroll_window (WINDOW_TYPE *window, LEVEL_TYPE *level, int x_add, int y_add);

void set_cell(LEVEL_TYPE *level, CELL_DATA_TYPE *cell_data, int x, int y, int cell_index);

void start_enemy (int x_cell, int y_cell, int cell_index, ENEMY_TYPE enemies[],
				  ENEMY_DATA_TYPE enemy_data[], CELL_DATA_TYPE *cell_data);

void switch_solid_and_dotted_blocks (LEVEL_TYPE *level, CELL_DATA_TYPE *cell_data, 
									 int which_switch);

int throw_projectile (BITMAP **status_bar_bmp, BITMAP *sprites[], RLE_SPRITE *rle_sprites[], 
					   char is_rle_sprite[], PLAYER_TYPE *player, CELL_DATA_TYPE *cell_data,
					   ANIMATION_TYPE animations[], WINDOW_TYPE *window);

void update_animation (BITMAP *sprites[], RLE_SPRITE *rle_sprites[], char is_rle_sprite[],
					   LEVEL_TYPE *level, PLAYER_TYPE *player, CELL_DATA_TYPE *cell_data,
					   ANIMATION_TYPE animations[]);

// Utility functions
int get_x_pixel (int x_cell, double x_offset, WINDOW_TYPE *window);
int get_y_pixel (int y_cell, double y_offset, WINDOW_TYPE *window);
void copy_page (BITMAP *source, BITMAP *dest);
void get_str_from_int (char *str, int num);
void get_str_from_long (char *str, long num);
void shout (char *str);
void snum (int num);






