/*
Author:	Daniel Tenedorio
Date Started: Sept. 4, 2005
Description: Platform Game (more to come)

TODO:
(1) React to some different types of cells:
	(X) items
	(2) water
		(X) Use rotated sprites when drawing the swimming player.
		(X) Initiate the oxygen bar while swimming
		(3) Position the bubbles better!
	(X) ice
	(4) harm
		(1) Fix the lava glitch
	(X) action
		(X) Cannons - Draw and activate 3 or 4-frame exploding animation
(2) Activate and move the enemies
	(X) Create the data types
	(X) Determine a way to scan cells regularly to start new enemies
	(3) Make the OTHER enemies move around
	(X) Detect when the player hits the enemies, or the enemies hit each other (collision
		detection)
(3) Modify check_bounds to support diagonal cells.
(4) Make moving platforms.
(5) Make the coffee work; make more items?
	(1) Standing, re-generating (once offscreen?) bubbles in the water that refill air
(6) Enable weapons
	(1) Make the bombs move
	(2) Make the bombs explode on contact with a solid cell
	(3) Make the explosion kill enemies on contact
	(4) Make the number of projectiles decrease upon releasing a bomb
	(5) Remove the item bar when there are no items left

(X) Write draw_screen function to draw a part of the level onto the screen
	as defined by (WINDOW_TYPE) window.
(X) Maybe get rid of all the global variables now that they're categorized
	into types?
(X) Edit load_sprites to load ALL the sprites, not just the ones in tilelist.txt.
(X)		(1) Incorporate a new text file, sprlist.txt?
(X) Make draw_screen faster! Maybe convert BITMAP *background_image into 
(X)		RLE_SPRITE *background_image?
(X) Make the left and right arrow keys change the player's velocity.
(X) Write move_player function to move the player based on his velocity.
	(1) Do bounds checking - based on where the player is GOING TO BE.
	(2) Classify different cells based on type
(X) Draw foreground objects (such as the player, grass etc.) after drawing the cells.
(X) Enable cell animation
	(X) Update tilelist.txt to indicate how many animation frames exist for each cell
	(X) Ensure that for each cell that has more than one frame, the subsequent frames
		are subsequent in sprlist.txt
	(X) Modify load_cell_data to load the data for number of frames as well
	(X) Modify draw_screen and get_animation_frame so the right frame is drawn each refresh
(X) Solve the "corners problem" with regards to collision detection.
*/

#include "allegro.h"
#include "stdio.h"
#include "stdlib.h"
#include "string.h"
#include "math.h"

#define TRUE				-1
#define FALSE				0

// For file loading purposes!
#define FILESYSTEM_LINUX	TRUE
#define FILESYSTEM_WINDOWS	FALSE

//#define TEXTPRINTF			textprintf			// Un-comment these for Allegro < 4.2.0
//#define TEXTPRINTF_COL		WHITE
#define TEXTPRINTF				textprintf_ex		// Un-comment these for Allegro 4.2.0
#define TEXTPRINTF_COL			WHITE, BLACK

#define PI					3.141592654
#define PAUSE				clear_keybuf();	readkey()

// Essential game contstants
#define GAME_MSEC_DELAY			105			// Number of milliseconds to delay in between refreshes
#define CELL_SIZE				32			// Size of one cell, in pixels

// Sound constants
#define NUM_SOUND_VOICES		5			// Max number of available sound voices
#define SOUND_VOICE_MUSIC		0			// Background music plays here

// Maximum array sizes
#define MAX_SPRITES				400			// Maximum number of sprites that can be loaded
#define MAX_LEVEL_TITLE_LENGTH	50
#define MAX_ACTIVE_ENEMIES		40			// Maximum number of active enemies possible @ once
#define MAX_ANIMATIONS			20			// Maximum number of active animations possible
#define NUM_ENEMY_DATA			7			// Number of enemies that must be described
											// for each level .inf file
#define NUM_ENEMY_SPRITES		12

// Status bar related
#define STATUS_BAR_HEIGHT		60
#define O2_LOSS_SPEED			7
#define BUBBLE_FREQUENCY		300			// Larger number = less likely a bubble is to occur
#define TAG_UPSIDE_DOWN			-10			// Tells draw_screen to draw the object upside-down

// Collision detection related
#define DETECT_PLAYER			0			// Collision detect using the player's data
#define DETECT_ENEMY			1			// Collision detect using an enemy's data
#define DETECT_PROJECTILE		2			// Collision detect using a projectile's data

// Enemy data types
#define ENEMY_DATA_TYPE_BIRD		0
#define ENEMY_DATA_TYPE_ICE_BEAR	3
#define ENEMY_DATA_TYPE_RED			5

// Powerup increments
#define BOMB_POWERUP_INCREMENT		6
#define MAX_BOMBS					50

// Spring constants
#define MAX_SPRINGBOARDS		20			// Maximum number of active springboards at once
#define SPRING_HEIGHT_1			14
#define SPRING_HEIGHT_2			21
#define SPRING_HEIGHT_3			32
#define SPRING_SWITCH_FRAMES	15
#define SPRING_RESET_FRAMES		45

// Forces
#define FORCE_GRAVITY			.075
#define FORCE_JUMP				4
#define FORCE_CONTINUE_JUMP		.15
#define FORCE_WALK				.2
#define FORCE_WALK_ICE			.025
#define FORCE_CONVEYOR			1
#define FORCE_SPRINGBOARD		6.2
#define FORCE_SWIM				.1
#define FORCE_WATERFALL			.1
#define FORCE_JUMP_FROM_WATER		3.0
#define FORCE_ENEMY_COLLISION_X		2.0
#define FORCE_ENEMY_COLLISION_Y		1.0
#define FORCE_BOUNCE_ENEMY		4.3
#define FORCE_CANNON			7
#define FORCE_BIRD				.03
#define FORCE_THROW_BOMB		3.5
#define STOP_FACTOR_WALKING		.2
#define STOP_FACTOR_SWIMMING	.01
#define MAX_BIRD_Y_VELOCITY		1.5

// Damage/Recovery amounts
#define DAMAGE_ELECTRICITY		1
#define DAMAGE_LAVA				2
#define DAMAGE_BOMB				30
#define RECOVER_APPLES			5
#define RECOVER_BANANAS			5
#define RECOVER_GRAPES			5
#define RECOVER_WATERMELON		5

// Score amounts
#define SCORE_APPLES			20
#define SCORE_BANANAS			20
#define SCORE_GRAPES			20
#define SCORE_WATERMELON		20
#define SCORE_HEART				0
#define SCORE_DEFEAT_ENEMY		200

// Cell types
#define TYPE_EMPTY			0		// Empty cells the player can move through
#define TYPE_SQUARE			1		// Completely full cells the player cannot move through
#define TYPE_DIAGONAL_UPPER_LEFT	2		// Cells which the player can only move through
#define TYPE_DIAGONAL_UPPER_RIGHT	3		// part of. These definitions specify which part
#define TYPE_DIAGONAL_LOWER_LEFT	4
#define TYPE_DIAGONAL_LOWER_RIGHT	5
#define TYPE_ITEM			6		// Cells that contain an item to collect
#define TYPE_ACTION			7		// Cells that do something when the player touches them
									// such as cannons, springs, etc.
#define TYPE_FOREGROUND		8		// Objects such as grass that appear after everything else
#define TYPE_HARM			9		// Cells that harm the player when touched
#define TYPE_WATER			10		// Must make the player swim through these
#define TYPE_ICE			11		// Has the properties of solid cells, but are slippery
#define TYPE_MOVING_RIGHT	12		// Has the properties of solid cells, but moves player right
#define TYPE_MOVING_LEFT	13		// Has the properties of solid cells, but moves player left
#define TYPE_CLIMBABLE		14		// Has the properties of empty cells, but can be climbed
#define TYPE_PLAYER			15		// Indicates that the player starts at this cell
#define TYPE_PLATFORM		16		// Player can move up, left and right through it, not down
#define TYPE_WATERFALL		17		// Player can swim, but is pushed downwards
#define TYPE_ENEMY			30		// Indicates that an enemy starts at this cell (30 and above)

// Directions
#define FACING_LEFT			1
#define FACING_RIGHT		2
#define FACING_UP			3
#define FACING_DOWN			4
#define FACING_FRONT		5
#define FACING_BACK			6

// Itsm possessions
#define ITEM_NONE			0
#define ITEM_THROW_BOMBS	1

// Color values
#define BLACK				makecol(0, 0, 0)
#define DARK_GRAY			makecol(64, 64, 64)
#define GRAY				makecol(128, 128, 128)
#define WHITE				makecol(255, 255, 255)
#define YELLOW				makecol(255, 255, 0)
#define RED					makecol(255, 0, 0)
#define BACK_COL			makecol(0, 128, 255)
#define TRANSPARENT_COL		makecol(255, 0, 255)


typedef struct {			// *** PLAYER - variables associated with the main character ***
	char sprite_index;		// Index of the beginning of the sprites for the player
	int x_cell;				// These two values describe the cell in the level in which the
	int y_cell;				// upper left pixel of the player's rectangle resides.
							// They range from (0, 0) to (level.width, level.height).
	double x_offset;		// These two values describe how far, in pixels, the upper left
	double y_offset;		// pixel of the player's rectangle is from the upper left pixel of
							// the current cell.
							// Range: (0, 0) to (cell_width - 1, cell_height - 1) = (31, 31)
	double x_velocity;		// Each loop, the player is moved by this amount in the x direction
	double y_velocity;		// Ditto, y direction
	double max_x_velocity;	// Maximum x velocity the player can achieve
	double max_y_velocity;	// Maximum y velocity the player can achieve
	double max_swim_x_velocity;		// Maximum x velocity the player can achieve while swimming
	double max_swim_y_velocity;		// Maximum y velocity the player can achieve while swimming
	char facing;			// Which direction the player is facing
	char width;				// Width of the rectangle enclosing the player's sprites
	char height;			// Height of the rectangle enclosing the player's sprites
	char top_buffer;		// How many upper rows of pixels are not collision-detected
	char bottom_buffer;		// How many lower rows of pixels are not collision-detected
	char left_buffer;		// How many left columns of pixels are not collision-detected
	char right_buffer;		// How many right columns of pixels are not collision-detected
	char left_slip_buffer;		// Determines when a jump can succeed
	char right_slip_buffer;		// Determines when a jump can succeed
	char is_standing;		// TRUE if the player is standing; FALSE if not
	char is_falling;		// TRUE if the player is falling; FALSE if not
	char is_jumping;		// TRUE if the player is jumping; FALSE if not
	char is_on_ice;			// TRUE if the player is on ice; FALSE if not
	char is_swimming;		// TRUE if the player is swimming; FALSE if not
	char in_waterfall;		// TRUE if the player is in a waterfall; FALSE if not
	char is_in_cannon;		// TRUE is the player is in a cannon; FALSE if not
	int cannon_angle;		// Angle that the cannon is pointing (range: 0 to 255)
	int cannon_x_cell;		// X cell of the cannon the player is in
	int cannon_y_cell;		// Y cell of the cannon the player is in
	int cannon_delay;		// How many game loop iterations to wait before returning the cannon
	int swim_angle;			// Ranges from 0 to 256
	char animation_frame;	// Which frame of animation to display the sprites
	double animation_counter;	// How many pixels have passed before switching frames
	int settle_counter;		// Once this gets to a certain level, settle (make stand) the player
	char is_blinking;		// Set to TRUE if blinking; FALSE if not. Init to FALSE.
	int blink_counter;		// If this = 0, stop the player's blinking. Decrement each loop.
	int cur_level;			// Current level the player is playing through!
	int health;				// Range: 0-?
	int max_health;			// Maximum health
	int lives;				// Range: 0-99
	int max_lives;			// Maximum number of lives
	long score;				// Score (Range: 0-99,999)
	long max_score;			// Maximum score
	int o2;					// Current oxygen: 0 means the player starts losing health!
	int max_o2;				// Maximum oxygen the player can carry into the water
	char has_item;			// Set to FALSE for no item; set to an integer (1-255) for an item
	char conveyed_right;	// Set to TRUE if standing on a rightwards conveyor belt
	char conveyed_left;		// Set to TRUE if standing on a leftwards conveyor belt
	int throw_angle;		// Angle at which to throw things
	char throw_prepared;	// Whether or not the player is ready to throw something
	int num_projectiles;	// Number of objects to throw left
	int max_projectiles;	// Maximum number of throwable objects that the player can hold
} PLAYER_TYPE;

typedef struct {			// *** ENEMY (VARIABLE) - everything about the enemy that changes
							// as the game progresses in the level

	char active;			// TRUE means the enemy is active; FALSE means not
	int x_cell;				// These two values describe the cell in the level in which the
	int y_cell;				// upper left pixel of the enemy's rectangle resides.
							// They range from (0, 0) to (level.width, level.height).
	int prev_x_cell;		// What cell the enemy started in
	int prev_y_cell;
	double x_offset;		// These two values describe how far, in pixels, the upper left
	double y_offset;		// pixel of the enemy's rectangle is from the upper left pixel of
							// the current cell.
							// Range: (0, 0) to (cell_width - 1, cell_height - 1) = (31, 31)
	double x_velocity;		// Each loop, the enemy is moved by this amount in the x direction
	double y_velocity;		// Each loop, the enemy is moved by this amount in the y direction
	char facing;			// Which direction the enemy is facing
	char is_falling;
	char is_jumping;
	char animation_frame;	// Which frame of animation to display the sprites
	char animation_counter;	// How many pixels have passed before switching frames
	char blinking;			// Set to TRUE if blinking; FALSE if not. Init to FALSE.
	int health;				// Range: 0-?
	char has_item;			// Set to FALSE for no item; set to an integer (1-255) for an item
	int enemy_data_type;	// Which element of the enemy_data array corresponds to this enemy
} ENEMY_TYPE;

typedef struct {			// *** ENEMY DATA: everything about the enemy that remains true
							// no matter what the enemy does in the level ***
	
	char num_enemies;		// ONLY USE IN INDEX 0: total number of active enemies at any time
	char cell_index;		// Index of the beginning of the sprites for the enemy
	char width, height;		// Width/Height of the rectangle enclosing the enemy's sprites
	int max_health;
	int player_damage;		// How much damage is dealt to the player upon a collision
	double max_x_velocity, max_y_velocity;	// Maximum velocity the enemy can achieve
	char top_buffer;		// How many upper rows of pixels are not collision-detected
	char bottom_buffer;		// How many lower rows of pixels are not collision-detected
	char left_buffer;		// How many left columns of pixels are not collision-detected
	char right_buffer;		// How many right columns of pixels are not collision-detected
} ENEMY_DATA_TYPE;

typedef struct {			// *** VIEWING WINDOW - variables associated with what is drawn ***
	int x_cell, y_cell;		// The upper left cell in the viewed "window" of the level
	int x_offset, y_offset;		// How many pixels that the viewing window is shifted over
	int top_buffer;			// Move the window if the player is above this many rows of pixels
	int bottom_buffer;		// Move the window if the player is below this many rows of pixels
	int left_buffer;		// Move the window if the player is left of this many columns of pixels
	int right_buffer;		// Move the window if the player is right of this many columns of pixels
	int lifebar_x, lifebar_y;			// What row/column of pixels the lifebar starts at
} WINDOW_TYPE;

typedef struct {			// *** LEVEL TYPE - variables about the level and its data ***
	int width, height;		// Dimensions in tiles of the level
	int type;				// Type of level (side-scrolling, up and down, etc.)
	int number;				// Level number...
	char *title;			// Title of level...
	int **tiles;			// Holds level tile data
} LEVEL_TYPE;

typedef struct {			// *** KEYBOARD KEYS TYPE - holds data about the state of keys ***
	int up_arrow;			// TRUE = previously pressed, FALSE = not
	int down_arrow;
	int left_arrow;
	int right_arrow;
	int esc;
	int lalt;
	int lctrl;
} KEYS_TYPE;

typedef struct {						// *** CELL DATA TYPE ***
	char cell_types[MAX_SPRITES];		// Holds the cell type for each cell
	char num_frames[MAX_SPRITES];		// Holds the number of animation frames for each cell
	int num_sprites;					// Total number of sprites loaded from files
	int animation_counter;				// Determines what frame to draw everything in
	int player_index;					// Sprite index of the player sprite
	int empty_cell_index;				// Sprite index of the empty cell
	int number_small_zero_index;		// Sprite index of the sprite for the small number zero
	int number_big_zero_index;			// Sprite index of the sprite for the big number zero
	int lifebar_icon_index;				// Sprite index of the lifebar icon sprite
	int lifebar_left_index;				// Sprite index of the left end of the lifebar sprite
	int lifebar_middle_index;			// Sprite index of the middle of the lifebar sprite
	int lifebar_right_index;			// Sprite index of the right end of the lifebar sprite
	int o2_icon_index;					// Sprite index of the 02 bar icon
	int bananas_index;					// Sprite index of the bananas sprite
	int apples_index;					// Sprite index of the apples sprite
	int grapes_index;					// Sprite index of the grapes sprite
	int watermelon_index;				// Sprite index of the watermelon sprite
	int coffee_index;					// Sprite index of the coffee sprite
	int heart_index;					// Sprite index of the heart sprite
	int waterfall_index;				// Sprite index of the waterfall sprite
	int water_index;					// Sprite index of the water sprite
	int conveyor_index[6];				// Sprite indices of the conveyor belt sprites
	int spring_index[4];				// Sprite indices of the spring sprites
	int rocksquare_index;				// Sprite index of the "rock diamond square" sprite
	int spikes_index[4];				// Sprite indices of the spikes sprites
	int lava_index[3];					// Sprite index of the lava sprite
	int e_index[2];						// Sprite index of the electricity sprites
	int swim_index;						// Sprite index of the swimming sprite
	int enemy_index[NUM_ENEMY_DATA];	// Sprite index of the enemies sprites
	int switch_block_index;				// Sprite index of the first switch block
	int dotted_outline_index;			// Sprite index of the dotted outline blocks
	int filled_block_index;				// Sprite index of the filled in blocks
	int x_icon_index;					// Sprite index of the X icon for displaying lives
	int bubble_index;					// Sprite index of the bubble that rises while swimming
	int cannon_index;					// Sprite index of the cannon base
	int player_in_cannon_index;			// Sprite index of the player in the cannon
	int smack_index;					// Sprite index of the smack sprite
	int crosshair_angles_index;			// Sprite index of the crosshair angles sprite
	int bomb_index;						// Sprite index of the bomb sprite
	int explosion_index;				// Sprite index of the explosion sprite
	int bomb_powerup_index;				// Sprite index of the bomb power up sprite
	int spring_active[MAX_SPRINGBOARDS];	// TRUE if the spring is sprung; FALSE if not
	int spring_direction[MAX_SPRINGBOARDS];	// Indicates which type of spring
	int spring_x_cell[MAX_SPRINGBOARDS], spring_y_cell[MAX_SPRINGBOARDS];	// Location of spring
	int spring_counter[MAX_SPRINGBOARDS];	// Counts until the next frame
} CELL_DATA_TYPE;

typedef struct {				// *** COLLISION DETECTION DATA TYPE ***
	char num_scanned_cells;		// How many non-empty cells were found (to react to)
	int x_cell[20];				// Where the found cells are in the level (0 to level_width - 1)
	int y_cell[20];				// Where the found cells are in the level (0 to level_width - 1)
	int which_cell[20];			// What the cell indices of the 0-6 detected cells are
	char allow_x_movement, allow_y_movement;		// Set to FALSE or TRUE
} COLLISION_DETECTION_TYPE;

typedef struct {
	int which;					// Which enemy, projectile, etc. to use (will be an array element)
	int width, height;			// Width and height (in pixels) of the object to detect
	int x_cell, y_cell;			// Coordinates of the cell location of the object to detect
	double x_offset, y_offset;	// Coordinates of the location within the cell of the object
	double x_velocity, y_velocity;	// How much to increment x, y_offset each loop
	double x_offset_shift, y_offset_shift;		// How much to shift the future x & y_offset
												// variables after calculation due to conveyor
												// belts, etc.
} COLLISION_INPUT_TYPE;

typedef struct {				// *** ANIMATION TYPE ***
	int active;					// Set to TRUE to make the animation cycle
	int cell_index;				// Inidicates the index of the sprite to start drawing
	int x_cell, y_cell;			// Inidicates the location of the animation
	int prev_x_cell, prev_y_cell;	// Indicates the cell from which the animation originated
	int width, height;			// Width and height of the first sprite of the animation
	int ani_counter;			// Counts every game loop; once reaches frames_delay, resets to 0
	double x_offset, y_offset;		// Indicates the offset in the cell from which the ani orig.
	double prev_x_offset, prev_y_offset;	// Original location of x_offset, y_offset
	double x_velocity, y_velocity;			// How much to increment x, y_offset each loop
	int num_frames;				// Number of sprites to animate
	int cur_frame;				// Which animation frame is currently being shown
	int frames_delay;			// How many game loop iterations to wait in between frames
	int num_iterations;			// How many game loop iterations to wait before the ani ends
	int cur_cyle;				// Which cycle is currently being animated
	int iterations;				// Number of times the animation has existed since its birth
	int tag;					// Assign an anbirtrary integer value to the animation
} ANIMATION_TYPE;


