/*
 * Trek Invaders 0.3A
 *
 * This is the third major release.
 * The purpose is to modularize the project and
 * groom it for porting.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <allegro.h>
#include "trekdefs.h"
#include "trekdat.h"


int main(int argc, char *argv[])
{
   int i,j,k,l,
       a_startx,a_starty,
       a_endx,a_endy,

       star_x,star_y,star_color,
       skyline_x,skyline_y,skyline_x_old,

       MAX_BEAMS, BEAM_RATE,
       MAX_ALIEN_BOMBS, ALIEN_BOMB_RATE,
       ALIEN_MATRIX_XSIZE, ALIEN_MATRIX_YSIZE,

       score, lives, extralife,
       level, level_end, LevelEndCountdown,
       player_dead, PlayerDeadCountdown,
       alien_invade, AlienInvadeCountdown,

       aliens_remaining,
       alien_matrix_x, alien_matrix_y,
       alien_direction,
       alien_bombs_active,
       alien_bomb_x,alien_bomb_y,
       bomb_here,
       alien_advance_counter,
       ALIEN_ADVANCE_RATE,

       /* Particle beams with x,y,status (1=active,0=inactive) */
       beam[MAX_BEAMS_EVER][3],
       beam_timer, beams_active;

   float player_pos, player_speed;

   char alien_matrix[MAX_ALIEN_MATRIX_XSIZE][MAX_ALIEN_MATRIX_YSIZE],
        strbuff[50] = {0};

   AlienBomb alien_bomb[MAX_ALIEN_BOMBS_EVER];

   Explosion explosion[MAX_EXPLOSIONS];
   int expl_counter = 0;

   ScoreSprite score_sprite[MAX_SCORE_SPRITES];
   int score_sprite_counter, score_sprite_timer;


   div_t collide_x,collide_y;

   SAMPLE *shoot_snd,
          *hit_snd[4],
          *dead_snd[5],
          *ship_snd;
   int sound_available,
       hit_snd_counter=0,
       dead_snd_counter=0;

   BITMAP *d_buffer, *background;

   DATAFILE *trek_dat;



   int exitGame;



   allegro_init();
   trek_dat = load_datafile("trekinv.dat");
   install_keyboard();

   if(install_sound(DIGI_AUTODETECT,MIDI_AUTODETECT,argv[0]) == -1) {
      printf("\nSound not available.");
      printf("\nIf you have a sound card, run setup.");
      sound_available = 0;
   }
   else
      sound_available = 1;

   /* Load sounds */
   if(sound_available) {
      shoot_snd = trek_dat[TREK_SOUND_TORPEDO].dat;
      hit_snd[0] = trek_dat[TREK_SOUND_HIT1].dat;
      hit_snd[1] = trek_dat[TREK_SOUND_HIT2].dat;
      hit_snd[2] = trek_dat[TREK_SOUND_HIT3].dat;
      hit_snd[3] = trek_dat[TREK_SOUND_HIT4].dat;
      dead_snd[0] = trek_dat[TREK_SOUND_DEATH1].dat;
      dead_snd[1] = trek_dat[TREK_SOUND_DEATH2].dat;
      dead_snd[2] = trek_dat[TREK_SOUND_DEATH3].dat;
      dead_snd[3] = trek_dat[TREK_SOUND_DEATH4].dat;
      ship_snd = trek_dat[TREK_SOUND_SHIP].dat;

      shoot_snd->priority = 128;
      ship_snd->priority = 255;
      for (i=0; i<4; i++) {
         hit_snd[i]->priority = 128;
         dead_snd[i]->priority = 250;
      }
   }

   /* Initialize the sprite list */
   for(i=0;i<22;i++)
      Sprite[i].status = 0;

   set_color_depth(8);

   request_refresh_rate(60);

   if(set_gfx_mode(GFX_AUTODETECT,320,240,0,0) < 0) {
      allegro_message("Error setting graphics mode (320x240 8bpp)");
      exit(EXIT_FAILURE);
   }
   d_buffer = create_bitmap(320,240);
   background = create_bitmap(320,240);
   
   /* Load sprites */

   Sprite[0].grid = trek_dat[TREK_PLAYER_SHIP].dat;

   Sprite[10].grid = trek_dat[TREK_ENEMY_SHIP1].dat;
   Sprite[11].grid = trek_dat[TREK_ENEMY_SHIP2].dat;
   Sprite[12].grid = trek_dat[TREK_ENEMY_SHIP3].dat;
   Sprite[13].grid = trek_dat[TREK_ENEMY_SHIP4].dat;
   Sprite[14].grid = trek_dat[TREK_ENEMY_SHIP5].dat;
   Sprite[15].grid = Sprite[11].grid;
   Sprite[16].grid = Sprite[13].grid;
   Sprite[17].grid = Sprite[10].grid;
   Sprite[18].grid = Sprite[12].grid;

   Sprite[20].grid = trek_dat[TREK_PLAYER_TORPEDO].dat;
   Sprite[21].grid = trek_dat[TREK_ENEMY_BOMB].dat;

   Sprite[30].grid = trek_dat[TREK_SCORE_150].dat;
   Sprite[31].grid = trek_dat[TREK_SCORE_250].dat;
   Sprite[32].grid = trek_dat[TREK_SCORE_350].dat;
   Sprite[33].grid = trek_dat[TREK_SCORE_450].dat;
   Sprite[34].grid = trek_dat[TREK_SCORE_550].dat;
   Sprite[35].grid = trek_dat[TREK_SCORE_650].dat;
   Sprite[36].grid = trek_dat[TREK_SCORE_750].dat;
   Sprite[37].grid = trek_dat[TREK_SCORE_850].dat;
   Sprite[38].grid = trek_dat[TREK_SCORE_950].dat;

   /* NEW STUFF ADDED JULY 2000 (for the hell of it) */

   do {

      /* Display the title screen */

      set_palette(trek_dat[TITLE_PALETTE].dat);
      blit(trek_dat[TITLE_SCREEN].dat, screen, 0, 0, 0, 0, 320, 240);

      /* Wait for space bar to be pressed */
      exitGame = 0;
      while (!key[KEY_SPACE])
         if (key[KEY_Q]) {
            exitGame = 1;
            break;
         }

      if (exitGame)
         break;
            


      /* Load Palette */
      set_palette(trek_dat[TREK_PAL].dat);

      /* Initialize game */
      level = 1;
      score = 0;
      lives = 3;
      extralife = 0;
      player_dead = 0;
      player_pos = 152;
      player_speed = 0;
      Sprite[0].y = 208;
      Sprite[0].status = 1;
      alien_invade = 0;
      AlienInvadeCountdown = 200;

      score_sprite_timer = 0;
      score_sprite_counter = 0;
      for(i=0; i<MAX_SCORE_SPRITES; i++)
         score_sprite[i].progress = 0;

      /* Play the good old background sound */
      if(sound_available)
         play_sample(ship_snd,128,128,1000,1);

      // Do the game
      do
      {
         // Initialize level
         ALIEN_MATRIX_XSIZE = 10;
         ALIEN_MATRIX_YSIZE = 7;

         for(j=0; j<ALIEN_MATRIX_XSIZE; j++)
               for(k=0; k<ALIEN_MATRIX_YSIZE; k++)
               alien_matrix[j][k] = 1;

         alien_matrix_x = 0;
         alien_matrix_y = 8;
         alien_direction = RIGHT;
         aliens_remaining = ALIEN_MATRIX_XSIZE*ALIEN_MATRIX_YSIZE;
         alien_bombs_active = 0;

         ALIEN_BOMB_RATE = 20;
         MAX_ALIEN_BOMBS = MAX_ALIEN_BOMBS_EVER;
         for(j=0; j<MAX_ALIEN_BOMBS; j++)
            alien_bomb[j].status = 0;

         alien_advance_counter = 0;
         ALIEN_ADVANCE_RATE = 50;

         /* Initialize particle beam */
         MAX_BEAMS = 3;
         BEAM_RATE = 10;
         beam_timer = 20;
         for(j=0; j<MAX_BEAMS; j++)
            for(k=0; k<3; k++)
               beam[j][k] = 0;

         /* Initialize explosions */
         expl_counter = 0;
         for(j=0; j<MAX_EXPLOSIONS; j++)
         {
            explosion[j].progress = 0;
            explosion[j].n = 0;
         }
         /* Draw the background */

         clear(background);

         for(j=0; j<MAX_STARS; j++)
         {
            star_x = random_int(0,319);
            star_y = random_int(0,223);
            star_color = random_int(81,95);
            putpixel(background,star_x,star_y,star_color);
         }

         for(j=0; j<sunset_lines; j++)
            hline(background,0,223-j,319,sunset[j]);

         skyline_x = 0;
         while(skyline_x < 320)
         {

            skyline_x_old = skyline_x;
            skyline_x += random_int(2,4);
            skyline_y = random_int((skyline_x-skyline_x_old)*1.5,
                                   (skyline_x-skyline_x_old)*1.5+
                                    random_int(0,8));

            rectfill(background,skyline_x_old,224-skyline_y,skyline_x,223,0);

            skyline_x += random_int(1,2);
         }

         player_dead = 0;
         PlayerDeadCountdown = 200;
         level_end = 0;
         LevelEndCountdown = 200;

         // Do a level
         do
         {
            // Handle fire
            if(!player_dead && !alien_invade)
            {
               if(key[KEY_SPACE] && beam_timer>=20-BEAM_RATE && !level_end)
               {
                  // Check for available particle beam
                  beams_active = 0;
                  for(j=0; j<MAX_BEAMS; j++)
                     if(beam[j][2])
                        beams_active++;

                  if(beams_active < MAX_BEAMS)
                  {
                     j = 0;
                     while(beam[j][2])
                        j++;

                     // Initialize beam
                     beam[j][2] = 1; // Status = active
                     beam[j][0] = player_pos+5;
                     beam[j][1] = 207;
                     beam_timer = 0;

                     if(sound_available)
                        play_sample(shoot_snd,192,128,1000,0);
                  }
               }
               // Handle left/right movement
               if(key[KEY_LEFT] && player_speed > -3)
                  player_speed -= PLAYER_ACCEL;
               else
                  if(player_speed < 0)
                  {
                     player_speed += PLAYER_ACCEL;
                     if(player_speed > 0)
                        player_speed = 0;
                  }
               if(key[KEY_RIGHT] && player_speed < 3)
                  player_speed += PLAYER_ACCEL;
               else
                  if(player_speed > 0)
                  {
                     player_speed -= PLAYER_ACCEL;
                     if(player_speed < 0)
                        player_speed = 0;
                  }

               player_pos += player_speed;
               if(player_pos < 0)
               {
                  player_pos = 0;
                  player_speed = 0;
               }
               else if(player_pos > 305)
               {
                  player_pos = 305;
                  player_speed = 0;
               }
            }

            /* Update particle beam */
            for(j=0;j<MAX_BEAMS;j++)
            {
               if(beam[j][2])
               {
                  beam[j][1] -= 3;
                  if(beam[j][1] < -16)
                     beam[j][2] = 0;
               }
            }

            /* Update aliens */
            if(!level_end && !alien_invade)
               {
               GetMatrixDim(alien_matrix, ALIEN_MATRIX_XSIZE, ALIEN_MATRIX_YSIZE,
                            &a_startx,&a_starty,&a_endx,&a_endy);

               if(alien_advance_counter == (100-ALIEN_ADVANCE_RATE))
               {
                  if(alien_direction == RIGHT)
                  {
                     if(alien_matrix_x + (ALIEN_GAP+16)*a_endx < 300)
                        alien_matrix_x += (ALIEN_GAP+16)/2;
                     else
                     {
                        alien_matrix_y += ALIEN_GAP+16;
                        alien_direction = LEFT;
                     }
                  }
                  else if(alien_direction == LEFT)
                  {
                     if(alien_matrix_x + (ALIEN_GAP+16)*a_startx > 5)
                        alien_matrix_x -= (ALIEN_GAP+16)/2;
                     else
                     {
                        alien_matrix_y += ALIEN_GAP+16;
                        alien_direction = RIGHT;
                     }
                  }
                  alien_advance_counter = 0;
               }

               /* Make an alien fire */
               if(PlayerDeadCountdown > 120)
               {
                  alien_bombs_active = 0;
                  for(j=0; j<MAX_ALIEN_BOMBS; j++)
                     if(alien_bomb[j].status)
                        alien_bombs_active++;

                  if(random_int(0,(100-ALIEN_BOMB_RATE)) == 0 && alien_bombs_active < MAX_ALIEN_BOMBS)
                  {
                     /* Set a random starting position */
                     bomb_here = 0;
                     do
                     {
                        alien_bomb_x = random_int(0,ALIEN_MATRIX_XSIZE-1);
   
                        alien_bomb_y = ALIEN_MATRIX_YSIZE-1;
                        while(alien_bomb_y >= 0 && (!bomb_here))
                        {
                           if(alien_matrix[alien_bomb_x][alien_bomb_y])
                              bomb_here = 1;
                           else
                              alien_bomb_y--;
                        }
                     }
                     while(!bomb_here);

                     /* Activate and initialize bomb */
                     j=0;
                     while(alien_bomb[j].status)
                        j++;

                     alien_bomb[j].x = alien_matrix_x+alien_bomb_x*(ALIEN_GAP+16)+6;
                     alien_bomb[j].y = alien_matrix_y+alien_bomb_y*(ALIEN_GAP+16)+5;
                     alien_bomb[j].speed = 0;
                     alien_bomb[j].status = 1;
                  }
               }
               if(alien_matrix_y + (ALIEN_GAP+16)*a_endy > 200)
               {
                  alien_invade = 1;
                  StartExplosion(Sprite[0].grid,Sprite[0].x,Sprite[0].y,1,
                                 explosion,&expl_counter);
               }
            }

            /* Update alien bombs */
            for(j=0; j<MAX_ALIEN_BOMBS; j++)
               if(alien_bomb[j].status)
               {
                  alien_bomb[j].y += alien_bomb[j].speed;
                  alien_bomb[j].speed += GRAVITY*2;
                  if(alien_bomb[j].y >= 220)
                  {
                     alien_bomb[j].status = 0;
                     StartExplosion(Sprite[21].grid,
                                    alien_bomb[j].x, alien_bomb[j].y,0,
                                    explosion, &expl_counter);
                  }
                  else
                     /* Check if bomb has hit the player */
                     if(!player_dead &&
                        alien_bomb[j].x+2 >= player_pos &&
                        alien_bomb[j].x <= player_pos+13 &&
                        alien_bomb[j].y > 200)
                     {
                        alien_bomb[j].status = 0;
                        player_dead = 1;
                        lives--;
                        StartExplosion(Sprite[0].grid,Sprite[0].x,Sprite[0].y,1,
                                       explosion, &expl_counter);
                        if(sound_available)
                        {
                           play_sample(dead_snd[dead_snd_counter],255,128,1000,0);
                           dead_snd_counter++;
                           if(dead_snd_counter == 4)
                              dead_snd_counter = 0;
                        }
                     }
               }

            /* Collission detection: particle beam to alien */

            /* Check through every active particle beam */
            if(!level_end)
               for(j=0; j<MAX_BEAMS; j++)
                  if(beam[j][2])
                  {
                     /* First, check if particle beam is in range */
                     if(beam[j][0]+2 >= alien_matrix_x+(ALIEN_GAP+16)*a_startx &&
                        beam[j][0]   < alien_matrix_x+(ALIEN_GAP+16)*a_endx+15 &&
                        beam[j][1]+6 >= alien_matrix_y+(ALIEN_GAP+16)*a_starty &&
                        beam[j][1]   < alien_matrix_y+(ALIEN_GAP+16)*a_endy+15)
                     {
                        collide_x = div(beam[j][0]-alien_matrix_x+2,ALIEN_GAP+16);
                        collide_y = div(beam[j][1]-alien_matrix_y+6,ALIEN_GAP+16);

                        if(collide_x.quot >= 0 && collide_y.quot >= 0 &&
                           collide_x.quot < ALIEN_MATRIX_XSIZE &&
                           collide_y.quot < ALIEN_MATRIX_YSIZE &&
                           collide_x.rem < 17)
                        {
                           if(alien_matrix[collide_x.quot][collide_y.quot])
                           {
                              score_sprite[score_sprite_counter].progress = 30;
                              score_sprite[score_sprite_counter].index = 29;
                              score_sprite[score_sprite_counter].x = alien_matrix_x+collide_x.quot*(ALIEN_GAP+16);
                              score_sprite[score_sprite_counter].y = alien_matrix_y+collide_y.quot*(ALIEN_GAP+16);

                              if(rand()%2)
                                 score_sprite[score_sprite_counter].xspeed = 1;
                              else
                                 score_sprite[score_sprite_counter].xspeed = -1;

                              if(rand()%2)
                                 score_sprite[score_sprite_counter].yspeed = 1;
                              else
                                 score_sprite[score_sprite_counter].yspeed = -1;

                              score += 50;
                              k = ALIEN_MATRIX_YSIZE-1;
                              while(k>=collide_y.quot)
                              {

                                 if(alien_matrix[collide_x.quot][k])
                                 {
                                    score += 100;
                                    score_sprite[score_sprite_counter].index++;
                                    score_sprite[score_sprite_counter].progress+=20;
                                 }
                                 k--;
                              }
                              if(score-extralife*100000 > 100000)
                              {
                                 lives++;
                                 extralife++;
                              }
                              score_sprite_counter++;
                              if(score_sprite_counter == MAX_SCORE_SPRITES)
                                 score_sprite_counter = 0;

                              alien_matrix[collide_x.quot][collide_y.quot] = 0;
                              aliens_remaining--;
                              if(sound_available)
                              {
                                 play_sample(hit_snd[hit_snd_counter],192,128,750,0);
                                 hit_snd_counter++;
                                 if(hit_snd_counter == 4)
                                    hit_snd_counter = 0;
                              }

                              if(aliens_remaining == 1)
                              {
                                 alien_advance_counter = 0;
                                 if(level <= 8)
                                    ALIEN_ADVANCE_RATE = 90;
                                 else if(level <= 16)
                                    ALIEN_ADVANCE_RATE = 92;
                                 else if(level <= 24)
                                    ALIEN_ADVANCE_RATE = 94;
                                 else if(level <= 32)
                                    ALIEN_ADVANCE_RATE = 96;
                                 else
                                    ALIEN_ADVANCE_RATE = 98;
                              }
                              else if(aliens_remaining == 2)
                              {
                                 alien_advance_counter = 0;
                                 if(level <= 8)
                                    ALIEN_ADVANCE_RATE = 80;
                                 else if(level <= 16)
                                    ALIEN_ADVANCE_RATE = 82;
                                 else if(level <= 24)
                                    ALIEN_ADVANCE_RATE = 84;
                                 else if(level <= 32)
                                    ALIEN_ADVANCE_RATE = 86;
                                 else
                                    ALIEN_ADVANCE_RATE = 88;
                              }
                              else if(aliens_remaining == 5)
                              {
                                 alien_advance_counter = 0;
                                 if(level <= 8)
                                    ALIEN_ADVANCE_RATE = 75;
                                 else if(level <= 16)
                                    ALIEN_ADVANCE_RATE = 77;
                                 else if(level <= 24)
                                    ALIEN_ADVANCE_RATE = 79;
                                 else if(level <= 32)
                                    ALIEN_ADVANCE_RATE = 81;
                                 else
                                    ALIEN_ADVANCE_RATE = 83;
                              }
                              else if(aliens_remaining == 10)
                              {
                                 alien_advance_counter = 0;
                                 if(level <= 8)
                                    ALIEN_ADVANCE_RATE = 66;
                                 else if(level <= 16)
                                    ALIEN_ADVANCE_RATE = 68;
                                 else if(level <= 24)
                                    ALIEN_ADVANCE_RATE = 70;
                                 else if(level <= 32)
                                    ALIEN_ADVANCE_RATE = 72;
                                 else
                                    ALIEN_ADVANCE_RATE = 74;
                              }

                              if(!aliens_remaining)
                                    level_end = 1;

                              beam[j][2] = 0;
                              StartExplosion(Sprite[10+collide_y.quot].grid,
                                 alien_matrix_x+(ALIEN_GAP+16)*collide_x.quot,
                                 alien_matrix_y+(ALIEN_GAP+16)*collide_y.quot,0,
                                 explosion, &expl_counter);
                           }
                        }
                     }
                  }
   
            // Draw everything here
            Sprite[0].x = player_pos;

            blit(background,d_buffer,0,0,0,0,320,240);

            sprintf(strbuff,"Lives: %d  Level: %d  Score: %d",lives,level,score);
            text_mode(0);
            textout(d_buffer,font,strbuff,0,228,7);

            /* Draw particle beams */
            for(j=0; j<MAX_BEAMS; j++)
               if(beam[j][2])
                  draw_sprite(d_buffer,Sprite[20].grid,beam[j][0],beam[j][1]);

            /* Draw alien bombs */
            for(j=0; j<MAX_ALIEN_BOMBS; j++)
               if(alien_bomb[j].status)
                  draw_sprite(d_buffer,Sprite[21].grid,alien_bomb[j].x,alien_bomb[j].y);

            /* Draw aliens */
            for(j=0; j<ALIEN_MATRIX_XSIZE; j++)
               for(k=0; k<ALIEN_MATRIX_YSIZE; k++)
                  if(alien_matrix[j][k])
                     draw_sprite(d_buffer,Sprite[10+k].grid,
                                 alien_matrix_x + (ALIEN_GAP+16)*j,
                                 alien_matrix_y + (ALIEN_GAP+16)*k);

            /* Draw player ship */
            if(!player_dead && !alien_invade)
               draw_sprite(d_buffer,Sprite[0].grid,Sprite[0].x,Sprite[0].y);

            /* Update and draw explosions */
            /* Check through every active explosion */
            for(j=0; j<MAX_EXPLOSIONS; j++)
            {
               if(explosion[j].progress)
               {
                  for(k=0; k<explosion[j].n; k++)
                  {
                     if(explosion[j].x[k] >= 0 &&
                        explosion[j].x[k] < 320 &&
                        explosion[j].y[k] >=0 &&
                        explosion[j].y[k] < 224)
                     {
                        d_buffer->line[(int)(explosion[j].y[k])][(int)(explosion[j].x[k])] =
                                                          (int)explosion[j].color;
                        explosion[j].x[k] += explosion[j].xspeed[k];
                        explosion[j].y[k] += explosion[j].yspeed[k];
                        explosion[j].xspeed[k] *= EXP_SLOWDOWN;
                        explosion[j].yspeed[k] += GRAVITY;
                     }
                  }
                  explosion[j].progress--;
                  explosion[j].color -= 0.06;
               }
            }

            /* Update and draw score sprites */
            for(j=0; j<MAX_SCORE_SPRITES; j++)
               if(score_sprite[j].progress)
               {
                  draw_sprite(d_buffer,Sprite[score_sprite[j].index].grid,
                             score_sprite[j].x,score_sprite[j].y);

                  score_sprite[j].progress--;
               }

            if(score_sprite_timer == 15)
               for(j=0; j<MAX_SCORE_SPRITES; j++)
               {
                  score_sprite[j].x += score_sprite[j].xspeed;
                  if(score_sprite[j].x <= 0 || score_sprite[j].x+11 >= 320)
                     score_sprite[j].xspeed = -score_sprite[j].xspeed;

                  score_sprite[j].y += score_sprite[j].yspeed;
                  if(score_sprite[j].y <=0 || score_sprite[j].y+5 >= 224)
                     score_sprite[j].yspeed = -score_sprite[j].yspeed;

                  score_sprite_timer = 0;
               }

            vsync();
            blit(d_buffer,screen,0,0,0,0,320,240);

            /* Screen dump */
            if (key[KEY_F10])
               save_bitmap("dump.bmp", d_buffer, trek_dat[TREK_PAL].dat);

            alien_advance_counter++;
            beam_timer++;
            score_sprite_timer++;

            if(player_dead)
            {
               PlayerDeadCountdown--;

               if(!PlayerDeadCountdown && lives)
               {
                  //Initialize player
                  player_dead = 0;
                  player_pos = 152;
                  player_speed = 0;
                  Sprite[0].y = 208;
                  Sprite[0].status = 1;
                  PlayerDeadCountdown = 200;
               }
            }

            if(level_end)
            {
               LevelEndCountdown--;
               if(!LevelEndCountdown)
               {
                  level++;

                  // Initialize level
                  if(level < 5)
                  {
                     ALIEN_MATRIX_XSIZE = 10;
                     ALIEN_MATRIX_YSIZE = 7;
                  }
                  else if(level < 10)
                  {
                     ALIEN_MATRIX_XSIZE = 11;
                     ALIEN_MATRIX_YSIZE = 7;
                  }
                  else if(level < 15)
                  {
                     ALIEN_MATRIX_XSIZE = 11;
                     ALIEN_MATRIX_YSIZE = 8;
                  }
                  else if(level < 20)
                  {
                     BEAM_RATE = 12;
                     MAX_BEAMS = 4;
                     ALIEN_MATRIX_XSIZE = 12;
                     ALIEN_MATRIX_YSIZE = 8;
                  }
                  else if(level < 25)
                  {
                     BEAM_RATE = 14;
                     MAX_BEAMS = 5;
                     ALIEN_MATRIX_XSIZE = 12;
                     ALIEN_MATRIX_YSIZE = 9;
                  }
                  else
                  {
                     BEAM_RATE = 16;
                     MAX_BEAMS = 6;
                     ALIEN_MATRIX_XSIZE = 13;
                     ALIEN_MATRIX_YSIZE = 9;
                  }

                  for(j=0; j<ALIEN_MATRIX_XSIZE; j++)
                     for(k=0; k<ALIEN_MATRIX_YSIZE; k++)
                        alien_matrix[j][k] = 1;

                  alien_advance_counter = 0;
                  if(level <= 8)
                     ALIEN_ADVANCE_RATE = 50;
                  else if(level <= 16)
                     ALIEN_ADVANCE_RATE = 54;
                  else if(level <= 24)
                     ALIEN_ADVANCE_RATE = 58;
                  else if(level <= 32)
                     ALIEN_ADVANCE_RATE = 62;
                  else
                     ALIEN_ADVANCE_RATE = 66;

                  alien_matrix_x = 0;
                  alien_matrix_y = 8;
                  alien_direction = RIGHT;
                  aliens_remaining = ALIEN_MATRIX_XSIZE*ALIEN_MATRIX_YSIZE;
                  level_end = 0;
                  LevelEndCountdown = 200;
               }
            }
            if(alien_invade)
               AlienInvadeCountdown--;
         }
         while(LevelEndCountdown && PlayerDeadCountdown && AlienInvadeCountdown
               && !key[KEY_ESC] && score < 1000000);
      }
      while(AlienInvadeCountdown && lives && !key[KEY_ESC] && score < 1000000);

      stop_sample(ship_snd);

      if(score >= 1000000)
         // Insert victory routine here.
         ;
      else
         // Insert mission failed routine here.
         ;

   }
   while (1);

   unload_datafile(trek_dat);

   return 0;
}

END_OF_MAIN()

void GetMatrixDim(char matrix[MAX_ALIEN_MATRIX_XSIZE]
                             [MAX_ALIEN_MATRIX_YSIZE],
                  int mat_x, int mat_y,
                  int *startx,int *starty,int *endx,int *endy)
{
   int i,j;

   *startx = 9;
   *starty = 6;
   *endx = 0;
   *endy = 0;

   for(i=0; i<mat_y; i++)

      for(j=0; j<mat_x; j++)

         if(matrix[j][i] == 1)
         {
            if(j < *startx)
               *startx = j;
            if(j > *endx)
               *endx = j;
         }

   for(i=0; i<mat_x; i++)

      for(j=0; j<mat_y; j++)

         if(matrix[i][j] == 1)
         {
            if(j < *starty)
               *starty = j;
            if(j > *endy)
               *endy = j;
         }
}

void StartExplosion(BITMAP *b,int x,int y,int is_player,
                    Explosion *explosion, int *counter)
{
   int i,j,rand_color;
   int n;

   if(is_player)
      n = MAX_EXPLOSIONS - 1;
   else
      n = *counter;

   explosion[n].n = 0;
   explosion[n].progress = 240;

   rand_color = rand()%8;
   switch(rand_color) {
      case(0): {
         explosion[n].color = 31;
         break;
      }
      case(1):
      case(2): {
         explosion[n].color = 47;
         break;
      }
      case(3):
      case(4): {
         explosion[n].color = 63;
         break;
      }
      case(5): {
         explosion[n].color = 79;
         break;
      }
      case(6):
      case(7): {
         explosion[n].color = 95;
         // break;
      }
   }

   for(i=0; i<(b->w); i++)
      for(j=0; j<(b->h); j++) {
         if(b->line[j][i] && ((rand()%4) == 3)) {
            explosion[n].x[explosion[n].n]=i+x;
            explosion[n].y[explosion[n].n]=j+y;
            explosion[n].xspeed[explosion[n].n] = (i-b->w/2)*0.25;
            explosion[n].yspeed[explosion[n].n] = (j-b->h/2)*0.25;
            explosion[n].n++;
         }
      }
   (*counter)++;
   if((*counter) == MAX_EXPLOSIONS-1)
      (*counter) = 0;
}

int random_int(int from,int to)
{
   return rand()%(to-from+1)+from;
}
