/*
 * trekdefs.h
 *
 * Part of Trek Invaders 0.3A
 *
 */


#define MAX_STARS 50
#define MAX_EXPLOSIONS 50
#define PLAYER_ACCEL 0.2
#define EXP_SLOWDOWN 0.999
#define GRAVITY 0.015
#define ALIEN_GAP 4

#define sunset_lines 51
unsigned char sunset[51] = {135,133,131,129,113,115,117,119,121,123,125,127,
                             62, 61, 60, 59, 58, 57, 57, 56, 56, 55, 55,
                             54, 54, 54, 53, 53, 53, 52, 52, 52, 52,
                             51, 51, 51, 51, 51, 50, 50, 50, 50, 50, 50,
                             49, 49, 49, 49, 49, 49, 49};

/* Some gameplay constants */
#define MAX_BEAMS_EVER 50
#define MAX_ALIEN_BOMBS_EVER 40
#define MAX_ALIEN_MATRIX_XSIZE 13
#define MAX_ALIEN_MATRIX_YSIZE 9

typedef struct AlienBomb
{
   float x,y;
   float speed;

   int status;
} AlienBomb;

#define LEFT -1
#define RIGHT 1

/* Used by sprite engine to draw sprites */
typedef struct sprite_list
{
   BITMAP *grid;

   int x,y,
       x_size,y_size;

   int status;             /* 1=active,0=inactive */
} sprite_list;

sprite_list Sprite[40];

typedef struct Explosion
{
   float color;

   float x[256],xspeed[256],
         y[256],yspeed[256];

   int n; /* Amount of pieces */

   int progress; /* 0 = inactive */
} Explosion;

typedef struct ScoreSprite
{
   int index;
   int x,y,xspeed,yspeed;

   int progress;
}ScoreSprite;

#define MAX_SCORE_SPRITES 50

void DrawSprites();
void GetSpriteSize(char *,int *,int *);
void GetMatrixDim(char matrix[MAX_ALIEN_MATRIX_XSIZE]
                             [MAX_ALIEN_MATRIX_YSIZE],
                             int, int, int *,int *,int *,int *);
void StartExplosion(BITMAP *,int,int,int,Explosion *,int *);
int random_int(int,int);
