#define about "Incendi V. 1.0 - (c) 2000 By: R.A."

BITMAP *page; // Pagine grafiche
BITMAP *aux;  // Virtuali
int P_Alb,P_Inc,P_Ter; // Provabilita'
int Dx,Dy; // Dimensioni area grafica
int tipo,vento;

char *lista1(int index, int *list_size) // Funzioni per le finestre di selezione a lista
 {
  static char *strings[]={"Von Neumman","Moore r=1","Moore r=2","Vento"};

  if(index<0) 
   {
    *list_size=4;
    return NULL;
   }
  else return strings[index]; 
 }

char *lista2(int index, int *list_size)
 {
  static char *strings[]={"Est","Ovest","Nord","Sud"};

  if(index<0) 
   {
    *list_size=4;
    return NULL;
   }
  else return strings[index]; 
 }

DIALOG gui[]={ // Definizioni dell'interfaccia
              { d_clear_proc,   0,   0,   0,   0, 255,  0,   0,      0, 0, 0,          NULL, NULL, NULL},
              {  d_text_proc,  10,  10, 100,  10, 255,  0,   0,      0, 0, 0, "Alberi:  1/", NULL, NULL},
              {  d_edit_proc, 100,  10,  48,  10, 255,  2,   0,      0, 5, 0,       "100  ", NULL, NULL},
              {  d_text_proc,  10,  30, 100,  10, 255,  0,   0,      0, 0, 0, "Incendi: 1/", NULL, NULL},
              {  d_edit_proc, 100,  30,  48,  10, 255,  2,   0,      0, 5, 0,       "50000", NULL, NULL},
              {  d_text_proc,  10,  50, 100,  10, 255,  0,   0,      0, 0, 0, "Terra:   1/", NULL, NULL},
              {  d_edit_proc, 100,  50,  48,  10, 255,  2,   0,      0, 5, 0,       "1000 ", NULL, NULL},
              {  d_text_proc, 170,  10, 100,  10, 255,  0,   0,      0, 0, 0,          "X:", NULL, NULL},
              {  d_edit_proc, 190,  10,  32,  10, 255,  2,   0,      0, 3, 0,         "318", NULL, NULL},
              {  d_text_proc, 170,  30, 100,  10, 255,  0,   0,      0, 0, 0,          "Y:", NULL, NULL},
              {  d_edit_proc, 190,  30,  32,  10, 255,  2,   0,      0, 3, 0,         "150", NULL, NULL},
              {  d_text_proc,  10,  70, 100,  10, 255,  0,   0,      0, 0, 0,  "Algoritmo:", NULL, NULL},
              {  d_list_proc,  10,  80, 100,  40, 255,  0,   0,      0, 0, 0,        lista1, NULL, NULL},
              {  d_text_proc, 120,  70, 100,  10, 255,  0,   0,      0, 0, 0,      "Vento:", NULL, NULL},
              {  d_list_proc, 120,  80, 100,  40, 255,  0,   0,      0, 0, 0,        lista2, NULL, NULL},
              {d_button_proc,  20, 160,  50,  15, 225,  0,   0, D_EXIT, 0, 0,          "Go", NULL, NULL},
              {d_button_proc, 120, 160,  50,  15, 225,  0,   0, D_EXIT, 0, 0,        "Exit", NULL, NULL},
              {  d_text_proc,  10, 190, 100,  10,  20,  0,   0,      0, 0, 0,         about, NULL, NULL},
              {         NULL,   0,   0,   0,   0,   0,  0,   0,      0, 0, 0,          NULL, NULL, NULL}
             };

void Inizia()
 {
  allegro_init(); // Inizializza la libreria
  install_keyboard(); // Consente l'uso della tastiera
  install_mouse(); // del mouse
  install_timer(); // serve anche questo per il mouse
  if(set_gfx_mode(GFX_AUTODETECT,320,200,0,0)!=0) // Apre uno schermo 320x200x256
   {
    allegro_exit(); // Esce se lo schermo non e' stato aperto correttamente
    printf("Errore nella modalit video:\n -> %s\n\n",allegro_error);
   }
 }

int Prob(int x) // Genera una provabilita' 1/x
 {
  int n;
  
  n=rand()%x;
  return n;
 }

void Esci()
 {
  destroy_bitmap(page); // Libera la memoria
  destroy_bitmap(aux);
 }

void Tabella()
 { 
  RGB nero   = {0 ,0 ,0 }; // Definisce i colori
  RGB bianco = {63,63,63};
  RGB grigio = {32,32,32};
  RGB verde  = {0 ,56,0 };
  RGB rosso  = {63,0 ,0 };
  RGB terra  = {58,35,12};
  RGB azzurro= {0 ,63,63};
  RGB arso   = {25,11,3 };

  set_color(0,&nero); // Assegna i colori
  set_color(1,&bianco);
  set_color(2,&grigio);
  set_color(3,&verde);
  set_color(4,&rosso);
  set_color(5,&terra);
  set_color(6,&azzurro);
  set_color(7,&arso);
  clear_to_color(screen,0); // Cancella lo schermo
  rect(screen,0,0,Dx+1,Dy+1,1); // Disegna il layout
  rectfill(screen,1,1,Dx,Dy,5);
  rectfill(screen,5,160,5+2,160+2,3);
  textout(screen,font,"Alberi",12,158,2);
  rectfill(screen,5,170,5+2,170+2,4);
  textout(screen,font,"Incendi",12,168,2);
  rectfill(screen,5,180,5+2,180+2,7);
  textout(screen,font,"Carbone",12,178,2);
  rectfill(screen,5,190,5+2,190+2,5);
  textout(screen,font,"Terra",12,188,2);
  if(tipo==3)
   {
    if(vento==0) textout(screen,font,"Vento: <-",170,168,2);
    if(vento==1) textout(screen,font,"Vento: ->",170,168,2);
    if(vento==2) textout(screen,font,"Vento: \\/",170,168,2);
    if(vento==3) textout(screen,font,"Vento: /\\",170,168,2);
   }
  textout(screen,font,"ESC torna al menu'",170,188,12);
  page=create_bitmap(Dx,Dy); // Alloca la memoria per i 2 schermi virtuali
  aux=create_bitmap(Dx,Dy);  
  clear_to_color(page,5);
  clear_keybuf(); // Pulisce il buffer della tastiera
 }

int Gui()
 {
  int ret;

  set_pallete(desktop_pallete); // Usa i colori di default
  clear_keybuf();
  ret=do_dialog(gui,13); // Crea l'interfaccia a pulsanti 
  P_Alb=atoi(gui[2].dp); // Prende i dati dall'interfaccia
  P_Inc=atoi(gui[4].dp);
  P_Ter=atoi(gui[6].dp);
  Dx=atoi(gui[8].dp);
  Dy=atoi(gui[10].dp); 
  tipo=gui[12].d1;
  vento=gui[14].d1;
  if(ret==16) alert("Incendi V.1.0", "(c) 2000 - R.A. -", "Per Simulazione", "OK", NULL, 0, 0); // Stampa un avviso
  return ret;
 }

void Automa()
 {
  int x,y;
 
  draw_sprite(screen,page,1,1); // Copia lo schermo virtuale sul monitor
  draw_sprite(aux,page,0,0); // Copia il primo schermo virtuale sul secondo (leggeremo sul primo "aux" e scriveremo sul secondo "page")
  for(x=0;x<=Dx;x++) // Per ogni pixel
   for(y=0;y<=Dy;y++)
    {     
     if(getpixel(aux,x,y)==3 && !Prob(P_Inc)) putpixel(page,x,y,4); // Se il pixel e' verde diventa rosso  
     if(getpixel(aux,x,y)==5 && !Prob(P_Alb)) putpixel(page,x,y,3); // Se il pixel e' terra diventa verde
     if(getpixel(aux,x,y)==7 && !Prob(P_Ter)) putpixel(page,x,y,5); // Se il pixel e' arso diventa terra 
     if(tipo==0) // Von Neumman
      {
       if(getpixel(aux,x,y)==4) putpixel(page,x,y,7); // Se il pixel e' rosso, si brucia
       if(getpixel(aux,x,y)==3) // intorno a croce
        {
         if(getpixel(aux,x-1,y)==4 || getpixel(aux,x+1,y)==4 ||
            getpixel(aux,x,y-1)==4 || getpixel(aux,x,y+1)==4) putpixel(page,x,y,4);
        }
      }
     if(tipo==1) // Moore r=1
      {
       if(getpixel(aux,x,y)==4) putpixel(page,x,y,7); // Se il pixel e' rosso, si brucia
       if(getpixel(aux,x,y)==3) // Intorno a quadrato r=1
        {
         if(getpixel(aux,x-1,y)==4   || getpixel(aux,x+1,y)==4   ||
            getpixel(aux,x,y-1)==4   || getpixel(aux,x,y+1)==4   ||
            getpixel(aux,x-1,y-1)==4 || getpixel(aux,x+1,y+1)==4 ||
            getpixel(aux,x+1,y-1)==4 || getpixel(aux,x-1,y+1)==4) putpixel(page,x,y,4);
        }
      }
     if(tipo==2) // Moore r=2
      {
       if(getpixel(aux,x,y)==4) putpixel(page,x,y,7); // Se il pixel e' rosso, si brucia
       if(getpixel(aux,x,y)==3) // Intorno a quadrato r=2
        {
         if(getpixel(aux,x-1,y)==4   || getpixel(aux,x+1,y)==4   ||
            getpixel(aux,x,y-1)==4   || getpixel(aux,x,y+1)==4   ||
            getpixel(aux,x-1,y-1)==4 || getpixel(aux,x+1,y+1)==4 ||
            getpixel(aux,x-1,y+1)==4 || getpixel(aux,x+1,y-1)==4 ||
            getpixel(aux,x-2,y-2)==4 || getpixel(aux,x-1,y-2)==4 ||
            getpixel(aux,x,y-2)==4   || getpixel(aux,x+1,y-2)==4 ||
            getpixel(aux,x+2,y-2)==4 || getpixel(aux,x-2,y-1)==4 ||
            getpixel(aux,x+2,y-1)==4 || getpixel(aux,x-2,y)==4   ||
            getpixel(aux,x+2,y)==4   || getpixel(aux,x-2,y+1)==4 ||
            getpixel(aux,x+2,y+1)==4 || getpixel(aux,x-2,y+2)==4 ||
            getpixel(aux,x-1,y-2)==4 || getpixel(aux,x,y-2)==4   ||
            getpixel(aux,x+1,y-2)==4 || getpixel(aux,x+2,y-2)==4) putpixel(page,x,y,4);
        }
      }
     if(tipo==3) // Vento
      {
       if(getpixel(aux,x,y)==4) putpixel(page,x,y,7); // Se il pixel e' rosso, si brucia
       if(getpixel(aux,x,y)==3)
        {
         if(vento==0) // direzioni del vento
          { 
           if(getpixel(aux,x+1,y)==4) putpixel(page,x,y,4); // Un pixel verde si incendia in base alla direzione del vento con provabilita' alta se il pixel e' vicino al fuoco altrimenti con provabilita' bassa il tutto in un triangolo di altezza 3
           if((getpixel(aux,x+1,y+1)==4 || getpixel(aux,x+1,y-1)==4) && !Prob(2)) putpixel(page,x,y,4);         
           if(getpixel(aux,x+2,y)==4 && !Prob(2)) putpixel(page,x,y,4);         
           if((getpixel(aux,x+2,y+1)==4 || getpixel(aux,x+2,y-1)==4) && !Prob(4)) putpixel(page,x,y,4);         
           if((getpixel(aux,x+2,y+2)==4 || getpixel(aux,x+2,y-2)==4) && !Prob(8)) putpixel(page,x,y,4);         
           if((getpixel(aux,x+3,y+1)==4 || getpixel(aux,x+3,y-1)==4) && !Prob(8)) putpixel(page,x,y,4);         
           if((getpixel(aux,x+3,y+2)==4 || getpixel(aux,x+3,y-2)==4) && !Prob(16)) putpixel(page,x,y,4);         
           if((getpixel(aux,x+3,y+3)==4 || getpixel(aux,x+3,y-3)==4) && !Prob(32)) putpixel(page,x,y,4);         
           if(getpixel(aux,x+3,y)==4 && !Prob(4)) putpixel(page,x,y,4);         
          }
         if(vento==1)
          {  
           if(getpixel(aux,x-1,y)==4) putpixel(page,x,y,4);
           if((getpixel(aux,x-1,y+1)==4 || getpixel(aux,x-1,y-1)==4) && !Prob(2)) putpixel(page,x,y,4);         
           if(getpixel(aux,x-2,y)==4 && !Prob(2)) putpixel(page,x,y,4);         
           if((getpixel(aux,x-2,y+1)==4 || getpixel(aux,x-2,y-1)==4) && !Prob(4)) putpixel(page,x,y,4);         
           if((getpixel(aux,x-2,y+2)==4 || getpixel(aux,x-2,y-2)==4) && !Prob(8)) putpixel(page,x,y,4);         
           if((getpixel(aux,x-3,y+1)==4 || getpixel(aux,x-3,y-1)==4) && !Prob(8)) putpixel(page,x,y,4);         
           if((getpixel(aux,x-3,y+2)==4 || getpixel(aux,x-3,y-2)==4) && !Prob(16)) putpixel(page,x,y,4);         
           if((getpixel(aux,x-3,y+3)==4 || getpixel(aux,x-3,y-3)==4) && !Prob(32)) putpixel(page,x,y,4);         
           if(getpixel(aux,x-3,y)==4 && !Prob(4)) putpixel(page,x,y,4);         
          }
         if(vento==2)
          {  
           if(getpixel(aux,x,y-1)==4) putpixel(page,x,y,4);
           if((getpixel(aux,x-1,y-1)==4 || getpixel(aux,x-1,y-1)==4) && !Prob(2)) putpixel(page,x,y,4);         
           if(getpixel(aux,x,y-2)==4 && !Prob(2)) putpixel(page,x,y,4);         
           if((getpixel(aux,x-1,y-2)==4 || getpixel(aux,x+1,y-2)==4) && !Prob(4)) putpixel(page,x,y,4);         
           if((getpixel(aux,x-2,y-2)==4 || getpixel(aux,x+2,y-2)==4) && !Prob(8)) putpixel(page,x,y,4);         
           if((getpixel(aux,x-1,y-3)==4 || getpixel(aux,x+1,y-3)==4) && !Prob(8)) putpixel(page,x,y,4);         
           if((getpixel(aux,x-2,y-3)==4 || getpixel(aux,x+2,y-3)==4) && !Prob(16)) putpixel(page,x,y,4);         
           if((getpixel(aux,x-3,y-3)==4 || getpixel(aux,x+3,y-3)==4) && !Prob(32)) putpixel(page,x,y,4);         
           if(getpixel(aux,x,y-3)==4 && !Prob(4)) putpixel(page,x,y,4);         
          }
         if(vento==3)
          {  
           if(getpixel(aux,x,y+1)==4) putpixel(page,x,y,4);
           if((getpixel(aux,x-1,y+1)==4 || getpixel(aux,x-1,y+1)==4) && !Prob(2)) putpixel(page,x,y,4);         
           if(getpixel(aux,x,y+2)==4 && !Prob(2)) putpixel(page,x,y,4);         
           if((getpixel(aux,x-1,y+2)==4 || getpixel(aux,x+1,y+2)==4) && !Prob(4)) putpixel(page,x,y,4);         
           if((getpixel(aux,x-2,y+2)==4 || getpixel(aux,x+2,y+2)==4) && !Prob(8)) putpixel(page,x,y,4);         
           if((getpixel(aux,x-1,y+3)==4 || getpixel(aux,x+1,y+3)==4) && !Prob(8)) putpixel(page,x,y,4);         
           if((getpixel(aux,x-2,y+3)==4 || getpixel(aux,x+2,y+3)==4) && !Prob(16)) putpixel(page,x,y,4);         
           if((getpixel(aux,x-3,y+3)==4 || getpixel(aux,x+3,y+3)==4) && !Prob(32)) putpixel(page,x,y,4);         
           if(getpixel(aux,x,y+3)==4 && !Prob(4)) putpixel(page,x,y,4);         
          }
        }
      }
    }
 }
